/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.wrap;

import java.util.Iterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.tooling.wrap.WrappedEntity;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;

public abstract class WrappedIndex<T extends PropertyContainer, I extends ReadableIndex<T>>
implements Index<T> {
    final WrappedGraphDatabase graphdb;

    private WrappedIndex(WrappedGraphDatabase graphdb) {
        this.graphdb = graphdb;
    }

    static <T extends PropertyContainer> Index<T> unwrapIndex(Index<T> index) {
        if (index instanceof WrappedIndex) {
            return (Index)((WrappedIndex)index).actual();
        }
        return index;
    }

    protected abstract I actual();

    abstract T wrap(T var1);

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.graphdb;
    }

    public String toString() {
        return this.actual().toString();
    }

    @Override
    public String getName() {
        return this.actual().getName();
    }

    @Override
    public Class<T> getEntityType() {
        return this.actual().getEntityType();
    }

    @Override
    public void add(T entity, String key, Object value) {
        I actual = this.actual();
        if (!(actual instanceof Index)) {
            throw new UnsupportedOperationException();
        }
        ((Index)actual).add(WrappedEntity.unwrap(entity), key, value);
    }

    @Override
    public void remove(T entity, String key, Object value) {
        I actual = this.actual();
        if (!(actual instanceof Index)) {
            throw new UnsupportedOperationException();
        }
        ((Index)actual).remove(WrappedEntity.unwrap(entity), key, value);
    }

    @Override
    public void remove(T entity, String key) {
        I actual = this.actual();
        if (!(actual instanceof Index)) {
            throw new UnsupportedOperationException();
        }
        ((Index)actual).remove(WrappedEntity.unwrap(entity), key);
    }

    @Override
    public void remove(T entity) {
        I actual = this.actual();
        if (!(actual instanceof Index)) {
            throw new UnsupportedOperationException();
        }
        ((Index)actual).remove(WrappedEntity.unwrap(entity));
    }

    @Override
    public void delete() {
        I actual = this.actual();
        if (!(actual instanceof Index)) {
            throw new UnsupportedOperationException();
        }
        ((Index)actual).delete();
    }

    @Override
    public IndexHits<T> get(String key, Object value) {
        return new Hits(this.actual().get(key, value));
    }

    @Override
    public IndexHits<T> query(String key, Object queryOrQueryObject) {
        return new Hits(this.actual().query(key, queryOrQueryObject));
    }

    @Override
    public IndexHits<T> query(Object queryOrQueryObject) {
        return new Hits(this.actual().query(queryOrQueryObject));
    }

    @Override
    public boolean isWriteable() {
        return this.actual().isWriteable();
    }

    @Override
    public T putIfAbsent(T entity, String key, Object value) {
        I actual = this.actual();
        if (actual instanceof Index) {
            return this.wrap(((Index)actual).putIfAbsent(entity, key, value));
        }
        throw new UnsupportedOperationException();
    }

    class Hits
    extends WrappedIndexHits<T> {
        Hits(IndexHits<T> hits) {
            super(hits);
        }

        @Override
        T wrap(T item) {
            return WrappedIndex.this.wrap(item);
        }
    }

    private static abstract class WrappedIndexHits<T>
    implements IndexHits<T> {
        private final IndexHits<T> hits;

        WrappedIndexHits(IndexHits<T> hits) {
            this.hits = hits;
        }

        abstract T wrap(T var1);

        public int hashCode() {
            return this.hits.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WrappedIndexHits) {
                WrappedIndexHits other = (WrappedIndexHits)obj;
                return this.hits.equals(other.hits);
            }
            return false;
        }

        public String toString() {
            return this.hits.toString();
        }

        @Override
        public boolean hasNext() {
            return this.hits.hasNext();
        }

        @Override
        public T next() {
            return (T)this.wrap(this.hits.next());
        }

        @Override
        public void remove() {
            this.hits.remove();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public int size() {
            return this.hits.size();
        }

        @Override
        public void close() {
            this.hits.close();
        }

        @Override
        public T getSingle() {
            T single = this.hits.getSingle();
            if (single == null) {
                return null;
            }
            return this.wrap(single);
        }

        @Override
        public float currentScore() {
            return this.hits.currentScore();
        }
    }

    public static abstract class WrappedRelationshipIndex
    extends WrappedIndex<Relationship, ReadableRelationshipIndex>
    implements RelationshipIndex {
        protected WrappedRelationshipIndex(WrappedGraphDatabase graphdb) {
            super(graphdb);
        }

        protected WrappedGraphDatabase graphdb() {
            return this.graphdb;
        }

        @Override
        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new Hits(((ReadableRelationshipIndex)this.actual()).get(key, valueOrNull, WrappedEntity.unwrap(startNodeOrNull), WrappedEntity.unwrap(endNodeOrNull)));
        }

        @Override
        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new Hits(((ReadableRelationshipIndex)this.actual()).query(key, queryOrQueryObjectOrNull, WrappedEntity.unwrap(startNodeOrNull), WrappedEntity.unwrap(endNodeOrNull)));
        }

        @Override
        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new Hits(((ReadableRelationshipIndex)this.actual()).query(queryOrQueryObjectOrNull, WrappedEntity.unwrap(startNodeOrNull), WrappedEntity.unwrap(endNodeOrNull)));
        }

        @Override
        Relationship wrap(Relationship entity) {
            return this.graphdb.relationship(entity, false);
        }
    }

    public static abstract class WrappedNodeIndex
    extends WrappedIndex<Node, ReadableIndex<Node>> {
        protected WrappedNodeIndex(WrappedGraphDatabase graphdb) {
            super(graphdb);
        }

        protected WrappedGraphDatabase graphdb() {
            return this.graphdb;
        }

        @Override
        Node wrap(Node entity) {
            return this.graphdb.node(entity, false);
        }
    }
}

