/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFilter;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.traversal.StartNodeTraversalBranch;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;

class TraverserImpl
implements Traverser {
    private final TraversalDescriptionImpl description;
    private final Node startNode;

    TraverserImpl(TraversalDescriptionImpl description, Node startNode) {
        this.description = description;
        this.startNode = startNode;
    }

    @Override
    public Iterator<Path> iterator() {
        return new TraverserIterator();
    }

    @Override
    public Iterable<Node> nodes() {
        return new IterableWrapper<Node, Path>((Iterable)this){

            @Override
            protected Node underlyingObjectToObject(Path position) {
                return position.endNode();
            }
        };
    }

    @Override
    public Iterable<Relationship> relationships() {
        return new IterableWrapper<Relationship, Path>((Iterable)this){

            @Override
            public Iterator<Relationship> iterator() {
                Iterator<Relationship> iter = super.iterator();
                if (iter.hasNext()) {
                    Relationship first = (Relationship)iter.next();
                    if (first == null) {
                        return iter;
                    }
                    return new CombiningIterator<Relationship>(first, iter);
                }
                return iter;
            }

            @Override
            protected Relationship underlyingObjectToObject(Path position) {
                return position.lastRelationship();
            }
        };
    }

    class TraverserIterator
    extends PrefetchingIterator<Path> {
        final UniquenessFilter uniquness;
        private final BranchSelector sourceSelector;
        final TraversalDescriptionImpl description;
        final Node startNode;

        TraverserIterator() {
            this.description = TraverserImpl.this.description;
            this.uniquness = this.description.uniqueness.create(this.description.uniquenessParameter);
            this.startNode = TraverserImpl.this.startNode;
            this.sourceSelector = this.description.branchSelector.create(new StartNodeTraversalBranch(this, this.startNode, this.description.expander));
        }

        boolean okToProceedFirst(TraversalBranch source) {
            return this.uniquness.checkFirst(source);
        }

        boolean okToProceed(TraversalBranch source) {
            return this.uniquness.check(source);
        }

        @Override
        protected Path fetchNextOrNull() {
            TraversalBranch result = null;
            do {
                if ((result = this.sourceSelector.next()) != null) continue;
                return null;
            } while (!result.evaluation().includes());
            return result.position();
        }
    }
}

