/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.PropertyData;

public class PropertyDatas {
    public static PropertyData forBoolean(int index, long id, boolean value) {
        return new BooleanPropertyData(index, id, value);
    }

    public static PropertyData forByte(int index, long id, byte value) {
        return new BytePropertyData(index, id, value);
    }

    public static PropertyData forShort(int index, long id, short value) {
        return new ShortPropertyData(index, id, value);
    }

    public static PropertyData forChar(int index, long id, char value) {
        return new CharPropertyData(index, id, value);
    }

    public static PropertyData forInt(int index, long id, int value) {
        return new IntPropertyData(index, id, value);
    }

    public static PropertyData forLong(int index, long id, long value) {
        return new LongPropertyData(index, id, value);
    }

    public static PropertyData forFloat(int index, long id, float value) {
        return new FloatPropertyData(index, id, value);
    }

    public static PropertyData forDouble(int index, long id, double value) {
        return new DoublePropertyData(index, id, value);
    }

    public static PropertyData forStringOrArray(int index, long id, Object value) {
        return new ObjectPropertyData(index, id, value);
    }

    private static class ObjectPropertyData
    implements PropertyData {
        private final long id;
        private Object value;
        private final int index;

        public ObjectPropertyData(int index, long id, Object value) {
            this.index = index;
            this.id = id;
            this.value = value;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setNewValue(Object newValue) {
            this.value = newValue;
        }
    }

    private static class DoublePropertyData
    extends PrimitivePropertyData {
        private final double value;

        private DoublePropertyData(int index, long id, double value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class FloatPropertyData
    extends PrimitivePropertyData {
        private final float value;

        private FloatPropertyData(int index, long id, float value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.value);
        }
    }

    private static class LongPropertyData
    extends PrimitivePropertyData {
        private final long value;

        private LongPropertyData(int index, long id, long value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class IntPropertyData
    extends PrimitivePropertyData {
        private final int value;

        private IntPropertyData(int index, long id, int value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class CharPropertyData
    extends PrimitivePropertyData {
        private final char value;

        private CharPropertyData(int index, long id, char value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return Character.valueOf(this.value);
        }
    }

    private static class ShortPropertyData
    extends PrimitivePropertyData {
        private final short value;

        private ShortPropertyData(int index, long id, short value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class BytePropertyData
    extends PrimitivePropertyData {
        private final byte value;

        private BytePropertyData(int index, long id, byte value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class BooleanPropertyData
    extends PrimitivePropertyData {
        private final boolean value;

        private BooleanPropertyData(int index, long id, boolean value) {
            super(index, id);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static abstract class PrimitivePropertyData
    implements PropertyData {
        private final int index;
        private final long id;

        PrimitivePropertyData(int index, long id) {
            this.index = index;
            this.id = id;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setNewValue(Object newValue) {
            throw new IllegalStateException("This shouldn't be called, only valid on String/array types");
        }
    }
}

