/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;

public class RelationshipTypeStore
extends AbstractNameStore<RelationshipTypeRecord> {
    public static final String TYPE_DESCRIPTOR = "RelationshipTypeStore";
    private static final int RECORD_SIZE = 5;

    public RelationshipTypeStore(String fileName, Map<?, ?> config) {
        super(fileName, config, IdType.RELATIONSHIP_TYPE);
    }

    @Override
    public void accept(RecordStore.Processor processor, RelationshipTypeRecord record) {
        processor.processRelationshipType(this, record);
    }

    public static void createStore(String fileName, Map<?, ?> config) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        FileSystemAbstraction fileSystem = (FileSystemAbstraction)config.get(FileSystemAbstraction.class);
        RelationshipTypeStore.createEmptyStore(fileName, RelationshipTypeStore.buildTypeDescriptorAndVersion(TYPE_DESCRIPTOR), idGeneratorFactory, fileSystem);
        DynamicStringStore.createStore(fileName + ".names", 30, idGeneratorFactory, fileSystem, IdType.RELATIONSHIP_TYPE_BLOCK);
        RelationshipTypeStore store = new RelationshipTypeStore(fileName, config);
        store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsReserved(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.WRITE);
        try {
            this.markAsReserved(id, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private void markAsReserved(int id, PersistenceWindow window) {
        Buffer buffer = window.getOffsettedBuffer(id);
        buffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
    }

    @Override
    protected void rebuildIdGenerator() {
        logger.fine("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        File file = new File(this.getStorageFileName() + ".id");
        if (file.exists()) {
            boolean success = file.delete();
            assert (success);
        }
        this.createIdGenerator(this.getStorageFileName() + ".id");
        this.openIdGenerator(false);
        FileChannel fileChannel = this.getFileChannel();
        long highId = -1L;
        int recordSize = this.getRecordSize();
        try {
            long fileSize = fileChannel.size();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[recordSize]);
            int i = 0;
            while ((long)(i * recordSize) < fileSize) {
                fileChannel.read(byteBuffer, i * recordSize);
                byteBuffer.flip();
                byte inUse = byteBuffer.get();
                byteBuffer.flip();
                if (inUse != Record.IN_USE.byteValue()) {
                    byteBuffer.clear();
                    byteBuffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
                    byteBuffer.flip();
                    fileChannel.write(byteBuffer, i * recordSize);
                    byteBuffer.clear();
                } else {
                    highId = i;
                }
                ++i;
            }
            fileChannel.truncate(++highId * (long)recordSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId);
        logger.fine("[" + this.getStorageFileName() + "] high id=" + this.getHighId());
        this.closeIdGenerator();
        this.openIdGenerator(false);
    }

    @Override
    protected RelationshipTypeRecord newRecord(int id) {
        return new RelationshipTypeRecord(id);
    }

    @Override
    protected IdType getNameIdType() {
        return IdType.RELATIONSHIP_TYPE_BLOCK;
    }

    @Override
    protected String getNameStorePostfix() {
        return ".names";
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

