/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

public class PropertyIndexStore
extends AbstractNameStore<PropertyIndexRecord> {
    public static final String TYPE_DESCRIPTOR = "PropertyIndexStore";
    private static final int RECORD_SIZE = 9;

    public PropertyIndexStore(String fileName, Map<?, ?> config) {
        super(fileName, config, IdType.PROPERTY_INDEX);
    }

    @Override
    public void accept(RecordStore.Processor processor, PropertyIndexRecord record) {
        processor.processPropertyIndex(this, record);
    }

    public static void createStore(String fileName, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystem) {
        PropertyIndexStore.createEmptyStore(fileName, PropertyIndexStore.buildTypeDescriptorAndVersion(TYPE_DESCRIPTOR), idGeneratorFactory, fileSystem);
        DynamicStringStore.createStore(fileName + ".keys", 30, idGeneratorFactory, fileSystem, IdType.PROPERTY_INDEX_BLOCK);
    }

    @Override
    protected PropertyIndexRecord newRecord(int id) {
        return new PropertyIndexRecord(id);
    }

    @Override
    protected void readRecord(PropertyIndexRecord record, Buffer buffer) {
        record.setPropertyCount(buffer.getInt());
        record.setNameId(buffer.getInt());
    }

    @Override
    protected void writeRecord(PropertyIndexRecord record, Buffer buffer) {
        buffer.putInt(record.getPropertyCount());
        buffer.putInt(record.getNameId());
    }

    @Override
    protected IdType getNameIdType() {
        return IdType.PROPERTY_INDEX_BLOCK;
    }

    @Override
    protected String getNameStorePostfix() {
        return ".keys";
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

