/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumSet;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.util.Bits;

public enum LongerShortString {
    NUMERICAL(1, 4){

        @Override
        int encTranslate(byte b) {
            if (b >= 48 && b <= 57) {
                return b - 48;
            }
            switch (b) {
                case 0: {
                    return 10;
                }
                case 2: {
                    return 11;
                }
                case 3: {
                    return 12;
                }
                case 6: {
                    return 13;
                }
                case 7: {
                    return 14;
                }
                case 8: {
                    return 15;
                }
            }
            throw this.cannotEncode(b);
        }

        @Override
        int encPunctuation(byte b) {
            throw this.cannotEncode(b);
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint < 10) {
                return (char)(codePoint + 48);
            }
            return this.decPunctuation(codePoint - 10 + 6);
        }
    }
    ,
    DATE(2, 4){

        @Override
        int encTranslate(byte b) {
            if (b >= 48 && b <= 57) {
                return b - 48;
            }
            switch (b) {
                case 0: {
                    return 10;
                }
                case 3: {
                    return 11;
                }
                case 4: {
                    return 12;
                }
                case 5: {
                    return 13;
                }
                case 6: {
                    return 14;
                }
                case 7: {
                    return 15;
                }
            }
            throw this.cannotEncode(b);
        }

        @Override
        int encPunctuation(byte b) {
            throw this.cannotEncode(b);
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint < 10) {
                return (char)(codePoint + 48);
            }
            switch (codePoint) {
                case 10: {
                    return ' ';
                }
                case 11: {
                    return '-';
                }
                case 12: {
                    return ':';
                }
                case 13: {
                    return '/';
                }
                case 14: {
                    return '+';
                }
            }
            return ',';
        }
    }
    ,
    UPPER(3, 5){

        @Override
        int encTranslate(byte b) {
            return super.encTranslate(b) - 64;
        }

        @Override
        int encPunctuation(byte b) {
            return b == 0 ? 64 : b + 90;
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint == 0) {
                return ' ';
            }
            if (codePoint <= 26) {
                return (char)(codePoint + 65 - 1);
            }
            return this.decPunctuation(codePoint - 26);
        }
    }
    ,
    LOWER(4, 5){

        @Override
        int encTranslate(byte b) {
            return super.encTranslate(b) - 96;
        }

        @Override
        int encPunctuation(byte b) {
            return b == 0 ? 96 : b + 122;
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint == 0) {
                return ' ';
            }
            if (codePoint <= 26) {
                return (char)(codePoint + 97 - 1);
            }
            return this.decPunctuation(codePoint - 26);
        }
    }
    ,
    EMAIL(5, 5){

        @Override
        int encTranslate(byte b) {
            return super.encTranslate(b) - 96;
        }

        @Override
        int encPunctuation(byte b) {
            int encOffset = 96;
            if (b == 7) {
                return encOffset;
            }
            int offset = encOffset + 27;
            switch (b) {
                case 1: {
                    return 0 + offset;
                }
                case 2: {
                    return 1 + offset;
                }
                case 3: {
                    return 2 + offset;
                }
                case 6: {
                    return 3 + offset;
                }
                case 9: {
                    return 4 + offset;
                }
            }
            throw this.cannotEncode(b);
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint == 0) {
                return ',';
            }
            if (codePoint <= 26) {
                return (char)(codePoint + 97 - 1);
            }
            switch (codePoint) {
                case 30: {
                    return '+';
                }
                case 31: {
                    return '@';
                }
            }
            return this.decPunctuation(codePoint - 26);
        }
    }
    ,
    URI(6, 6){

        @Override
        int encTranslate(byte b) {
            if (b == 0) {
                return 0;
            }
            if (b >= 97 && b <= 122) {
                return b - 96;
            }
            if (b >= 48 && b <= 57) {
                return b - 16;
            }
            if (b >= 1 && b <= 22) {
                return b + 41;
            }
            throw this.cannotEncode(b);
        }

        @Override
        int encPunctuation(byte b) {
            throw this.cannotEncode(b);
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint == 0) {
                return ' ';
            }
            if (codePoint <= 26) {
                return (char)(codePoint + 97 - 1);
            }
            if (codePoint <= 41) {
                return (char)(codePoint - 32 + 48);
            }
            if (codePoint <= 46) {
                return this.decPunctuation(codePoint - 41);
            }
            return this.decPunctuation(codePoint - 47 + 9);
        }
    }
    ,
    ALPHANUM(7, 6){

        @Override
        char decTranslate(byte codePoint) {
            return EUROPEAN.decTranslate((byte)(codePoint + 64));
        }

        @Override
        int encTranslate(byte b) {
            if (b < 32) {
                return this.encPunctuation(b);
            }
            return EUROPEAN.encTranslate(b) - 64;
        }

        @Override
        int encPunctuation(byte b) {
            switch (b) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 32;
                }
            }
            throw this.cannotEncode(b);
        }
    }
    ,
    ALPHASYM(8, 6){

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint == 0) {
                return ' ';
            }
            if (codePoint <= 26) {
                return (char)(65 + codePoint - 1);
            }
            if (codePoint <= 31) {
                return this.decPunctuation(codePoint - 27 + 1);
            }
            if (codePoint == 32) {
                return ';';
            }
            if (codePoint <= 58) {
                return (char)(97 + codePoint - 33);
            }
            return this.decPunctuation(codePoint - 59 + 9);
        }

        @Override
        int encTranslate(byte b) {
            if (b < 32) {
                return this.encPunctuation(b);
            }
            return b - 64;
        }

        @Override
        int encPunctuation(byte b) {
            switch (b) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 27;
                }
                case 2: {
                    return 28;
                }
                case 3: {
                    return 29;
                }
                case 4: {
                    return 30;
                }
                case 5: {
                    return 31;
                }
                case 6: {
                    return 59;
                }
                case 7: {
                    return 60;
                }
                case 8: {
                    return 61;
                }
                case 9: {
                    return 62;
                }
                case 10: {
                    return 63;
                }
                case 11: {
                    return 32;
                }
            }
            throw this.cannotEncode(b);
        }
    }
    ,
    EUROPEAN(9, 7){

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint < 64) {
                if (codePoint == 23) {
                    return '.';
                }
                if (codePoint == 55) {
                    return '-';
                }
                return (char)(codePoint + 192);
            }
            if (codePoint == 64) {
                return ' ';
            }
            if (codePoint == 96) {
                return '_';
            }
            if (codePoint >= 91 && codePoint < 96) {
                return (char)(48 + codePoint - 91);
            }
            if (codePoint >= 123 && codePoint < 128) {
                return (char)(53 + codePoint - 123);
            }
            return (char)codePoint;
        }

        @Override
        int encPunctuation(byte b) {
            switch (b) {
                case 0: {
                    return 64;
                }
                case 1: {
                    return 96;
                }
                case 2: {
                    return 23;
                }
                case 3: {
                    return 55;
                }
                case 7: {
                    return 0;
                }
            }
            throw this.cannotEncode(b);
        }
    };

    final int encodingHeader;
    final short mask;
    final short step;
    private static final char[] PUNCTUATION;

    private LongerShortString(int encodingHeader, int step) {
        this.encodingHeader = encodingHeader;
        this.mask = (short)Bits.rightOverflowMask(step);
        this.step = (short)step;
    }

    int maxLength(int payloadSize) {
        return ((payloadSize << 3) - 24 - 4 - 4 - 6) / this.step;
    }

    final IllegalArgumentException cannotEncode(byte b) {
        return new IllegalArgumentException("Cannot encode as " + this.name() + ": " + b);
    }

    final char decPunctuation(int code) {
        return PUNCTUATION[code];
    }

    int encTranslate(byte b) {
        if (b < 0) {
            return (0xFF & b) - 192;
        }
        if (b < 32) {
            return this.encPunctuation(b);
        }
        if (b >= 48 && b <= 52) {
            return 91 + b - 48;
        }
        if (b >= 53 && b <= 57) {
            return 123 + b - 53;
        }
        return b;
    }

    abstract int encPunctuation(byte var1);

    abstract char decTranslate(byte var1);

    public static boolean encode(int keyId, String string, PropertyBlock target, int payloadSize) {
        int stringLength = string.length();
        if (stringLength > NUMERICAL.maxLength(payloadSize) || stringLength > 63) {
            return false;
        }
        EnumSet<LongerShortString> possible = null;
        byte[] data = new byte[stringLength];
        if (possible == null) {
            possible = EnumSet.allOf(LongerShortString.class);
            for (LongerShortString possibility : LongerShortString.values()) {
                if (data.length <= possibility.maxLength(payloadSize)) continue;
                possible.remove((Object)possibility);
            }
        }
        block26: for (int i = 0; i < data.length && !possible.isEmpty(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    data[i] = 0;
                    possible.remove((Object)EMAIL);
                    continue block26;
                }
                case '_': {
                    data[i] = 1;
                    possible.removeAll(EnumSet.of(NUMERICAL, DATE));
                    continue block26;
                }
                case '.': {
                    data[i] = 2;
                    possible.removeAll(EnumSet.of(ALPHANUM, DATE));
                    continue block26;
                }
                case '-': {
                    data[i] = 3;
                    possible.remove((Object)ALPHANUM);
                    continue block26;
                }
                case ':': {
                    data[i] = 4;
                    possible.removeAll(EnumSet.of(ALPHANUM, NUMERICAL, EUROPEAN, EMAIL));
                    continue block26;
                }
                case '/': {
                    data[i] = 5;
                    possible.removeAll(EnumSet.of(ALPHANUM, NUMERICAL, EUROPEAN, EMAIL));
                    continue block26;
                }
                case '+': {
                    data[i] = 6;
                    possible.retainAll(EnumSet.of(NUMERICAL, DATE, EMAIL, URI, ALPHASYM));
                    continue block26;
                }
                case ',': {
                    data[i] = 7;
                    possible.retainAll(EnumSet.of(NUMERICAL, DATE, EMAIL, URI, ALPHASYM));
                    continue block26;
                }
                case '\'': {
                    data[i] = 8;
                    possible.retainAll(EnumSet.of(NUMERICAL, URI, ALPHASYM));
                    continue block26;
                }
                case '@': {
                    data[i] = 9;
                    possible.retainAll(EnumSet.of(EMAIL, URI, ALPHASYM));
                    continue block26;
                }
                case '|': {
                    data[i] = 10;
                    possible.retainAll(EnumSet.of(ALPHASYM));
                    continue block26;
                }
                case ';': {
                    data[i] = 11;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '*': {
                    data[i] = 12;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '?': {
                    data[i] = 13;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '&': {
                    data[i] = 14;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '%': {
                    data[i] = 15;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '#': {
                    data[i] = 16;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '(': {
                    data[i] = 17;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case ')': {
                    data[i] = 18;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '$': {
                    data[i] = 19;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '<': {
                    data[i] = 20;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '>': {
                    data[i] = 21;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                case '=': {
                    data[i] = 22;
                    possible.retainAll(EnumSet.of(URI));
                    continue block26;
                }
                default: {
                    if (c >= 'A' && c <= 'Z') {
                        possible.removeAll(EnumSet.of(NUMERICAL, DATE, LOWER, EMAIL, URI));
                    } else if (c >= 'a' && c <= 'z') {
                        possible.removeAll(EnumSet.of(NUMERICAL, DATE, UPPER));
                    } else if (c >= '0' && c <= '9') {
                        possible.removeAll(EnumSet.of(UPPER, LOWER, EMAIL, ALPHASYM));
                    } else if (c >= '\u00c0' && c <= '\u00ff' && c != '\u00d7' && c != '\u00f7') {
                        possible.retainAll(EnumSet.of(EUROPEAN));
                    } else {
                        possible.clear();
                        break block26;
                    }
                    data[i] = (byte)c;
                }
            }
        }
        for (LongerShortString encoding : possible) {
            if (!encoding.doEncode(keyId, data, target, payloadSize)) continue;
            return true;
        }
        int maxBytes = PropertyType.getPayloadSize();
        if (stringLength <= maxBytes - 5) {
            if (LongerShortString.encodeLatin1(keyId, string, target)) {
                return true;
            }
            if (LongerShortString.encodeUTF8(keyId, string, target, payloadSize)) {
                return true;
            }
        }
        return false;
    }

    private static void writeHeader(Bits bits, int keyId, int encoding, int stringLength) {
        bits.put(keyId, 24).put(PropertyType.SHORT_STRING.intValue(), 4).put(encoding, 5).put(stringLength, 6);
    }

    public static String decode(PropertyBlock block) {
        Bits bits = Bits.bitsFromLongs(Arrays.copyOf(block.getValueBlocks(), block.getValueBlocks().length));
        long firstLong = bits.getLongs()[0];
        if ((firstLong & 0xFFFFFF0FFFFFFFFFL) == 0L) {
            return "";
        }
        bits.getInt(24);
        bits.getByte(4);
        byte encoding = bits.getByte(5);
        byte stringLength = bits.getByte(6);
        if (encoding == 0) {
            return LongerShortString.decodeUTF8(bits, stringLength);
        }
        if (encoding == 10) {
            return LongerShortString.decodeLatin1(bits, stringLength);
        }
        LongerShortString table = LongerShortString.getEncodingTable(encoding);
        char[] result = new char[stringLength];
        for (int i = 0; i < result.length; ++i) {
            byte codePoint = bits.getByte(table.step);
            result[i] = table.decTranslate(codePoint);
        }
        return new String(result);
    }

    private static LongerShortString getEncodingTable(int encoding) {
        LongerShortString table;
        switch (encoding) {
            case 1: {
                table = NUMERICAL;
                break;
            }
            case 2: {
                table = DATE;
                break;
            }
            case 3: {
                table = UPPER;
                break;
            }
            case 4: {
                table = LOWER;
                break;
            }
            case 5: {
                table = EMAIL;
                break;
            }
            case 6: {
                table = URI;
                break;
            }
            case 7: {
                table = ALPHANUM;
                break;
            }
            case 8: {
                table = ALPHASYM;
                break;
            }
            case 9: {
                table = EUROPEAN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid encoding '" + encoding + "'");
            }
        }
        return table;
    }

    private static Bits newBits(int encoding, int length) {
        return Bits.bits(LongerShortString.calculateNumberOfBlocksUsed(encoding, length) * 8);
    }

    private static boolean encodeLatin1(int keyId, String string, PropertyBlock target) {
        int length = string.length();
        Bits bits = LongerShortString.newBits(10, length);
        LongerShortString.writeHeader(bits, keyId, 10, length);
        if (!LongerShortString.writeLatin1Characters(string, bits)) {
            return false;
        }
        target.setValueBlocks(bits.getLongs());
        return true;
    }

    public static boolean writeLatin1Characters(String string, Bits bits) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c >= '\u0100') {
                return false;
            }
            bits.put(c, 8);
        }
        return true;
    }

    private static boolean encodeUTF8(int keyId, String string, PropertyBlock target, int payloadSize) {
        try {
            byte[] bytes = string.getBytes("UTF-8");
            if (bytes.length > payloadSize - 3 - 2) {
                return false;
            }
            Bits bits = LongerShortString.newBits(0, bytes.length);
            LongerShortString.writeHeader(bits, keyId, 0, bytes.length);
            for (byte value : bytes) {
                bits.put(value);
            }
            target.setValueBlocks(bits.getLongs());
            return true;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("All JVMs must support UTF-8", e);
        }
    }

    private boolean doEncode(int keyId, byte[] data, PropertyBlock target, int payloadSize) {
        if (data.length > this.maxLength(payloadSize)) {
            return false;
        }
        Bits bits = LongerShortString.newBits(this.encodingHeader, data.length);
        LongerShortString.writeHeader(bits, keyId, this.encodingHeader, data.length);
        for (int i = 0; i < data.length; ++i) {
            int encodedChar = this.encTranslate(data[i]);
            bits.put(encodedChar, (int)this.step);
        }
        target.setValueBlocks(bits.getLongs());
        return true;
    }

    private static String decodeLatin1(Bits bits, int stringLength) {
        char[] result = new char[stringLength];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    private static String decodeUTF8(Bits bits, int stringLength) {
        byte[] result = new byte[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            result[i] = bits.getByte();
        }
        try {
            return new String(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("All JVMs must support UTF-8", e);
        }
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        int encoding = (int)((firstBlock & 0x1F0000000L) >> 28);
        int length = (int)((firstBlock & 0x7E00000000L) >> 33);
        return LongerShortString.calculateNumberOfBlocksUsed(encoding, length);
    }

    public static int calculateNumberOfBlocksUsed(int encoding, int length) {
        int bitsForCharacters = 0;
        bitsForCharacters = encoding == 0 || encoding == 10 ? length * 8 : LongerShortString.getEncodingTable((int)encoding).step * length;
        int bitsInTotal = 39 + bitsForCharacters;
        int result = (bitsInTotal - 1) / 64 + 1;
        return result;
    }

    static {
        PUNCTUATION = new char[]{' ', '_', '.', '-', ':', '/', ' ', '.', '-', '+', ',', '\'', '@', '|', ';', '*', '?', '&', '%', '#', '(', ')', '$', '<', '>', '='};
    }
}

