/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.util.ArrayIntSet;

class RelationshipArrayIntSetIterator
implements Iterable<Relationship>,
Iterator<Relationship> {
    private Logger log = Logger.getLogger(RelationshipArrayIntSetIterator.class.getName());
    private Iterator<Integer> relIds;
    private Node fromNode;
    private Direction direction = null;
    private Relationship nextElement = null;
    private final NodeManager nodeManager;

    RelationshipArrayIntSetIterator(ArrayIntSet relIds, Node fromNode, Direction direction, NodeManager nodeManager) {
        this.relIds = relIds.iterator();
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
    }

    RelationshipArrayIntSetIterator(Iterator<Integer> relIds, Node fromNode, Direction direction, NodeManager nodeManager) {
        this.relIds = relIds;
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return new RelationshipArrayIntSetIterator(this.relIds, this.fromNode, this.direction, this.nodeManager);
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement != null) {
            return true;
        }
        do {
            if (!this.relIds.hasNext()) continue;
            int nextId = this.relIds.next();
            try {
                Relationship possibleElement = this.nodeManager.getRelationshipById(nextId);
                if (this.direction == Direction.INCOMING && possibleElement.getEndNode().equals(this.fromNode)) {
                    this.nextElement = possibleElement;
                    continue;
                }
                if (this.direction == Direction.OUTGOING && possibleElement.getStartNode().equals(this.fromNode)) {
                    this.nextElement = possibleElement;
                    continue;
                }
                if (this.direction != Direction.BOTH) continue;
                this.nextElement = possibleElement;
            }
            catch (Throwable t) {
                this.log.log(Level.FINE, "Unable to get relationship " + nextId, t);
            }
        } while (this.nextElement == null && this.relIds.hasNext());
        return this.nextElement != null;
    }

    @Override
    public Relationship next() {
        this.hasNext();
        if (this.nextElement != null) {
            Relationship elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

