/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.graphdb.traversal.UniquenessFilter;
import org.neo4j.kernel.GloballyUnique;
import org.neo4j.kernel.NotUnique;
import org.neo4j.kernel.PathUnique;
import org.neo4j.kernel.PrimitiveTypeFetcher;
import org.neo4j.kernel.RecentlyUnique;

public enum Uniqueness implements UniquenessFactory
{
    NODE_GLOBAL{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new GloballyUnique(PrimitiveTypeFetcher.NODE);
        }
    }
    ,
    NODE_PATH{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new PathUnique(PrimitiveTypeFetcher.NODE);
        }
    }
    ,
    NODE_RECENT{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptIntegerOrNull(optionalParameter);
            return new RecentlyUnique(PrimitiveTypeFetcher.NODE, optionalParameter);
        }
    }
    ,
    RELATIONSHIP_GLOBAL{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new GloballyUnique(PrimitiveTypeFetcher.RELATIONSHIP);
        }
    }
    ,
    RELATIONSHIP_PATH{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new PathUnique(PrimitiveTypeFetcher.RELATIONSHIP);
        }
    }
    ,
    RELATIONSHIP_RECENT{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptIntegerOrNull(optionalParameter);
            return new RecentlyUnique(PrimitiveTypeFetcher.RELATIONSHIP, optionalParameter);
        }
    }
    ,
    NONE{
        private UniquenessFilter instance = new NotUnique();

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return this.instance;
        }
    };


    private static void acceptNull(Object optionalParameter) {
        if (optionalParameter != null) {
            throw new IllegalArgumentException("Only accepts null parameter, was " + optionalParameter);
        }
    }

    private static void acceptIntegerOrNull(Object parameter) {
        boolean isDecimalNumber;
        if (parameter == null) {
            return;
        }
        boolean bl = isDecimalNumber = parameter instanceof Number && !(parameter instanceof Float) && !(parameter instanceof Double);
        if (!isDecimalNumber) {
            throw new IllegalArgumentException("Doesn't accept non-decimal values, like '" + parameter + "'");
        }
    }
}

