/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.wrap;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.tooling.wrap.TransactionNotAllowedException;
import org.neo4j.tooling.wrap.WrappedEventHandler;
import org.neo4j.tooling.wrap.WrappedIndex;
import org.neo4j.tooling.wrap.WrappedNode;
import org.neo4j.tooling.wrap.WrappedObject;
import org.neo4j.tooling.wrap.WrappedRelationship;

public abstract class WrappedGraphDatabase
extends AbstractGraphDatabase {
    protected final GraphDatabaseService graphdb;
    private final Map<TransactionEventHandler<?>, TransactionEventHandler<?>> handlers = new IdentityHashMap();
    private final IndexManager indexManager = new IndexManager(){

        @Override
        public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value) {
            return WrappedGraphDatabase.this.graphdb.index().setConfiguration(WrappedIndex.unwrapIndex(index), key, value);
        }

        @Override
        public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
            return WrappedGraphDatabase.this.graphdb.index().removeConfiguration(WrappedIndex.unwrapIndex(index), key);
        }

        @Override
        public String[] relationshipIndexNames() {
            return WrappedGraphDatabase.this.graphdb.index().relationshipIndexNames();
        }

        @Override
        public String[] nodeIndexNames() {
            return WrappedGraphDatabase.this.graphdb.index().nodeIndexNames();
        }

        @Override
        public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
            return WrappedGraphDatabase.this.graphdb.index().getConfiguration(WrappedIndex.unwrapIndex(index));
        }

        @Override
        public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
            return WrappedGraphDatabase.this.relationshipIndex(WrappedGraphDatabase.this.graphdb.index().forRelationships(indexName, customConfiguration), indexName);
        }

        @Override
        public RelationshipIndex forRelationships(String indexName) {
            return WrappedGraphDatabase.this.relationshipIndex(WrappedGraphDatabase.this.graphdb.index().forRelationships(indexName), indexName);
        }

        @Override
        public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
            return WrappedGraphDatabase.this.nodeIndex(WrappedGraphDatabase.this.graphdb.index().forNodes(indexName, customConfiguration), indexName);
        }

        @Override
        public Index<Node> forNodes(String indexName) {
            return WrappedGraphDatabase.this.nodeIndex(WrappedGraphDatabase.this.graphdb.index().forNodes(indexName), indexName);
        }

        @Override
        public boolean existsForRelationships(String indexName) {
            return WrappedGraphDatabase.this.graphdb.index().existsForRelationships(indexName);
        }

        @Override
        public boolean existsForNodes(String indexName) {
            return WrappedGraphDatabase.this.graphdb.index().existsForNodes(indexName);
        }

        @Override
        public AutoIndexer<Node> getNodeAutoIndexer() {
            return WrappedGraphDatabase.this.autoNodeIndex;
        }

        @Override
        public RelationshipAutoIndexer getRelationshipAutoIndexer() {
            return WrappedGraphDatabase.this.autoRelationshipIndex;
        }
    };
    private final AutoIndexer<Node> autoNodeIndex = new WrappedAutoIndexer<Node>(){

        @Override
        AutoIndexer<Node> actual() {
            return WrappedGraphDatabase.this.graphdb.index().getNodeAutoIndexer();
        }

        @Override
        public ReadableIndex<Node> getAutoIndex() {
            return WrappedGraphDatabase.this.automaticNodeIndex(this.actual().getAutoIndex());
        }
    };
    private final RelationshipAutoIndexer autoRelationshipIndex = new WrappedRelationshipAutoIndex();
    private static final String NOT_AGD = "Underlying graph database is not an AbstractGraphDatabase";

    public WrappedGraphDatabase(GraphDatabaseService graphdb) {
        super(WrappedGraphDatabase.storeDirOf(graphdb));
        this.graphdb = graphdb;
    }

    private static String storeDirOf(GraphDatabaseService graphdb) {
        graphdb.getClass();
        if (graphdb instanceof AbstractGraphDatabase) {
            return ((AbstractGraphDatabase)graphdb).getStoreDir();
        }
        return ".";
    }

    @Override
    protected StringLogger createStringLogger() {
        if (this.graphdb instanceof AbstractGraphDatabase) {
            return ((AbstractGraphDatabase)this.graphdb).getMessageLog();
        }
        return super.createStringLogger();
    }

    public final int hashCode() {
        return this.graphdb.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj || this.getClass().isInstance(obj) && this.graphdb.equals(((WrappedGraphDatabase)obj).graphdb);
    }

    @Override
    public final String toString() {
        return this.graphdb.toString();
    }

    protected abstract WrappedNode<? extends WrappedGraphDatabase> node(Node var1, boolean var2);

    protected abstract WrappedRelationship<? extends WrappedGraphDatabase> relationship(Relationship var1, boolean var2);

    protected Lock lock(Lock lock) {
        return lock;
    }

    Iterable<Node> nodes(Iterable<Node> nodes) {
        return new IterableWrapper<Node, Node>(nodes){

            @Override
            protected Node underlyingObjectToObject(Node object) {
                return WrappedGraphDatabase.this.node(object, false);
            }
        };
    }

    Iterable<Relationship> relationships(Iterable<Relationship> relationships) {
        return new IterableWrapper<Relationship, Relationship>(relationships){

            @Override
            protected Relationship underlyingObjectToObject(Relationship object) {
                return WrappedGraphDatabase.this.relationship(object, false);
            }
        };
    }

    protected WrappedIndex.WrappedNodeIndex nodeIndex(final Index<Node> index, String indexName) {
        return new WrappedIndex.WrappedNodeIndex(this){

            @Override
            protected ReadableIndex<Node> actual() {
                return index;
            }
        };
    }

    protected WrappedIndex.WrappedRelationshipIndex relationshipIndex(final RelationshipIndex index, String indexName) {
        return new WrappedIndex.WrappedRelationshipIndex(this){

            @Override
            protected ReadableRelationshipIndex actual() {
                return index;
            }
        };
    }

    protected WrappedIndex.WrappedNodeIndex automaticNodeIndex(final ReadableIndex<Node> index) {
        return new WrappedIndex.WrappedNodeIndex(this){

            @Override
            protected ReadableIndex<Node> actual() {
                return index;
            }
        };
    }

    protected WrappedIndex.WrappedRelationshipIndex automaticRelationshipIndex(final ReadableRelationshipIndex index) {
        return new WrappedIndex.WrappedRelationshipIndex(this){

            @Override
            protected ReadableRelationshipIndex actual() {
                return index;
            }
        };
    }

    protected void onBeginTransaction() throws TransactionNotAllowedException {
    }

    protected void onSuccessTransaction() {
    }

    protected void onFailureTransaction() {
    }

    protected void onFinishTransaction() {
    }

    protected void onNodeCreate() {
    }

    protected void onShutdown() {
    }

    @Override
    public final Transaction beginTx() {
        boolean openTx;
        if (this.graphdb instanceof AbstractGraphDatabase) {
            return (WrappedTransaction)super.beginTx();
        }
        try {
            this.onBeginTransaction();
            openTx = true;
        }
        catch (TransactionNotAllowedException exception) {
            exception.throwCause();
            openTx = false;
        }
        return new WrappedTransaction(this, openTx ? this.graphdb.beginTx() : null);
    }

    @Override
    public final Node createNode() {
        this.onNodeCreate();
        return this.node(this.graphdb.createNode(), true);
    }

    @Override
    public final Node getNodeById(long id) {
        return this.node(this.graphdb.getNodeById(id), false);
    }

    @Override
    public final Relationship getRelationshipById(long id) {
        return this.relationship(this.graphdb.getRelationshipById(id), false);
    }

    @Override
    public final Node getReferenceNode() {
        return this.node(this.graphdb.getReferenceNode(), false);
    }

    @Override
    public final Iterable<Node> getAllNodes() {
        return this.nodes(this.graphdb.getAllNodes());
    }

    @Override
    public final Iterable<RelationshipType> getRelationshipTypes() {
        return this.graphdb.getRelationshipTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void close() {
        try {
            this.onShutdown();
        }
        finally {
            this.graphdb.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        TransactionEventHandler<?> wrapped;
        Map<TransactionEventHandler<?>, TransactionEventHandler<?>> map = this.handlers;
        synchronized (map) {
            wrapped = this.handlers.get(handler);
            if (wrapped == null) {
                wrapped = new WrappedEventHandler(this, handler);
                this.handlers.put(handler, wrapped);
            }
        }
        this.graphdb.registerTransactionEventHandler(wrapped);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        TransactionEventHandler<Object> wrapped;
        Map<TransactionEventHandler<?>, TransactionEventHandler<?>> map = this.handlers;
        synchronized (map) {
            wrapped = this.handlers.get(handler);
        }
        if (wrapped == null) {
            wrapped = handler;
        }
        this.graphdb.unregisterTransactionEventHandler(wrapped);
        return handler;
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.graphdb.registerKernelEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.graphdb.unregisterKernelEventHandler(handler);
    }

    @Override
    public IndexManager index() {
        return this.indexManager;
    }

    @Override
    public TransactionBuilder tx() {
        if (this.graphdb instanceof AbstractGraphDatabase) {
            return new WrappedTransactionBuilder(this, ((AbstractGraphDatabase)this.graphdb).tx());
        }
        throw new UnsupportedOperationException(NOT_AGD);
    }

    @Override
    public Config getConfig() {
        if (this.graphdb instanceof AbstractGraphDatabase) {
            return ((AbstractGraphDatabase)this.graphdb).getConfig();
        }
        throw new UnsupportedOperationException(NOT_AGD);
    }

    @Override
    public <T> Collection<T> getManagementBeans(Class<T> type) {
        if (this.graphdb instanceof AbstractGraphDatabase) {
            return ((AbstractGraphDatabase)this.graphdb).getManagementBeans(type);
        }
        throw new UnsupportedOperationException(NOT_AGD);
    }

    @Override
    public KernelData getKernelData() {
        if (this.graphdb instanceof AbstractGraphDatabase) {
            return ((AbstractGraphDatabase)this.graphdb).getKernelData();
        }
        throw new UnsupportedOperationException(NOT_AGD);
    }

    private static class WrappedTransaction
    extends WrappedObject<Transaction>
    implements Transaction {
        WrappedTransaction(WrappedGraphDatabase graphdb, Transaction tx) {
            super(graphdb, tx);
        }

        @Override
        public Lock acquireReadLock(PropertyContainer entity) {
            return this.graphdb.lock(((Transaction)this.wrapped).acquireReadLock(entity));
        }

        @Override
        public Lock acquireWriteLock(PropertyContainer entity) {
            return this.graphdb.lock(((Transaction)this.wrapped).acquireWriteLock(entity));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void success() {
            try {
                this.graphdb.onSuccessTransaction();
            }
            finally {
                if (this.wrapped != null) {
                    ((Transaction)this.wrapped).success();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failure() {
            try {
                this.graphdb.onFailureTransaction();
            }
            finally {
                if (this.wrapped != null) {
                    ((Transaction)this.wrapped).failure();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            try {
                this.graphdb.onFinishTransaction();
            }
            finally {
                if (this.wrapped != null) {
                    ((Transaction)this.wrapped).finish();
                }
            }
        }
    }

    private static class WrappedTransactionBuilder
    extends WrappedObject<TransactionBuilder>
    implements TransactionBuilder {
        WrappedTransactionBuilder(WrappedGraphDatabase graphdb, TransactionBuilder wrapped) {
            super(graphdb, wrapped);
        }

        @Override
        public WrappedTransaction begin() {
            boolean openTx;
            try {
                this.graphdb.onBeginTransaction();
                openTx = true;
            }
            catch (TransactionNotAllowedException exception) {
                exception.throwCause();
                openTx = false;
            }
            return new WrappedTransaction(this.graphdb, openTx ? ((TransactionBuilder)this.wrapped).begin() : null);
        }

        @Override
        public WrappedTransactionBuilder unforced() {
            return new WrappedTransactionBuilder(this.graphdb, ((TransactionBuilder)this.wrapped).unforced());
        }
    }

    private class WrappedRelationshipAutoIndex
    extends WrappedAutoIndexer<Relationship>
    implements RelationshipAutoIndexer {
        private WrappedRelationshipAutoIndex() {
        }

        RelationshipAutoIndexer actual() {
            return WrappedGraphDatabase.this.graphdb.index().getRelationshipAutoIndexer();
        }

        @Override
        public ReadableRelationshipIndex getAutoIndex() {
            return WrappedGraphDatabase.this.automaticRelationshipIndex(this.actual().getAutoIndex());
        }
    }

    private abstract class WrappedAutoIndexer<T extends PropertyContainer>
    implements AutoIndexer<T> {
        private WrappedAutoIndexer() {
        }

        abstract AutoIndexer<T> actual();

        @Override
        public void setEnabled(boolean enabled) {
            this.actual().setEnabled(enabled);
        }

        @Override
        public boolean isEnabled() {
            return this.actual().isEnabled();
        }

        @Override
        public void startAutoIndexingProperty(String propName) {
            this.actual().startAutoIndexingProperty(propName);
        }

        @Override
        public void stopAutoIndexingProperty(String propName) {
            this.actual().stopAutoIndexingProperty(propName);
        }

        @Override
        public Set<String> getAutoIndexedProperties() {
            return this.actual().getAutoIndexedProperties();
        }
    }
}

