/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

public class WriteTransaction
extends XaTransaction
implements NeoStoreTransaction {
    private final Map<Long, NodeRecord> nodeRecords = new HashMap<Long, NodeRecord>();
    private final Map<Long, PropertyRecord> propertyRecords = new HashMap<Long, PropertyRecord>();
    private final Map<Long, RelationshipRecord> relRecords = new HashMap<Long, RelationshipRecord>();
    private Map<Integer, RelationshipTypeRecord> relTypeRecords;
    private Map<Integer, PropertyIndexRecord> propIndexRecords;
    private NeoStoreRecord neoStoreRecord;
    private final ArrayList<Command.NodeCommand> nodeCommands = new ArrayList();
    private final ArrayList<Command.PropertyCommand> propCommands = new ArrayList();
    private final ArrayList<Command.RelationshipCommand> relCommands = new ArrayList();
    private ArrayList<Command.RelationshipTypeCommand> relTypeCommands;
    private ArrayList<Command.PropertyIndexCommand> propIndexCommands;
    private Command.NeoStoreCommand neoStoreCommand;
    private final NeoStore neoStore;
    private boolean committed = false;
    private boolean prepared = false;
    private final LockReleaser lockReleaser;
    private final LockManager lockManager;
    private XaConnection xaConnection;

    WriteTransaction(int identifier, XaLogicalLog log, NeoStore neoStore, LockReleaser lockReleaser, LockManager lockManager) {
        super(identifier, log);
        this.neoStore = neoStore;
        this.lockReleaser = lockReleaser;
        this.lockManager = lockManager;
    }

    @Override
    public boolean isReadOnly() {
        if (this.isRecovered()) {
            return this.nodeCommands.size() == 0 && this.propCommands.size() == 0 && this.relCommands.size() == 0 && this.relTypeCommands == null && this.propIndexCommands == null;
        }
        return this.nodeRecords.size() == 0 && this.relRecords.size() == 0 && this.propertyRecords.size() == 0 && this.relTypeRecords == null && this.propIndexRecords == null;
    }

    @Override
    public void doAddCommand(XaCommand command) {
    }

    @Override
    protected void doPrepare() throws XAException {
        Command command;
        int noOfCommands = this.nodeRecords.size() + this.relRecords.size() + this.propertyRecords.size() + (this.propIndexRecords != null ? this.propIndexRecords.size() : 0) + (this.relTypeRecords != null ? this.relTypeRecords.size() : 0);
        ArrayList<Command> commands = new ArrayList<Command>(noOfCommands);
        if (this.committed) {
            throw new XAException("Cannot prepare committed transaction[" + this.getIdentifier() + "]");
        }
        if (this.prepared) {
            throw new XAException("Cannot prepare prepared transaction[" + this.getIdentifier() + "]");
        }
        this.prepared = true;
        if (this.relTypeRecords != null) {
            this.relTypeCommands = new ArrayList();
            for (RelationshipTypeRecord relationshipTypeRecord : this.relTypeRecords.values()) {
                command = new Command.RelationshipTypeCommand(this.neoStore.getRelationshipTypeStore(), relationshipTypeRecord);
                this.relTypeCommands.add((Command.RelationshipTypeCommand)command);
                commands.add(command);
            }
        }
        for (NodeRecord nodeRecord : this.nodeRecords.values()) {
            if (!nodeRecord.inUse() && nodeRecord.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                throw new InvalidRecordException("Node record " + nodeRecord + " still has relationships");
            }
            command = new Command.NodeCommand(this.neoStore.getNodeStore(), nodeRecord);
            this.nodeCommands.add((Command.NodeCommand)command);
            if (!nodeRecord.inUse()) {
                this.removeNodeFromCache(nodeRecord.getId());
            }
            commands.add(command);
        }
        for (RelationshipRecord relationshipRecord : this.relRecords.values()) {
            command = new Command.RelationshipCommand(this.neoStore.getRelationshipStore(), relationshipRecord);
            this.relCommands.add((Command.RelationshipCommand)command);
            if (!relationshipRecord.inUse()) {
                this.removeRelationshipFromCache(relationshipRecord.getId());
            }
            commands.add(command);
        }
        if (this.neoStoreRecord != null) {
            this.neoStoreCommand = new Command.NeoStoreCommand(this.neoStore, this.neoStoreRecord);
            this.addCommand(this.neoStoreCommand);
        }
        if (this.propIndexRecords != null) {
            this.propIndexCommands = new ArrayList();
            for (PropertyIndexRecord propertyIndexRecord : this.propIndexRecords.values()) {
                command = new Command.PropertyIndexCommand(this.neoStore.getPropertyStore().getIndexStore(), propertyIndexRecord);
                this.propIndexCommands.add((Command.PropertyIndexCommand)command);
                commands.add(command);
            }
        }
        for (PropertyRecord propertyRecord : this.propertyRecords.values()) {
            command = new Command.PropertyCommand(this.neoStore.getPropertyStore(), propertyRecord);
            this.propCommands.add((Command.PropertyCommand)command);
            commands.add(command);
        }
        assert (commands.size() == noOfCommands) : "Expected " + noOfCommands + " final commands, got " + commands.size() + " instead";
        this.intercept(commands);
        for (Command command2 : commands) {
            this.addCommand(command2);
        }
    }

    protected void intercept(List<Command> commands) {
    }

    @Override
    protected void injectCommand(XaCommand xaCommand) {
        if (xaCommand instanceof Command.NodeCommand) {
            this.nodeCommands.add((Command.NodeCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipCommand) {
            this.relCommands.add((Command.RelationshipCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyCommand) {
            this.propCommands.add((Command.PropertyCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyIndexCommand) {
            if (this.propIndexCommands == null) {
                this.propIndexCommands = new ArrayList();
            }
            this.propIndexCommands.add((Command.PropertyIndexCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipTypeCommand) {
            if (this.relTypeCommands == null) {
                this.relTypeCommands = new ArrayList();
            }
            this.relTypeCommands.add((Command.RelationshipTypeCommand)xaCommand);
        } else if (xaCommand instanceof Command.NeoStoreCommand) {
            assert (this.neoStoreCommand == null);
            this.neoStoreCommand = (Command.NeoStoreCommand)xaCommand;
        } else {
            throw new IllegalArgumentException("Unknown command " + xaCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRollback() throws XAException {
        if (this.committed) {
            throw new XAException("Cannot rollback partialy commited transaction[" + this.getIdentifier() + "]. Recover and " + "commit");
        }
        try {
            boolean freeIds = this.neoStore.getTxHook().freeIdsDuringRollback();
            if (this.relTypeRecords != null) {
                for (RelationshipTypeRecord relationshipTypeRecord : this.relTypeRecords.values()) {
                    if (relationshipTypeRecord.isCreated()) {
                        if (freeIds) {
                            this.getRelationshipTypeStore().freeId(relationshipTypeRecord.getId());
                        }
                        for (DynamicRecord dynamicRecord : relationshipTypeRecord.getNameRecords()) {
                            if (!dynamicRecord.isCreated()) continue;
                            this.getRelationshipTypeStore().freeBlockId((int)dynamicRecord.getId());
                        }
                    }
                    this.removeRelationshipTypeFromCache(relationshipTypeRecord.getId());
                }
            }
            for (NodeRecord nodeRecord : this.nodeRecords.values()) {
                if (freeIds && nodeRecord.isCreated()) {
                    this.getNodeStore().freeId(nodeRecord.getId());
                }
                this.removeNodeFromCache(nodeRecord.getId());
            }
            for (RelationshipRecord relationshipRecord : this.relRecords.values()) {
                if (freeIds && relationshipRecord.isCreated()) {
                    this.getRelationshipStore().freeId(relationshipRecord.getId());
                }
                this.removeRelationshipFromCache(relationshipRecord.getId());
            }
            if (this.neoStoreRecord != null) {
                this.removeGraphPropertiesFromCache();
            }
            if (this.propIndexRecords != null) {
                for (PropertyIndexRecord propertyIndexRecord : this.propIndexRecords.values()) {
                    if (!propertyIndexRecord.isCreated()) continue;
                    if (freeIds) {
                        this.getPropertyStore().getIndexStore().freeId(propertyIndexRecord.getId());
                    }
                    for (DynamicRecord dynamicRecord : propertyIndexRecord.getNameRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        this.getPropertyStore().getIndexStore().freeBlockId((int)dynamicRecord.getId());
                    }
                }
            }
            for (PropertyRecord propertyRecord : this.propertyRecords.values()) {
                if (propertyRecord.getNodeId() != -1L) {
                    this.removeNodeFromCache(propertyRecord.getNodeId());
                } else if (propertyRecord.getRelId() != -1L) {
                    this.removeRelationshipFromCache(propertyRecord.getRelId());
                }
                if (!propertyRecord.isCreated()) continue;
                if (freeIds) {
                    this.getPropertyStore().freeId(propertyRecord.getId());
                }
                for (PropertyBlock block : propertyRecord.getPropertyBlocks()) {
                    for (DynamicRecord dynamicRecord : block.getValueRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        if (dynamicRecord.getType() == PropertyType.STRING.intValue()) {
                            this.getPropertyStore().freeStringBlockId(dynamicRecord.getId());
                            continue;
                        }
                        if (dynamicRecord.getType() == PropertyType.ARRAY.intValue()) {
                            this.getPropertyStore().freeArrayBlockId(dynamicRecord.getId());
                            continue;
                        }
                        throw new InvalidRecordException("Unknown type on " + dynamicRecord);
                    }
                }
            }
        }
        finally {
            this.clear();
        }
    }

    private void removeRelationshipTypeFromCache(int id) {
        this.lockReleaser.removeRelationshipTypeFromCache(id);
    }

    private void removeRelationshipFromCache(long id) {
        this.lockReleaser.removeRelationshipFromCache(id);
    }

    private void removeNodeFromCache(long id) {
        this.lockReleaser.removeNodeFromCache(id);
    }

    private void removeGraphPropertiesFromCache() {
        this.lockReleaser.removeGraphPropertiesFromCache();
    }

    private void addRelationshipType(int id) {
        this.setRecovered();
        NameData type = this.isRecovered() ? this.neoStore.getRelationshipTypeStore().getName(id, true) : this.neoStore.getRelationshipTypeStore().getName(id);
        this.lockReleaser.addRelationshipType(type);
    }

    private void addPropertyIndexCommand(int id) {
        NameData index = this.isRecovered() ? this.neoStore.getPropertyStore().getIndexStore().getName(id, true) : this.neoStore.getPropertyStore().getIndexStore().getName(id);
        this.lockReleaser.addPropertyIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit() throws XAException {
        if (!this.isRecovered() && !this.prepared) {
            throw new XAException("Cannot commit non prepared transaction[" + this.getIdentifier() + "]");
        }
        if (this.isRecovered()) {
            this.commitRecovered();
            return;
        }
        if (!this.isRecovered() && this.getCommitTxId() != this.neoStore.getLastCommittedTx() + 1L) {
            throw new RuntimeException("Tx id: " + this.getCommitTxId() + " not next transaction (" + this.neoStore.getLastCommittedTx() + ")");
        }
        try {
            this.committed = true;
            CommandSorter sorter = new CommandSorter();
            if (this.relTypeCommands != null) {
                Collections.sort(this.relTypeCommands, sorter);
                for (Command.RelationshipTypeCommand relationshipTypeCommand : this.relTypeCommands) {
                    relationshipTypeCommand.execute();
                }
            }
            if (this.propIndexCommands != null) {
                Collections.sort(this.propIndexCommands, sorter);
                for (Command.PropertyIndexCommand propertyIndexCommand : this.propIndexCommands) {
                    propertyIndexCommand.execute();
                }
            }
            Collections.sort(this.nodeCommands, sorter);
            Collections.sort(this.relCommands, sorter);
            Collections.sort(this.propCommands, sorter);
            WriteTransaction.executeCreated(this.propCommands, this.relCommands, this.nodeCommands);
            WriteTransaction.executeModified(this.propCommands, this.relCommands, this.nodeCommands);
            if (this.neoStoreCommand != null) {
                this.neoStoreCommand.execute();
            }
            WriteTransaction.executeDeleted(this.propCommands, this.relCommands, this.nodeCommands);
            this.updateFirstRelationships();
            this.lockReleaser.commitCows();
            this.neoStore.setLastCommittedTx(this.getCommitTxId());
        }
        finally {
            this.clear();
        }
    }

    private void updateFirstRelationships() {
        for (NodeRecord record : this.nodeRecords.values()) {
            this.lockReleaser.setFirstIds(record.getId(), record.getNextRel(), record.getNextProp());
        }
    }

    private static void executeCreated(ArrayList<? extends Command> ... commands) {
        for (ArrayList<? extends Command> c : commands) {
            for (Command command : c) {
                if (!command.isCreated() || command.isDeleted()) continue;
                command.execute();
            }
        }
    }

    private static void executeModified(ArrayList<? extends Command> ... commands) {
        for (ArrayList<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.isCreated() || command.isDeleted()) continue;
                command.execute();
            }
        }
    }

    private static void executeDeleted(ArrayList<? extends Command> ... commands) {
        for (ArrayList<? extends Command> c : commands) {
            for (Command command : c) {
                if (!command.isDeleted()) continue;
                command.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRecovered() {
        try {
            this.committed = true;
            CommandSorter sorter = new CommandSorter();
            if (this.propIndexCommands != null) {
                Collections.sort(this.propIndexCommands, sorter);
                for (Command.PropertyIndexCommand propertyIndexCommand : this.propIndexCommands) {
                    propertyIndexCommand.execute();
                    this.addPropertyIndexCommand((int)propertyIndexCommand.getKey());
                }
            }
            Collections.sort(this.propCommands, sorter);
            for (Command.PropertyCommand propertyCommand : this.propCommands) {
                propertyCommand.execute();
                this.removePropertyFromCache(propertyCommand);
            }
            if (this.relTypeCommands != null) {
                Collections.sort(this.relTypeCommands, sorter);
                for (Command.RelationshipTypeCommand relationshipTypeCommand : this.relTypeCommands) {
                    relationshipTypeCommand.execute();
                    this.addRelationshipType((int)relationshipTypeCommand.getKey());
                }
            }
            Collections.sort(this.relCommands, sorter);
            for (Command.RelationshipCommand relationshipCommand : this.relCommands) {
                relationshipCommand.execute();
                this.removeRelationshipFromCache(relationshipCommand.getKey());
                if (relationshipCommand.getFirstNode() == -1L && relationshipCommand.getSecondNode() == -1L) continue;
                this.removeNodeFromCache(relationshipCommand.getFirstNode());
                this.removeNodeFromCache(relationshipCommand.getSecondNode());
            }
            Collections.sort(this.nodeCommands, sorter);
            for (Command.NodeCommand nodeCommand : this.nodeCommands) {
                nodeCommand.execute();
                this.removeNodeFromCache(nodeCommand.getKey());
            }
            this.neoStore.setRecoveredStatus(true);
            try {
                if (this.neoStoreCommand != null) {
                    this.neoStoreCommand.execute();
                    this.removeGraphPropertiesFromCache();
                }
                this.neoStore.setLastCommittedTx(this.getCommitTxId());
            }
            finally {
                this.neoStore.setRecoveredStatus(false);
            }
            this.neoStore.getIdGeneratorFactory().updateIdGenerators(this.neoStore);
        }
        finally {
            this.clear();
        }
    }

    private void clear() {
        this.nodeRecords.clear();
        this.propertyRecords.clear();
        this.relRecords.clear();
        this.relTypeRecords = null;
        this.propIndexRecords = null;
        this.neoStoreRecord = null;
        this.nodeCommands.clear();
        this.propCommands.clear();
        this.propIndexCommands = null;
        this.relCommands.clear();
        this.relTypeCommands = null;
        this.neoStoreCommand = null;
    }

    private void removePropertyFromCache(Command.PropertyCommand command) {
        long nodeId = command.getNodeId();
        long relId = command.getRelId();
        if (nodeId != -1L) {
            this.removeNodeFromCache(nodeId);
        } else if (relId != -1L) {
            this.removeRelationshipFromCache(relId);
        }
    }

    private RelationshipTypeStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    @Override
    public NodeRecord nodeLoadLight(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord != null) {
            return nodeRecord;
        }
        return this.getNodeStore().loadLightNode(nodeId);
    }

    @Override
    public RelationshipRecord relLoadLight(long id) {
        RelationshipRecord relRecord = this.getRelationshipRecord(id);
        if (relRecord != null) {
            return relRecord;
        }
        relRecord = this.getRelationshipStore().getLightRel(id);
        if (relRecord != null) {
            return relRecord;
        }
        return null;
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeDelete(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
            this.addNodeRecord(nodeRecord);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        ArrayMap<Integer, PropertyData> propertyMap = this.getAndDeletePropertyChain(nodeRecord);
        return propertyMap;
    }

    @Override
    public ArrayMap<Integer, PropertyData> relDelete(long id) {
        RelationshipRecord record = this.getRelationshipRecord(id);
        if (record == null) {
            record = this.getRelationshipStore().getRecord(id);
            this.addRelationshipRecord(record);
        }
        if (!record.inUse()) {
            throw new IllegalStateException("Unable to delete relationship[" + id + "] since it is already deleted.");
        }
        ArrayMap<Integer, PropertyData> propertyMap = this.getAndDeletePropertyChain(record);
        this.disconnectRelationship(record);
        this.updateNodes(record);
        record.setInUse(false);
        return propertyMap;
    }

    private ArrayMap<Integer, PropertyData> getAndDeletePropertyChain(PrimitiveRecord primitive) {
        ArrayMap<Integer, PropertyData> result = new ArrayMap<Integer, PropertyData>(9, false, true);
        long nextProp = primitive.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyRecord(nextProp, false, true);
            if (!propRecord.isCreated() && propRecord.isChanged()) {
                propRecord = this.getPropertyStore().getRecord(propRecord.getId());
                this.addPropertyRecord(propRecord);
            }
            for (PropertyBlock block : propRecord.getPropertyBlocks()) {
                if (block.isLight()) {
                    this.getPropertyStore().makeHeavy(block);
                }
                if (!block.isCreated() && !propRecord.isChanged()) {
                    result.put(block.getKeyIndexId(), block.newPropertyData(propRecord, this.propertyGetValueOrNull(block)));
                }
                for (DynamicRecord valueRecord : block.getValueRecords()) {
                    assert (valueRecord.inUse());
                    valueRecord.setInUse(false);
                    propRecord.addDeletedRecord(valueRecord);
                }
            }
            nextProp = propRecord.getNextProp();
            propRecord.setInUse(false);
            propRecord.setChanged(primitive);
            propRecord.getPropertyBlocks().clear();
        }
        return result;
    }

    private void disconnectRelationship(RelationshipRecord rel) {
        RelationshipRecord nextRel;
        boolean changed;
        RelationshipRecord prevRel;
        LockableRelationship lockableRel;
        if (rel.getFirstPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.getRelationshipRecord(rel.getFirstPrevRel());
            if (prevRel == null) {
                prevRel = this.getRelationshipStore().getRecord(rel.getFirstPrevRel());
                this.addRelationshipRecord(prevRel);
            }
            changed = false;
            if (prevRel.getFirstNode() == rel.getFirstNode()) {
                prevRel.setFirstNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getFirstNode()) {
                prevRel.setSecondNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getFirstNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.getRelationshipRecord(rel.getFirstNextRel());
            if (nextRel == null) {
                nextRel = this.getRelationshipStore().getRecord(rel.getFirstNextRel());
                this.addRelationshipRecord(nextRel);
            }
            changed = false;
            if (nextRel.getFirstNode() == rel.getFirstNode()) {
                nextRel.setFirstPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getFirstNode()) {
                nextRel.setSecondPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
        if (rel.getSecondPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.getRelationshipRecord(rel.getSecondPrevRel());
            if (prevRel == null) {
                prevRel = this.getRelationshipStore().getRecord(rel.getSecondPrevRel());
                this.addRelationshipRecord(prevRel);
            }
            changed = false;
            if (prevRel.getFirstNode() == rel.getSecondNode()) {
                prevRel.setFirstNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getSecondNode()) {
                prevRel.setSecondNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getSecondNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.getRelationshipRecord(rel.getSecondNextRel());
            if (nextRel == null) {
                nextRel = this.getRelationshipStore().getRecord(rel.getSecondNextRel());
                this.addRelationshipRecord(nextRel);
            }
            changed = false;
            if (nextRel.getFirstNode() == rel.getSecondNode()) {
                nextRel.setFirstPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getSecondNode()) {
                nextRel.setSecondPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
    }

    private void getWriteLock(Relationship lockableRel) {
        this.lockManager.getWriteLock(lockableRel);
        this.lockReleaser.addLockToTransaction(lockableRel, LockType.WRITE);
    }

    @Override
    public long getRelationshipChainPosition(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord != null && nodeRecord.isCreated()) {
            return Record.NO_NEXT_RELATIONSHIP.intValue();
        }
        return this.getNodeStore().getRecord(nodeId).getNextRel();
    }

    @Override
    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return ReadTransaction.getMoreRelationships(nodeId, position, this.getRelGrabSize(), this.getRelationshipStore());
    }

    private void updateNodes(RelationshipRecord rel) {
        if (rel.getFirstPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord firstNode = this.getNodeRecord(rel.getFirstNode());
            if (firstNode == null) {
                firstNode = this.getNodeStore().getRecord(rel.getFirstNode());
                this.addNodeRecord(firstNode);
            }
            firstNode.setNextRel(rel.getFirstNextRel());
        }
        if (rel.getSecondPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord secondNode = this.getNodeRecord(rel.getSecondNode());
            if (secondNode == null) {
                secondNode = this.getNodeStore().getRecord(rel.getSecondNode());
                this.addNodeRecord(secondNode);
            }
            secondNode.setNextRel(rel.getSecondNextRel());
        }
    }

    @Override
    public void relRemoveProperty(long relId, PropertyData propertyData) {
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord == null) {
            relRecord = this.getRelationshipStore().getRecord(relId);
        }
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property remove on relationship[" + relId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(relRecord));
        this.removeProperty(relRecord, propertyData, RecordAdded.RELATIONSHIP);
    }

    @Override
    public ArrayMap<Integer, PropertyData> relLoadProperties(long relId, boolean light) {
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord != null && relRecord.isCreated()) {
            return null;
        }
        if (relRecord != null && !relRecord.inUse() && !light) {
            throw new IllegalStateException("Relationship[" + relId + "] has been deleted in this tx");
        }
        relRecord = this.getRelationshipStore().getRecord(relId);
        if (!relRecord.inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        return ReadTransaction.loadProperties(this.getPropertyStore(), relRecord.getNextProp());
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeLoadProperties(long nodeId, boolean light) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord != null && nodeRecord.isCreated()) {
            return null;
        }
        if (nodeRecord != null && !nodeRecord.inUse() && !light) {
            throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
        }
        nodeRecord = this.getNodeStore().getRecord(nodeId);
        if (!nodeRecord.inUse()) {
            throw new InvalidRecordException("Node[" + nodeId + "] not in use");
        }
        return ReadTransaction.loadProperties(this.getPropertyStore(), nodeRecord.getNextProp());
    }

    public Object propertyGetValueOrNull(PropertyBlock block) {
        return block.getType().getValue(block, block.isLight() ? null : this.getPropertyStore());
    }

    @Override
    public Object loadPropertyValue(PropertyData propertyData) {
        PropertyBlock block;
        PropertyRecord propertyRecord = this.propertyRecords.get(propertyData.getId());
        if (propertyRecord == null) {
            propertyRecord = this.getPropertyStore().getRecord(propertyData.getId());
        }
        if ((block = propertyRecord.getPropertyBlock(propertyData.getIndex())) == null) {
            throw new IllegalStateException("Property with index[" + propertyData.getIndex() + "] is not present in property[" + propertyData.getId() + "]");
        }
        if (block.isLight()) {
            this.getPropertyStore().makeHeavy(block);
        }
        return block.getType().getValue(block, this.getPropertyStore());
    }

    @Override
    public void nodeRemoveProperty(long nodeId, PropertyData propertyData) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
            this.addNodeRecord(nodeRecord);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property remove on node[" + nodeId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(nodeRecord));
        this.removeProperty(nodeRecord, propertyData, RecordAdded.NODE);
    }

    private void removeProperty(PrimitiveRecord hostRecord, PropertyData propertyData, RecordAdded adder) {
        long propertyId = propertyData.getId();
        PropertyRecord propRecord = this.getPropertyRecord(propertyId, false, true);
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        PropertyBlock block = propRecord.removePropertyBlock(propertyData.getIndex());
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyData.getIndex() + "] is not present in property[" + propertyId + "]");
        }
        if (block.isLight()) {
            this.getPropertyStore().makeHeavy(block);
        }
        for (DynamicRecord valueRecord : block.getValueRecords()) {
            assert (valueRecord.inUse());
            valueRecord.setInUse(false, block.getType().intValue());
            propRecord.addDeletedRecord(valueRecord);
        }
        if (propRecord.size() > 0) {
            propRecord.setChanged(hostRecord);
            assert (this.assertPropertyChain(hostRecord));
        } else if (this.unlinkPropertyRecord(propRecord, hostRecord)) {
            adder.add(this, hostRecord);
        }
    }

    private boolean unlinkPropertyRecord(PropertyRecord propRecord, PrimitiveRecord primitive) {
        assert (this.assertPropertyChain(primitive));
        assert (propRecord.size() == 0);
        boolean primitiveChanged = false;
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            primitive.setNextProp(nextProp);
            primitiveChanged = true;
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = this.getPropertyRecord(prevProp, true, true);
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            prevPropRecord.setChanged(primitive);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = this.getPropertyRecord(nextProp, true, true);
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            nextPropRecord.setChanged(primitive);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        propRecord.setChanged(primitive);
        assert (this.assertPropertyChain(primitive));
        return primitiveChanged;
    }

    @Override
    public PropertyData relChangeProperty(long relId, PropertyData propertyData, Object value) {
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord == null) {
            relRecord = this.getRelationshipStore().getRecord(relId);
        }
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property change on relationship[" + relId + "] illegal since it has been deleted.");
        }
        return this.primitiveChangeProperty(relRecord, propertyData, value, RecordAdded.RELATIONSHIP);
    }

    @Override
    public PropertyData nodeChangeProperty(long nodeId, PropertyData propertyData, Object value) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property change on node[" + nodeId + "] illegal since it has been deleted.");
        }
        return this.primitiveChangeProperty(nodeRecord, propertyData, value, RecordAdded.NODE);
    }

    private PropertyData primitiveChangeProperty(PrimitiveRecord primitive, PropertyData propertyData, Object value, RecordAdded adder) {
        assert (this.assertPropertyChain(primitive));
        long propertyId = propertyData.getId();
        PropertyRecord propertyRecord = this.getPropertyRecord(propertyId, true, true);
        if (!propertyRecord.inUse()) {
            throw new IllegalStateException("Unable to change property[" + propertyId + "] since it has been deleted.");
        }
        PropertyBlock block = propertyRecord.getPropertyBlock(propertyData.getIndex());
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyData.getIndex() + "] is not present in property[" + propertyId + "]");
        }
        if (block.isLight()) {
            this.getPropertyStore().makeHeavy(block);
        }
        propertyRecord.setChanged(primitive);
        for (DynamicRecord record : block.getValueRecords()) {
            assert (record.inUse());
            record.setInUse(false, block.getType().intValue());
            propertyRecord.addDeletedRecord(record);
        }
        this.getPropertyStore().encodeValue(block, propertyData.getIndex(), value);
        if (propertyRecord.size() > PropertyType.getPayloadSize()) {
            propertyRecord.removePropertyBlock(propertyData.getIndex());
            propertyRecord = this.addPropertyBlockToPrimitive(block, primitive, adder);
        }
        assert (this.assertPropertyChain(primitive));
        return block.newPropertyData(propertyRecord, value);
    }

    @Override
    public PropertyData relAddProperty(long relId, PropertyIndex index, Object value) {
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord == null) {
            relRecord = this.getRelationshipStore().getRecord(relId);
            this.addRelationshipRecord(relRecord);
        }
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property add on relationship[" + relId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(relRecord));
        PropertyBlock block = new PropertyBlock();
        block.setCreated();
        this.getPropertyStore().encodeValue(block, index.getKeyId(), value);
        PropertyRecord host = this.addPropertyBlockToPrimitive(block, relRecord, RecordAdded.RELATIONSHIP);
        assert (this.assertPropertyChain(relRecord));
        return block.newPropertyData(host, value);
    }

    @Override
    public PropertyData nodeAddProperty(long nodeId, PropertyIndex index, Object value) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
            this.addNodeRecord(nodeRecord);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property add on node[" + nodeId + "] illegal since it has been deleted.");
        }
        assert (this.assertPropertyChain(nodeRecord));
        PropertyBlock block = new PropertyBlock();
        block.setCreated();
        this.getPropertyStore().encodeValue(block, index.getKeyId(), value);
        PropertyRecord host = this.addPropertyBlockToPrimitive(block, nodeRecord, RecordAdded.NODE);
        assert (this.assertPropertyChain(nodeRecord));
        return block.newPropertyData(host, value);
    }

    private PropertyRecord addPropertyBlockToPrimitive(PropertyBlock block, PrimitiveRecord primitive, RecordAdded adder) {
        assert (this.assertPropertyChain(primitive));
        int newBlockSizeInBytes = block.getSize();
        PropertyRecord host = null;
        long firstProp = primitive.getNextProp();
        if (firstProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyRecord(firstProp, false, false);
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            assert (propRecord.inUse()) : propRecord;
            int propSize = propRecord.size();
            assert (propSize > 0) : propRecord;
            if (propSize + newBlockSizeInBytes <= PropertyType.getPayloadSize()) {
                host = propRecord;
                host.addPropertyBlock(block);
                host.setChanged(primitive);
            }
        }
        if (host == null) {
            host = new PropertyRecord(this.getPropertyStore().nextId(), primitive);
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord prevProp = this.getPropertyRecord(primitive.getNextProp(), true, true);
                adder.add(this, primitive);
                assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
                prevProp.setPrevProp(host.getId());
                host.setNextProp(prevProp.getId());
                prevProp.setChanged(primitive);
            }
            primitive.setNextProp(host.getId());
            host.addPropertyBlock(block);
            host.setInUse(true);
        }
        this.addPropertyRecord(host);
        assert (this.assertPropertyChain(primitive));
        return host;
    }

    @Override
    public void relationshipCreate(long id, int type, long firstNodeId, long secondNodeId) {
        NodeRecord firstNode = this.getNodeRecord(firstNodeId);
        if (firstNode == null) {
            firstNode = this.getNodeStore().getRecord(firstNodeId);
            this.addNodeRecord(firstNode);
        }
        if (!firstNode.inUse()) {
            throw new IllegalStateException("First node[" + firstNodeId + "] is deleted and cannot be used to create a relationship");
        }
        NodeRecord secondNode = this.getNodeRecord(secondNodeId);
        if (secondNode == null) {
            secondNode = this.getNodeStore().getRecord(secondNodeId);
            this.addNodeRecord(secondNode);
        }
        if (!secondNode.inUse()) {
            throw new IllegalStateException("Second node[" + secondNodeId + "] is deleted and cannot be used to create a relationship");
        }
        RelationshipRecord record = new RelationshipRecord(id, firstNodeId, secondNodeId, type);
        record.setInUse(true);
        record.setCreated();
        this.addRelationshipRecord(record);
        this.connectRelationship(firstNode, secondNode, record);
    }

    private void connectRelationship(NodeRecord firstNode, NodeRecord secondNode, RelationshipRecord rel) {
        assert (firstNode.getNextRel() != rel.getId());
        assert (secondNode.getNextRel() != rel.getId());
        rel.setFirstNextRel(firstNode.getNextRel());
        rel.setSecondNextRel(secondNode.getNextRel());
        this.connect(firstNode, rel);
        this.connect(secondNode, rel);
        firstNode.setNextRel(rel.getId());
        secondNode.setNextRel(rel.getId());
    }

    private void connect(NodeRecord node, RelationshipRecord rel) {
        if (node.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            LockableRelationship lockableRel = new LockableRelationship(node.getNextRel());
            this.getWriteLock(lockableRel);
            RelationshipRecord nextRel = this.getRelationshipRecord(node.getNextRel());
            if (nextRel == null) {
                nextRel = this.getRelationshipStore().getRecord(node.getNextRel());
                this.addRelationshipRecord(nextRel);
            }
            boolean changed = false;
            if (nextRel.getFirstNode() == node.getId()) {
                nextRel.setFirstPrevRel(rel.getId());
                changed = true;
            }
            if (nextRel.getSecondNode() == node.getId()) {
                nextRel.setSecondPrevRel(rel.getId());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(node + " dont match " + nextRel);
            }
        }
    }

    @Override
    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = new NodeRecord(nodeId, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        this.addNodeRecord(nodeRecord);
    }

    @Override
    public String loadIndex(int id) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        PropertyIndexRecord index = this.getPropertyIndexRecord(id);
        if (index == null) {
            index = (PropertyIndexRecord)indexStore.getRecord(id);
        }
        if (index.isLight()) {
            indexStore.makeHeavy(index);
        }
        return indexStore.getStringFor(index);
    }

    @Override
    public NameData[] loadPropertyIndexes(int count) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        return indexStore.getNames(count);
    }

    @Override
    public void createPropertyIndex(String key, int id) {
        PropertyIndexRecord record = new PropertyIndexRecord(id);
        record.setInUse(true);
        record.setCreated();
        PropertyIndexStore propIndexStore = this.getPropertyStore().getIndexStore();
        int nameId = propIndexStore.nextNameId();
        record.setNameId(nameId);
        Collection<DynamicRecord> nameRecords = propIndexStore.allocateNameRecords(nameId, PropertyStore.encodeString(key));
        for (DynamicRecord keyRecord : nameRecords) {
            record.addNameRecord(keyRecord);
        }
        this.addPropertyIndexRecord(record);
    }

    @Override
    public void createRelationshipType(int id, String name) {
        RelationshipTypeRecord record = new RelationshipTypeRecord(id);
        record.setInUse(true);
        record.setCreated();
        int nameId = this.getRelationshipTypeStore().nextNameId();
        record.setNameId(nameId);
        Collection<DynamicRecord> typeNameRecords = this.getRelationshipTypeStore().allocateNameRecords(nameId, PropertyStore.encodeString(name));
        for (DynamicRecord typeRecord : typeNameRecords) {
            record.addNameRecord(typeRecord);
        }
        this.addRelationshipTypeRecord(record);
    }

    void addNodeRecord(NodeRecord record) {
        this.nodeRecords.put(record.getId(), record);
    }

    NodeRecord getNodeRecord(long nodeId) {
        return this.nodeRecords.get(nodeId);
    }

    void addRelationshipRecord(RelationshipRecord record) {
        this.relRecords.put(record.getId(), record);
    }

    RelationshipRecord getRelationshipRecord(long relId) {
        return this.relRecords.get(relId);
    }

    void addPropertyRecord(PropertyRecord record) {
        this.propertyRecords.put(record.getId(), record);
    }

    PropertyRecord getPropertyRecord(long propertyId, boolean light, boolean store) {
        PropertyRecord result = this.propertyRecords.get(propertyId);
        if (result == null) {
            result = light ? this.getPropertyStore().getLightRecord(propertyId) : this.getPropertyStore().getRecord(propertyId);
            if (store) {
                this.addPropertyRecord(result);
            }
        }
        return result;
    }

    void addRelationshipTypeRecord(RelationshipTypeRecord record) {
        if (this.relTypeRecords == null) {
            this.relTypeRecords = new HashMap<Integer, RelationshipTypeRecord>();
        }
        this.relTypeRecords.put(record.getId(), record);
    }

    void addPropertyIndexRecord(PropertyIndexRecord record) {
        if (this.propIndexRecords == null) {
            this.propIndexRecords = new HashMap<Integer, PropertyIndexRecord>();
        }
        this.propIndexRecords.put(record.getId(), record);
    }

    PropertyIndexRecord getPropertyIndexRecord(int id) {
        return this.propIndexRecords != null ? this.propIndexRecords.get(id) : null;
    }

    @Override
    public RelIdArray getCreatedNodes() {
        RelIdArray createdNodes = new RelIdArray(null);
        for (NodeRecord record : this.nodeRecords.values()) {
            if (!record.isCreated()) continue;
            createdNodes.add(record.getId(), RelIdArray.DirectionWrapper.OUTGOING);
        }
        return createdNodes;
    }

    @Override
    public boolean isNodeCreated(long nodeId) {
        NodeRecord record = this.nodeRecords.get(nodeId);
        if (record != null) {
            return record.isCreated();
        }
        return false;
    }

    @Override
    public boolean isRelationshipCreated(long relId) {
        RelationshipRecord record = this.relRecords.get(relId);
        if (record != null) {
            return record.isCreated();
        }
        return false;
    }

    @Override
    public int getKeyIdForProperty(PropertyData property) {
        return ReadTransaction.getKeyIdForProperty(property, this.getPropertyStore());
    }

    @Override
    public XAResource getXAResource() {
        return this.xaConnection.getXaResource();
    }

    @Override
    public void destroy() {
        this.xaConnection.destroy();
    }

    @Override
    public void setXaConnection(XaConnection connection) {
        this.xaConnection = connection;
    }

    @Override
    public NameData[] loadRelationshipTypes() {
        NameData[] relTypeData = this.neoStore.getRelationshipTypeStore().getNames(Integer.MAX_VALUE);
        NameData[] rawRelTypeData = new NameData[relTypeData.length];
        for (int i = 0; i < relTypeData.length; ++i) {
            rawRelTypeData[i] = new NameData(relTypeData[i].getId(), relTypeData[i].getName());
        }
        return rawRelTypeData;
    }

    private boolean assertPropertyChain(PrimitiveRecord primitive) {
        LinkedList<PropertyRecord> toCheck = new LinkedList<PropertyRecord>();
        long nextIdToFetch = primitive.getNextProp();
        while (nextIdToFetch != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord toAdd = this.getPropertyRecord(nextIdToFetch, true, false);
            toCheck.add(toAdd);
            assert (toAdd.inUse()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            nextIdToFetch = toAdd.getNextProp();
        }
        if (toCheck.isEmpty()) {
            assert (primitive.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive;
            return true;
        }
        PropertyRecord first = (PropertyRecord)toCheck.get(0);
        PropertyRecord last = (PropertyRecord)toCheck.get(toCheck.size() - 1);
        assert (first.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        assert (last.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        PropertyRecord previous = first;
        for (int i = 1; i < toCheck.size(); ++i) {
            PropertyRecord current = (PropertyRecord)toCheck.get(i);
            assert (current.getPrevProp() == previous.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            assert (previous.getNextProp() == current.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            previous = current;
        }
        return true;
    }

    private NeoStoreRecord getOrLoadNeoStoreRecord() {
        if (this.neoStoreRecord == null) {
            this.neoStoreRecord = this.neoStore.asRecord();
        }
        return this.neoStoreRecord;
    }

    @Override
    public PropertyData graphAddProperty(PropertyIndex index, Object value) {
        PropertyBlock block = new PropertyBlock();
        block.setCreated();
        this.getPropertyStore().encodeValue(block, index.getKeyId(), value);
        NeoStoreRecord record = this.getOrLoadNeoStoreRecord();
        PropertyRecord host = this.addPropertyBlockToPrimitive(block, record, RecordAdded.GRAPH);
        assert (this.assertPropertyChain(record));
        return block.newPropertyData(host, value);
    }

    @Override
    public PropertyData graphChangeProperty(PropertyData propertyData, Object value) {
        return this.primitiveChangeProperty(this.getOrLoadNeoStoreRecord(), propertyData, value, RecordAdded.GRAPH);
    }

    @Override
    public void graphRemoveProperty(PropertyData propertyData) {
        this.removeProperty(this.getOrLoadNeoStoreRecord(), propertyData, RecordAdded.GRAPH);
    }

    @Override
    public ArrayMap<Integer, PropertyData> graphLoadProperties(boolean light) {
        return ReadTransaction.loadProperties(this.getPropertyStore(), this.getOrLoadNeoStoreRecord().getNextProp());
    }

    private static enum RecordAdded {
        NODE{

            @Override
            void add(WriteTransaction tx, PrimitiveRecord record) {
                tx.addNodeRecord((NodeRecord)record);
            }
        }
        ,
        RELATIONSHIP{

            @Override
            void add(WriteTransaction tx, PrimitiveRecord record) {
                tx.addRelationshipRecord((RelationshipRecord)record);
            }
        }
        ,
        GRAPH{

            @Override
            void add(WriteTransaction tx, PrimitiveRecord record) {
                tx.neoStoreRecord = (NeoStoreRecord)record;
            }
        };


        abstract void add(WriteTransaction var1, PrimitiveRecord var2);
    }

    private static class LockableRelationship
    implements Relationship {
        private final long id;

        LockableRelationship(long id) {
            this.id = id;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getEndNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node[] getNodes() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getOtherNode(Node node) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<Object> getPropertyValues() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getStartNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public RelationshipType getType() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean isType(RelationshipType type) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean hasProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object removeProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public void setProperty(String key, Object value) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        public boolean equals(Object o) {
            if (!(o instanceof Relationship)) {
                return false;
            }
            return this.getId() == ((Relationship)o).getId();
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        public String toString() {
            return "Lockable relationship #" + this.getId();
        }
    }

    static class CommandSorter
    implements Comparator<Command>,
    Serializable {
        CommandSorter() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id2;
            long id1 = o1.getKey();
            long diff = id1 - (id2 = o2.getKey());
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CommandSorter;
        }

        public int hashCode() {
            return 3217;
        }
    }
}

