/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.AbstractAutoIndexerImpl;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.IndexManagerImpl;

class RelationshipAutoIndexerImpl
extends AbstractAutoIndexerImpl<Relationship>
implements RelationshipAutoIndexer {
    static final String RELATIONSHIP_AUTO_INDEX = "relationship_auto_index";

    public RelationshipAutoIndexerImpl(EmbeddedGraphDbImpl gdb) {
        super(gdb);
    }

    @Override
    protected String getAutoIndexConfigListName() {
        return "relationship_keys_indexable";
    }

    @Override
    protected String getAutoIndexName() {
        return RELATIONSHIP_AUTO_INDEX;
    }

    @Override
    protected String getEnableConfigName() {
        return "relationship_auto_indexing";
    }

    protected RelationshipIndex getIndexInternal() {
        return ((IndexManagerImpl)this.getGraphDbImpl().index()).getOrCreateRelationshipIndex(RELATIONSHIP_AUTO_INDEX, null);
    }

    @Override
    public ReadableRelationshipIndex getAutoIndex() {
        return this.getIndexInternal();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.getGraphDbImpl().getConfig().getGraphDbModule().getNodeManager().addRelationshipPropertyTracker(this);
        } else {
            this.getGraphDbImpl().getConfig().getGraphDbModule().getNodeManager().removeRelationshipPropertyTracker(this);
        }
    }

    static class RelationshipReadOnlyIndexToIndexAdapter
    extends AbstractAutoIndexerImpl.ReadOnlyIndexToIndexAdapter<Relationship>
    implements RelationshipIndex {
        private final ReadableRelationshipIndex delegate;

        public RelationshipReadOnlyIndexToIndexAdapter(ReadableRelationshipIndex delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return this.delegate.get(key, valueOrNull, startNodeOrNull, endNodeOrNull);
        }

        @Override
        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return this.delegate.query(key, queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull);
        }

        @Override
        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return this.delegate.query(queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull);
        }
    }
}

