/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockType;

class NodeProxy
implements Node {
    private final NodeManager nm;
    private final long nodeId;

    NodeProxy(long nodeId, NodeManager nodeManager) {
        this.nodeId = nodeId;
        this.nm = nodeManager;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nm.getGraphDbService();
    }

    @Override
    public void delete() {
        this.nm.getNodeForProxy(this, LockType.WRITE).delete(this.nm, this);
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.nm.getNodeForProxy(this, null).getRelationships(this.nm);
    }

    @Override
    public boolean hasRelationship() {
        return this.nm.getNodeForProxy(this, null).hasRelationship(this.nm);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.nm.getNodeForProxy(this, null).getRelationships(this.nm, dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return this.nm.getNodeForProxy(this, null).hasRelationship(this.nm, dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.nm.getNodeForProxy(this, null).getRelationships(this.nm, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        return this.nm.getNodeForProxy(this, null).getRelationships(this.nm, direction, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.nm.getNodeForProxy(this, null).hasRelationship(this.nm, types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        return this.nm.getNodeForProxy(this, null).hasRelationship(this.nm, direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this, null).getRelationships(this.nm, type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this, null).hasRelationship(this.nm, type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this, null).getSingleRelationship(this.nm, type, dir);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.nm.getNodeForProxy(this, LockType.WRITE).setProperty(this.nm, this, key, value);
    }

    @Override
    public Object removeProperty(String key) throws NotFoundException {
        return this.nm.getNodeForProxy(this, LockType.WRITE).removeProperty(this.nm, this, key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.nm.getNodeForProxy(this, null).getProperty(this.nm, key, defaultValue);
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nm.getNodeForProxy(this, null).getPropertyValues(this.nm);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.nm.getNodeForProxy(this, null).getPropertyKeys(this.nm);
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        return this.nm.getNodeForProxy(this, null).getProperty(this.nm, key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.nm.getNodeForProxy(this, null).hasProperty(this.nm, key);
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.nm.getNodeForProxy(this, LockType.WRITE).createRelationshipTo(this.nm, this, otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return this.nm.getNodeForProxy(this, null).traverse(this.nm, traversalOrder, stopEvaluator, returnableEvaluator, relationshipType, direction);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return this.nm.getNodeForProxy(this, null).traverse(this.nm, traversalOrder, stopEvaluator, returnableEvaluator, firstRelationshipType, firstDirection, secondRelationshipType, secondDirection);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return this.nm.getNodeForProxy(this, null).traverse(this.nm, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }
}

