/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.kernel.StandardExpander;

public final class OrderedByTypeExpander
extends StandardExpander.RegularExpander {
    private final Collection<Pair<RelationshipType, Direction>> orderedTypes;

    public OrderedByTypeExpander() {
        this(MapUtil.genericMap(new Object[0]));
    }

    OrderedByTypeExpander(Map<Direction, RelationshipType[]> types) {
        super(types);
        this.orderedTypes = this.constructOrderedList(types);
    }

    private Collection<Pair<RelationshipType, Direction>> constructOrderedList(Map<Direction, RelationshipType[]> types) {
        ArrayList<Pair<RelationshipType, Direction>> list = new ArrayList<Pair<RelationshipType, Direction>>();
        for (Map.Entry<Direction, RelationshipType[]> entry : types.entrySet()) {
            for (RelationshipType type : entry.getValue()) {
                list.add(Pair.of(type, entry.getKey()));
            }
        }
        return list;
    }

    @Override
    StandardExpander.RegularExpander createNew(Map<Direction, RelationshipType[]> newTypes) {
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    Iterator<Relationship> doExpand(final Node start) {
        return new NestingIterator<Relationship, Pair<RelationshipType, Direction>>(this.orderedTypes.iterator()){

            @Override
            protected Iterator<Relationship> createNestedIterator(Pair<RelationshipType, Direction> entry) {
                RelationshipType type = entry.first();
                Direction dir = entry.other();
                return (dir == Direction.BOTH ? start.getRelationships(type) : start.getRelationships(type, dir)).iterator();
            }
        };
    }
}

