/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

public abstract class LogBackedXaDataSource
extends XaDataSource {
    private XaLogicalLog logicalLog;

    public LogBackedXaDataSource(Map<?, ?> params) throws InstantiationException {
        super(params);
    }

    protected void setLogicalLogAtCreationTime(XaLogicalLog logicalLog) {
        if (this.logicalLog != null) {
            throw new RuntimeException("Logical log already set for " + this);
        }
        this.logicalLog = logicalLog;
    }

    @Override
    public boolean deleteLogicalLog(long version) {
        return this.logicalLog.deleteLogicalLog(version);
    }

    @Override
    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.logicalLog.getLogicalLogOrMyselfCommitted(version, 0L);
    }

    @Override
    public long getLogicalLogLength(long version) {
        return this.logicalLog.getLogicalLogLength(version);
    }

    @Override
    public boolean hasLogicalLog(long version) {
        return this.logicalLog.hasLogicalLog(version);
    }

    @Override
    public boolean isLogicalLogKept() {
        return this.logicalLog.isLogsKept();
    }

    @Override
    public void keepLogicalLogs(boolean keepLogs) {
        this.logicalLog.setKeepLogs(keepLogs);
    }

    @Override
    public long rotateLogicalLog() throws IOException {
        return this.logicalLog.rotate();
    }

    @Override
    public void setAutoRotate(boolean rotate) {
        this.logicalLog.setAutoRotateLogs(rotate);
    }

    @Override
    public void setLogicalLogTargetSize(long size) {
        this.logicalLog.setLogicalLogTargetSize(size);
    }

    @Override
    public String getFileName(long version) {
        return this.logicalLog.getFileName(version);
    }

    @Override
    public ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        return this.logicalLog.getPreparedTransaction(identifier);
    }

    @Override
    public void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        this.logicalLog.getPreparedTransaction(identifier, targetBuffer);
    }

    @Override
    public Pair<Integer, Long> getMasterForCommittedTx(long txId) throws IOException {
        return this.logicalLog.getMasterIdForCommittedTransaction(txId);
    }

    @Override
    public XaLogicalLog.LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
        return this.logicalLog.getLogExtractor(startTxId, endTxIdHint);
    }

    protected void setKeepLogicalLogsIfSpecified(String configString, String dataSourceName) {
        Boolean keepLogs = this.shouldKeepLog(configString, dataSourceName);
        if (keepLogs != null) {
            this.getXaContainer().getLogicalLog().setKeepLogs(keepLogs);
        }
    }
}

