/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

class IntArrayIterator
extends PrefetchingIterator<Relationship>
implements Iterable<Relationship> {
    private Iterator<RelIdIterator> typeIterator;
    private RelIdIterator currentTypeIterator;
    private final NodeImpl fromNode;
    private final RelIdArray.DirectionWrapper direction;
    private final NodeManager nodeManager;
    private final RelationshipType[] types;
    private final List<RelIdIterator> rels;
    private boolean isFullyLoaded;

    IntArrayIterator(List<RelIdIterator> rels, NodeImpl fromNode, RelIdArray.DirectionWrapper direction, NodeManager nodeManager, RelationshipType[] types, boolean isFullyLoaded) {
        this.rels = rels;
        this.isFullyLoaded = isFullyLoaded;
        this.typeIterator = rels.iterator();
        this.currentTypeIterator = this.typeIterator.hasNext() ? this.typeIterator.next() : RelIdArray.EMPTY.iterator(direction);
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
        this.types = types;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return this;
    }

    @Override
    protected Relationship fetchNextOrNull() {
        block2: do {
            if (this.currentTypeIterator.hasNext()) {
                long nextId = this.currentTypeIterator.next();
                try {
                    return new RelationshipProxy(nextId, this.nodeManager);
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
            while (!this.currentTypeIterator.hasNext()) {
                if (this.typeIterator.hasNext()) {
                    this.currentTypeIterator = this.typeIterator.next();
                    continue;
                }
                if (!this.fromNode.getMoreRelationships(this.nodeManager) && this.isFullyLoaded) continue block2;
                HashMap<String, RelIdIterator> newRels = new HashMap<String, RelIdIterator>();
                for (RelIdIterator itr : this.rels) {
                    String type = itr.getType();
                    RelIdArray newSrc = this.fromNode.getRelationshipIds(type);
                    if (newSrc != null) {
                        itr = itr.updateSource(newSrc);
                        itr.doAnotherRound();
                    }
                    newRels.put(type, itr);
                }
                if (this.types.length == 0) {
                    for (RelIdArray ids : this.fromNode.getRelationshipIds()) {
                        String type = ids.getType();
                        RelIdIterator itr = (RelIdIterator)newRels.get(type);
                        if (itr == null) {
                            Collection<Long> remove = this.nodeManager.getCowRelationshipRemoveMap(this.fromNode, type);
                            itr = remove == null ? ids.iterator(this.direction) : RelIdArray.from(ids, null, remove).iterator(this.direction);
                            newRels.put(type, itr);
                            continue;
                        }
                        itr = itr.updateSource(ids);
                        newRels.put(type, itr);
                    }
                }
                this.rels.clear();
                this.rels.addAll(newRels.values());
                this.typeIterator = this.rels.iterator();
                this.currentTypeIterator = this.typeIterator.hasNext() ? this.typeIterator.next() : RelIdArray.EMPTY.iterator(this.direction);
                this.isFullyLoaded = !this.fromNode.hasMoreRelationshipsToLoad();
            }
        } while (this.currentTypeIterator.hasNext());
        return null;
    }
}

