/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.annotations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.neo4j.kernel.impl.annotations.CompilationManipulator;

public abstract class AnnotationProcessor
extends AbstractProcessor {
    private CompilationManipulator manipulator = null;
    private static Pattern nl = Pattern.compile("\n");

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.manipulator = CompilationManipulator.load(this, processingEnv);
        if (this.manipulator == null) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Cannot write values to this compiler: " + processingEnv.getClass().getName());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!((Object)annotationMirror.getAnnotationType().asElement()).equals(typeElement)) continue;
                    try {
                        this.process(typeElement, element, annotationMirror, this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error: " + e.toString(), element, annotationMirror);
                    }
                }
            }
        }
        return false;
    }

    protected final void warn(Element element, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
    }

    protected final void warn(Element element, AnnotationMirror annotation, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element, annotation);
    }

    protected final void error(Element element, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    protected final void error(Element element, AnnotationMirror annotation, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element, annotation);
    }

    protected final boolean updateAnnotationValue(Element annotated, AnnotationMirror annotation, String key, String value) {
        return this.manipulator != null && this.manipulator.updateAnnotationValue(annotated, annotation, key, value);
    }

    protected final boolean addAnnotation(Element target, Class<? extends Annotation> annotation, Object value) {
        return this.addAnnotation(target, annotation, Collections.singletonMap("value", value));
    }

    protected final boolean addAnnotation(Element target, Class<? extends Annotation> annotation, String key, Object value) {
        return this.addAnnotation(target, annotation, Collections.singletonMap(key, value));
    }

    protected final boolean addAnnotation(Element target, Class<? extends Annotation> annotation) {
        return this.addAnnotation(target, annotation, Collections.<String, Object>emptyMap());
    }

    protected final boolean addAnnotation(Element target, Class<? extends Annotation> annotation, Map<String, Object> parameters) {
        return this.manipulator != null && this.manipulator.addAnnotation(target, AnnotationProcessor.nameOf(annotation), parameters);
    }

    private static String nameOf(Class<? extends Annotation> annotation) {
        return annotation.getName().replace('$', '.');
    }

    protected abstract void process(TypeElement var1, Element var2, AnnotationMirror var3, Map<? extends ExecutableElement, ? extends AnnotationValue> var4) throws IOException;

    void addTo(String line, String ... path) throws IOException {
        File file;
        FileObject fo = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.path(path));
        URI uri = fo.toUri();
        try {
            file = new File(uri);
        }
        catch (Exception e) {
            file = new File(uri.toString());
        }
        if (file.exists()) {
            for (String previous : nl.split(fo.getCharContent(true), 0)) {
                if (!line.equals(previous)) continue;
                return;
            }
        } else {
            file.getParentFile().mkdirs();
        }
        new FileWriter(file, true).append(line).append("\n").close();
    }

    Writer append(String ... path) throws IOException {
        FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.path(path));
        URI uri = file.toUri();
        return new FileWriter(new File(uri.toString()), true);
    }

    private String path(String[] path) {
        StringBuilder filename = new StringBuilder();
        String sep = "";
        for (String part : path) {
            filename.append(sep).append(part);
            sep = "/";
        }
        return filename.toString();
    }
}

