/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LongerShortString;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.ShortArray;
import org.neo4j.kernel.impl.util.Bits;

public enum PropertyType {
    BOOL(1){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return this.getValue(block.getSingleValueLong());
        }

        private Boolean getValue(long propBlock) {
            return (propBlock & 1L) == 1L ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forBoolean(block.getKeyIndexId(), propertyId, this.getValue(block.getSingleValueLong()));
        }
    }
    ,
    BYTE(2){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return block.getSingleValueByte();
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forByte(block.getKeyIndexId(), propertyId, block.getSingleValueByte());
        }
    }
    ,
    SHORT(3){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return block.getSingleValueShort();
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forShort(block.getKeyIndexId(), propertyId, block.getSingleValueShort());
        }
    }
    ,
    CHAR(4){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return Character.valueOf((char)block.getSingleValueShort());
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forChar(block.getKeyIndexId(), propertyId, (char)block.getSingleValueShort());
        }
    }
    ,
    INT(5){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return block.getSingleValueInt();
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forInt(block.getKeyIndexId(), propertyId, block.getSingleValueInt());
        }
    }
    ,
    LONG(6){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return this.getLongValue(block);
        }

        private long getLongValue(PropertyBlock block) {
            long firstBlock = block.getSingleValueBlock();
            return this.valueIsInlined(firstBlock) ? block.getSingleValueLong() >>> 1 : block.getValueBlocks()[1];
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forLong(block.getKeyIndexId(), propertyId, this.getLongValue(block));
        }

        private boolean valueIsInlined(long firstBlock) {
            return (firstBlock & 0x10000000L) > 0L;
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return this.valueIsInlined(firstBlock) ? 1 : 2;
        }
    }
    ,
    FLOAT(7){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return Float.valueOf(this.getValue(block.getSingleValueInt()));
        }

        private float getValue(int propBlock) {
            return Float.intBitsToFloat(propBlock);
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forFloat(block.getKeyIndexId(), propertyId, this.getValue(block.getSingleValueInt()));
        }
    }
    ,
    DOUBLE(8){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return this.getValue(block.getValueBlocks()[1]);
        }

        private double getValue(long propBlock) {
            return Double.longBitsToDouble(propBlock);
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forDouble(block.getKeyIndexId(), propertyId, this.getValue(block.getValueBlocks()[1]));
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return 2;
        }
    }
    ,
    STRING(9){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getStringFor(block);
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forStringOrArray(block.getKeyIndexId(), propertyId, extractedValue);
        }
    }
    ,
    ARRAY(10){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getArrayFor(block);
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forStringOrArray(block.getKeyIndexId(), propertyId, extractedValue);
        }
    }
    ,
    SHORT_STRING(11){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return LongerShortString.decode(block);
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forStringOrArray(block.getKeyIndexId(), propertyId, this.getValue(block, null));
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return LongerShortString.calculateNumberOfBlocksUsed(firstBlock);
        }
    }
    ,
    SHORT_ARRAY(12){

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return ShortArray.decode(block);
        }

        @Override
        public PropertyData newPropertyData(PropertyBlock block, long propertyId, Object extractedValue) {
            return PropertyDatas.forStringOrArray(block.getKeyIndexId(), propertyId, this.getValue(block, null));
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return ShortArray.calculateNumberOfBlocksUsed(firstBlock);
        }
    };

    private final int type;
    private static int payloadSize;

    private PropertyType(int type) {
        this.type = type;
    }

    public int intValue() {
        return this.type;
    }

    public byte byteValue() {
        return (byte)this.type;
    }

    public abstract Object getValue(PropertyBlock var1, PropertyStore var2);

    public abstract PropertyData newPropertyData(PropertyBlock var1, long var2, Object var4);

    public static PropertyType getPropertyType(long propBlock, boolean nullOnIllegal) {
        int type = (int)((propBlock & 0xF000000L) >> 24);
        switch (type) {
            case 1: {
                return BOOL;
            }
            case 2: {
                return BYTE;
            }
            case 3: {
                return SHORT;
            }
            case 4: {
                return CHAR;
            }
            case 5: {
                return INT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return FLOAT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return STRING;
            }
            case 10: {
                return ARRAY;
            }
            case 11: {
                return SHORT_STRING;
            }
            case 12: {
                return SHORT_ARRAY;
            }
        }
        if (nullOnIllegal) {
            return null;
        }
        throw new InvalidRecordException("Unknown property type for type " + type);
    }

    public static void main(String[] args) {
        System.out.println(Bits.bits(8).put(-78L));
    }

    public static int getPayloadSize() {
        return payloadSize;
    }

    public static int getPayloadSizeLongs() {
        return payloadSize >>> 3;
    }

    public static void setPayloadSize(int newPayloadSize) {
        if (newPayloadSize % 8 != 0) {
            throw new RuntimeException("Payload must be divisible by 8");
        }
        payloadSize = newPayloadSize;
    }

    public int calculateNumberOfBlocksUsed(long firstBlock) {
        return 1;
    }

    static {
        payloadSize = 32;
    }
}

