/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;

public class PropertyBlock {
    private final List<DynamicRecord> valueRecords = new LinkedList<DynamicRecord>();
    private long[] valueBlocks;
    private boolean isCreated;

    public PropertyType getType() {
        return this.valueBlocks == null ? null : PropertyType.getPropertyType(this.valueBlocks[0], false);
    }

    public int getKeyIndexId() {
        return (int)(this.valueBlocks[0] & 0xFFFFFFL);
    }

    public void setSingleBlock(long value) {
        this.valueBlocks = new long[1];
        this.valueBlocks[0] = value;
        this.valueRecords.clear();
    }

    public void addValueRecord(DynamicRecord record) {
        this.valueRecords.add(record);
    }

    public List<DynamicRecord> getValueRecords() {
        return this.valueRecords;
    }

    public long getSingleValueBlock() {
        return this.valueBlocks[0];
    }

    public long getSingleValueLong() {
        return (this.valueBlocks[0] & 0xFFFFFFFFF0000000L) >>> 28;
    }

    public int getSingleValueInt() {
        return (int)((this.valueBlocks[0] & 0xFFFFFFFF0000000L) >>> 28);
    }

    public short getSingleValueShort() {
        return (short)((this.valueBlocks[0] & 0xFFFF0000000L) >>> 28);
    }

    public byte getSingleValueByte() {
        return (byte)((this.valueBlocks[0] & 0xFF0000000L) >>> 28);
    }

    public long[] getValueBlocks() {
        return this.valueBlocks;
    }

    public boolean isLight() {
        return this.valueRecords.size() == 0;
    }

    public PropertyData newPropertyData(PropertyRecord parent) {
        return this.newPropertyData(parent, null);
    }

    public PropertyData newPropertyData(PropertyRecord parent, Object extractedValue) {
        return this.getType().newPropertyData(this, parent.getId(), extractedValue);
    }

    public void setValueBlocks(long[] blocks) {
        assert (blocks == null || blocks.length <= PropertyType.getPayloadSizeLongs()) : "i was given an array of size " + blocks.length;
        this.valueBlocks = blocks;
        this.valueRecords.clear();
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public void setCreated() {
        this.isCreated = true;
    }

    public int getSize() {
        return this.valueBlocks == null ? 0 : this.valueBlocks.length * 8;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("PropertyBlock[");
        result.append(this.valueBlocks == null ? -1 : this.getKeyIndexId()).append(", ").append((Object)this.getType());
        result.append(", ").append(this.valueBlocks == null ? "null" : "blocks[" + this.valueBlocks.length + "]").append(", ");
        result.append("ValueRecords[");
        if (!this.isLight()) {
            Iterator<DynamicRecord> recIt = this.valueRecords.iterator();
            while (recIt.hasNext()) {
                result.append(recIt.next());
                if (!recIt.hasNext()) continue;
                result.append(", ");
            }
        } else {
            result.append("<none>");
        }
        result.append("]]");
        return result.toString();
    }
}

