/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.StringTokenizer;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class XaDataSource {
    private byte[] branchId = null;
    private String name = null;
    private final StringLogger msgLog;

    public XaDataSource(Map<?, ?> params) throws InstantiationException {
        String storeDir = (String)params.get("store_dir");
        this.msgLog = StringLogger.getLogger(storeDir + "/messages.log");
    }

    public abstract XaConnection getXaConnection();

    public abstract void close();

    public void setBranchId(byte[] branchId) {
        this.branchId = branchId;
    }

    public byte[] getBranchId() {
        return this.branchId;
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String getFileName(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getRandomIdentifier() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getCurrentLogVersion() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void applyLog(ReadableByteChannel byteChannel) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void rotateLogicalLog() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean hasLogicalLog(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getLogicalLogLength(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean deleteLogicalLog(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void keepLogicalLogs(boolean keepLogs) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isLogicalLogKept() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void makeBackupSlave() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setAutoRotate(boolean rotate) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setLogicalLogTargetSize(long size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected boolean shouldKeepLog(String config, String resourceName) {
        if (config != null) {
            if (config.equals(Boolean.TRUE.toString())) {
                return true;
            }
            StringTokenizer tok = new StringTokenizer(config, ",");
            while (tok.hasMoreTokens()) {
                String element = tok.nextToken().trim();
                if (!resourceName.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    public ReadableByteChannel getCommittedTransaction(long txId) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void getCommittedTransaction(long tx, LogBuffer buffer) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void applyCommittedTransaction(long txId, ReadableByteChannel transaction) throws IOException {
        this.getXaContainer().getResourceManager().applyCommittedTransaction(transaction, txId);
    }

    public long applyPreparedTransaction(ReadableByteChannel transaction) throws IOException {
        return this.getXaContainer().getResourceManager().applyPreparedTransaction(transaction);
    }

    public long getLastCommittedTxId() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public XaContainer getXaContainer() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int getMasterForCommittedTx(long txId) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ClosableIterable<File> listStoreFiles() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

