/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class NeoStore
extends AbstractStore {
    private static final String VERSION = "NeoStore v0.9.6";
    private static final int RECORD_SIZE = 9;
    private static final int DEFAULT_REL_GRAB_SIZE = 100;
    private NodeStore nodeStore;
    private PropertyStore propStore;
    private RelationshipStore relStore;
    private RelationshipTypeStore relTypeStore;
    private final LastCommittedTxIdSetter lastCommittedTxIdSetter;
    private final IdGeneratorFactory idGeneratorFactory;
    private boolean isStarted;
    private long lastCommittedTx = -1L;
    private final int REL_GRAB_SIZE;
    private static final Random r = new Random(System.currentTimeMillis());

    public NeoStore(Map<?, ?> config) {
        super((String)config.get("neo_store"), config, IdType.NEOSTORE_BLOCK);
        String grabSize;
        int relGrabSize = 100;
        if (this.getConfig() != null && (grabSize = (String)this.getConfig().get("relationship_grab_size")) != null) {
            relGrabSize = Integer.parseInt(grabSize);
        }
        this.REL_GRAB_SIZE = relGrabSize;
        this.lastCommittedTxIdSetter = (LastCommittedTxIdSetter)config.get(LastCommittedTxIdSetter.class);
        this.idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
    }

    @Override
    protected void initStorage() {
        this.relTypeStore = new RelationshipTypeStore(this.getStorageFileName() + ".relationshiptypestore.db", this.getConfig(), IdType.RELATIONSHIP_TYPE);
        this.propStore = new PropertyStore(this.getStorageFileName() + ".propertystore.db", this.getConfig());
        this.relStore = new RelationshipStore(this.getStorageFileName() + ".relationshipstore.db", this.getConfig());
        this.nodeStore = new NodeStore(this.getStorageFileName() + ".nodestore.db", this.getConfig());
    }

    @Override
    protected void closeStorage() {
        if (this.relTypeStore != null) {
            this.relTypeStore.close();
            this.relTypeStore = null;
        }
        if (this.propStore != null) {
            this.propStore.close();
            this.propStore = null;
        }
        if (this.relStore != null) {
            this.relStore.close();
            this.relStore = null;
        }
        if (this.nodeStore != null) {
            this.nodeStore.close();
            this.nodeStore = null;
        }
    }

    @Override
    public void flushAll() {
        if (this.relTypeStore == null || this.propStore == null || this.relStore == null || this.nodeStore == null) {
            return;
        }
        this.relTypeStore.flushAll();
        this.propStore.flushAll();
        this.relStore.flushAll();
        this.nodeStore.flushAll();
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public static void createStore(String fileName, Map<?, ?> config) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        NeoStore.createEmptyStore(fileName, VERSION, idGeneratorFactory);
        NodeStore.createStore(fileName + ".nodestore.db", config);
        RelationshipStore.createStore(fileName + ".relationshipstore.db", idGeneratorFactory);
        PropertyStore.createStore(fileName + ".propertystore.db", config);
        RelationshipTypeStore.createStore(fileName + ".relationshiptypestore.db", config);
        if (!config.containsKey("neo_store")) {
            HashMap newConfig = new HashMap(config);
            newConfig.put("neo_store", fileName);
            config = newConfig;
        }
        NeoStore neoStore = new NeoStore(config);
        neoStore.nextId();
        neoStore.nextId();
        neoStore.nextId();
        neoStore.nextId();
        long time = System.currentTimeMillis();
        neoStore.setCreationTime(time);
        neoStore.setRandomNumber(r.nextLong());
        neoStore.setVersion(0L);
        neoStore.setLastCommittedTx(1L);
        neoStore.close();
    }

    public long getCreationTime() {
        return this.getRecord(0);
    }

    public void setCreationTime(long time) {
        this.setRecord(0, time);
    }

    public long getRandomNumber() {
        return this.getRecord(1);
    }

    public void setRandomNumber(long nr) {
        this.setRecord(1, nr);
    }

    public void setRecoveredStatus(boolean status) {
        if (status) {
            this.setRecovered();
        } else {
            this.unsetRecovered();
        }
    }

    public long getVersion() {
        return this.getRecord(2);
    }

    public void setVersion(long version) {
        this.setRecord(2, version);
    }

    public synchronized void setLastCommittedTx(long txId) {
        long current = this.getRecord(3);
        if (current + 1L != txId && !this.isInRecoveryMode()) {
            throw new InvalidRecordException("Could not set tx commit id[" + txId + "] since the current one is[" + current + "]");
        }
        this.setRecord(3, txId);
        if (this.isStarted && this.lastCommittedTxIdSetter != null && txId != this.lastCommittedTx) {
            try {
                this.lastCommittedTxIdSetter.setLastCommittedTxId(txId);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.lastCommittedTx = txId;
    }

    public long getNextCommitId() {
        return this.getRecord(3) + 1L;
    }

    public synchronized long getLastCommittedTx() {
        if (this.lastCommittedTx == -1L) {
            this.lastCommittedTx = this.getRecord(3);
        }
        return this.lastCommittedTx;
    }

    public long incrementVersion() {
        long current = this.getVersion();
        this.setVersion(current + 1L);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRecord(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.get();
            long l = buffer.getLong();
            return l;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecord(int id, long value) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.put(Record.IN_USE.byteValue()).putLong(value);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public RelationshipStore getRelationshipStore() {
        return this.relStore;
    }

    public RelationshipTypeStore getRelationshipTypeStore() {
        return this.relTypeStore;
    }

    public PropertyStore getPropertyStore() {
        return this.propStore;
    }

    @Override
    public void makeStoreOk() {
        this.relTypeStore.makeStoreOk();
        this.propStore.makeStoreOk();
        this.relStore.makeStoreOk();
        this.nodeStore.makeStoreOk();
        super.makeStoreOk();
        this.isStarted = true;
    }

    @Override
    public void rebuildIdGenerators() {
        this.relTypeStore.rebuildIdGenerators();
        this.propStore.rebuildIdGenerators();
        this.relStore.rebuildIdGenerators();
        this.nodeStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.updateHighId();
        this.relTypeStore.updateIdGenerators();
        this.propStore.updateIdGenerators();
        this.relStore.updateHighId();
        this.nodeStore.updateHighId();
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("NeoStore")) {
            return false;
        }
        if (version.equals("NeoStore v0.9.5")) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[9]);
            buffer.put(Record.IN_USE.byteValue()).putLong(1L);
            buffer.flip();
            try {
                this.getFileChannel().write(buffer, 27L);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return false;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    public int getRelationshipGrabSize() {
        return this.REL_GRAB_SIZE;
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.addAll(this.nodeStore.getAllWindowPoolStats());
        list.addAll(this.propStore.getAllWindowPoolStats());
        list.addAll(this.relStore.getAllWindowPoolStats());
        list.addAll(this.relTypeStore.getAllWindowPoolStats());
        return list;
    }

    public boolean isStoreOk() {
        return this.getStoreOk() && this.relTypeStore.getStoreOk() && this.propStore.getStoreOk() && this.relStore.getStoreOk() && this.nodeStore.getStoreOk();
    }
}

