/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.GraphDbInstance;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IndexManagerImpl;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.KernelExtensionLoader;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxFinishHook;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.util.StringLogger;

class EmbeddedGraphDbImpl {
    private static final String KERNEL_VERSION = Version.get();
    private static Logger log = Logger.getLogger(EmbeddedGraphDbImpl.class.getName());
    private Transaction placeboTransaction = null;
    private final GraphDbInstance graphDbInstance;
    private final GraphDatabaseService graphDbService;
    private final NodeManager nodeManager;
    private final String storeDir;
    private final List<KernelEventHandler> kernelEventHandlers = new CopyOnWriteArrayList<KernelEventHandler>();
    private final Collection<TransactionEventHandler<?>> transactionEventHandlers = new CopyOnWriteArraySet();
    private final KernelPanicEventGenerator kernelPanicEventGenerator = new KernelPanicEventGenerator(this.kernelEventHandlers);
    private final KernelExtension.KernelData extensions;
    private final IndexManagerImpl indexManager;
    private final StringLogger msgLog;
    private boolean inShutdown = false;

    public EmbeddedGraphDbImpl(String storeDir, Map<String, String> inputParams, GraphDatabaseService graphDbService, LockManagerFactory lockManagerFactory, IdGeneratorFactory idGeneratorFactory, RelationshipTypeCreator relTypeCreator, TxIdGeneratorFactory txIdFactory, TxFinishHook finishHook, LastCommittedTxIdSetter lastCommittedTxIdSetter) {
        this.storeDir = storeDir;
        TxModule txModule = this.newTxModule(inputParams, finishHook);
        LockManager lockManager = lockManagerFactory.create(txModule);
        LockReleaser lockReleaser = new LockReleaser(lockManager, txModule.getTxManager());
        final Config config = new Config(graphDbService, storeDir, inputParams, this.kernelPanicEventGenerator, txModule, lockManager, lockReleaser, idGeneratorFactory, new SyncHookFactory(), relTypeCreator, txIdFactory.create(txModule.getTxManager()), lastCommittedTxIdSetter);
        this.graphDbInstance = new GraphDbInstance(storeDir, true, config);
        this.msgLog = StringLogger.getLogger(storeDir + "/messages.log");
        this.graphDbService = graphDbService;
        IndexStore indexStore = this.graphDbInstance.getConfig().getIndexStore();
        this.indexManager = new IndexManagerImpl(this, indexStore);
        this.extensions = new KernelExtension.KernelData(){

            @Override
            public String version() {
                return KERNEL_VERSION;
            }

            @Override
            public Config getConfig() {
                return config;
            }

            @Override
            public Map<Object, Object> getConfigParams() {
                return config.getParams();
            }

            @Override
            public GraphDatabaseService graphDatabase() {
                return EmbeddedGraphDbImpl.this.graphDbService;
            }

            @Override
            protected void initialized(KernelExtension extension) {
                if (extension instanceof IndexProvider) {
                    EmbeddedGraphDbImpl.this.indexManager.addProvider(extension.getKey(), (IndexProvider)extension);
                }
            }
        };
        KernelExtensionLoader extensionLoader = new KernelExtensionLoader(){

            @Override
            public void init() {
                EmbeddedGraphDbImpl.this.extensions.initAll(EmbeddedGraphDbImpl.this.msgLog);
            }

            @Override
            public void load() {
                EmbeddedGraphDbImpl.this.extensions.loadAll(EmbeddedGraphDbImpl.this.msgLog);
            }
        };
        this.graphDbInstance.start(graphDbService, extensionLoader);
        this.nodeManager = config.getGraphDbModule().getNodeManager();
        extensionLoader.load();
    }

    private TxModule newTxModule(Map<String, String> inputParams, TxFinishHook rollbackHook) {
        return Boolean.parseBoolean(inputParams.get("read_only")) ? new TxModule(true, this.kernelPanicEventGenerator) : new TxModule(this.storeDir, this.kernelPanicEventGenerator, rollbackHook, inputParams.get("tx_manager_impl"));
    }

    <T> T getManagementBean(Class<T> beanClass) {
        KernelExtension jmx = Service.load(KernelExtension.class, "kernel jmx");
        KernelExtension.Function<T> getBean = null;
        if (jmx != null && jmx.isLoaded(this.extensions)) {
            getBean = jmx.function(this.extensions, "getBean", beanClass, Class.class);
        }
        if (getBean == null) {
            throw new UnsupportedOperationException("Neo4j JMX support not enabled");
        }
        return getBean.call(beanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadConfigurations(String file) {
        Properties props = new Properties();
        try {
            FileInputStream stream = new FileInputStream(new File(file));
            try {
                props.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load " + file, e);
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        HashMap<String, String> stringProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            stringProps.put(key, value);
        }
        return stringProps;
    }

    public Node createNode() {
        return this.nodeManager.createNode();
    }

    public Node getNodeById(long id) {
        if (id < 0L || id > 0xFFFFFFFEL) {
            throw new NotFoundException("Node[" + id + "]");
        }
        return this.nodeManager.getNodeById((int)id);
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > 0xFFFFFFFEL) {
            throw new NotFoundException("Relationship[" + id + "]");
        }
        return this.nodeManager.getRelationshipById((int)id);
    }

    public Node getReferenceNode() {
        return this.nodeManager.getReferenceNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.inShutdown) {
            return;
        }
        this.inShutdown = true;
        try {
            if (this.graphDbInstance.started()) {
                this.sendShutdownEvent();
                this.extensions.shutdown(this.msgLog);
            }
            this.graphDbInstance.shutdown();
        }
        finally {
            this.inShutdown = false;
        }
    }

    private void sendShutdownEvent() {
        for (KernelEventHandler handler : this.kernelEventHandlers) {
            handler.beforeShutdown();
        }
    }

    public boolean enableRemoteShell() {
        return this.enableRemoteShell(null);
    }

    public boolean enableRemoteShell(Map<String, Serializable> config) {
        KernelExtension shell = Service.load(KernelExtension.class, "shell");
        KernelExtension.Function<Void> enable = null;
        if (shell != null) {
            enable = shell.function(this.extensions, "enableRemoteShell", Void.TYPE, Map.class);
        }
        if (enable == null) {
            log.info("Shell library not available. Neo4j shell not started. Please add the Neo4j shell jar to the classpath.");
            return false;
        }
        enable.call(config);
        return true;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.graphDbInstance.getRelationshipTypes();
    }

    public Transaction beginTx() {
        if (this.graphDbInstance.transactionRunning()) {
            if (this.placeboTransaction == null) {
                this.placeboTransaction = new PlaceboTransaction(this.graphDbInstance.getTransactionManager());
            }
            return this.placeboTransaction;
        }
        TransactionManager txManager = this.graphDbInstance.getTransactionManager();
        TopLevelTransaction result = null;
        try {
            txManager.begin();
            result = new TopLevelTransaction(txManager);
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to begin transaction", e);
        }
        return result;
    }

    public Config getConfig() {
        return this.graphDbInstance.getConfig();
    }

    public String toString() {
        return super.toString() + " [" + this.storeDir + "]";
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public Iterable<Node> getAllNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                long highId = EmbeddedGraphDbImpl.this.nodeManager.getHighestPossibleIdInUse(Node.class) & 0xFFFFFFFFL;
                return new AllNodesIterator(highId);
            }
        };
    }

    <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return handler;
    }

    <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.unregisterHandler(this.transactionEventHandlers, handler);
    }

    KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        if (this.kernelEventHandlers.contains(handler)) {
            return handler;
        }
        for (KernelEventHandler registeredHandler : this.kernelEventHandlers) {
            KernelEventHandler.ExecutionOrder order = handler.orderComparedTo(registeredHandler);
            int index = this.kernelEventHandlers.indexOf(registeredHandler);
            if (order == KernelEventHandler.ExecutionOrder.BEFORE) {
                this.kernelEventHandlers.add(index, handler);
                return handler;
            }
            if (order != KernelEventHandler.ExecutionOrder.AFTER) continue;
            this.kernelEventHandlers.add(index + 1, handler);
            return handler;
        }
        this.kernelEventHandlers.add(handler);
        return handler;
    }

    KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.unregisterHandler(this.kernelEventHandlers, handler);
    }

    private <T> T unregisterHandler(Collection<?> setOfHandlers, T handler) {
        if (!setOfHandlers.remove(handler)) {
            throw new IllegalStateException(handler + " isn't registered");
        }
        return handler;
    }

    IndexManager index() {
        return this.indexManager;
    }

    KernelExtension.KernelData getKernelData() {
        return this.extensions;
    }

    private class SyncHookFactory
    implements TxEventSyncHookFactory {
        private SyncHookFactory() {
        }

        @Override
        public TransactionEventsSyncHook create() {
            return EmbeddedGraphDbImpl.this.transactionEventHandlers.isEmpty() ? null : new TransactionEventsSyncHook(EmbeddedGraphDbImpl.this.nodeManager, EmbeddedGraphDbImpl.this.transactionEventHandlers, EmbeddedGraphDbImpl.this.getConfig().getTxModule().getTxManager());
        }
    }

    private class AllNodesIterator
    implements Iterator<Node> {
        private final long highId;
        private long currentNodeId = 0L;
        private Node currentNode = null;

        AllNodesIterator(long highId) {
            this.highId = highId;
        }

        @Override
        public synchronized boolean hasNext() {
            while (this.currentNode == null && this.currentNodeId <= this.highId) {
                try {
                    this.currentNode = EmbeddedGraphDbImpl.this.getNodeById(this.currentNodeId++);
                }
                catch (NotFoundException notFoundException) {}
            }
            return this.currentNode != null;
        }

        @Override
        public synchronized Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node nextNode = this.currentNode;
            this.currentNode = null;
            return nextNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

