/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdGeneratorImpl;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxFinishHook;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;

public class CommonFactories {
    public static LockManagerFactory defaultLockManagerFactory() {
        return new LockManagerFactory(){

            @Override
            public LockManager create(TxModule txModule) {
                return new LockManager(txModule.getTxManager());
            }
        };
    }

    public static IdGeneratorFactory defaultIdGeneratorFactory() {
        return new DefaultIdGeneratorFactory();
    }

    public static RelationshipTypeCreator defaultRelationshipTypeCreator() {
        return new DefaultRelationshipTypeCreator();
    }

    public static TxIdGeneratorFactory defaultTxIdGeneratorFactory() {
        return new TxIdGeneratorFactory(){

            @Override
            public TxIdGenerator create(TransactionManager txManager) {
                return TxIdGenerator.DEFAULT;
            }
        };
    }

    public static TxFinishHook defaultTxFinishHook() {
        return new TxFinishHook(){

            @Override
            public boolean hasAnyLocks(Transaction tx) {
                return false;
            }

            @Override
            public void finishTransaction(int eventIdentifier) {
            }
        };
    }

    public static LastCommittedTxIdSetter defaultLastCommittedTxIdSetter() {
        return new LastCommittedTxIdSetter(){

            @Override
            public void setLastCommittedTxId(long txId) {
            }
        };
    }

    public static class DefaultIdGeneratorFactory
    implements IdGeneratorFactory {
        private final Map<IdType, IdGenerator> generators = new HashMap<IdType, IdGenerator>();

        @Override
        public IdGenerator open(String fileName, int grabSize, IdType idType, long highestIdInUse) {
            IdGeneratorImpl generator = new IdGeneratorImpl(fileName, grabSize);
            this.generators.put(idType, generator);
            return generator;
        }

        @Override
        public IdGenerator get(IdType idType) {
            return this.generators.get((Object)idType);
        }

        @Override
        public void create(String fileName) {
            IdGeneratorImpl.createGenerator(fileName);
        }

        @Override
        public void updateIdGenerators(NeoStore neoStore) {
            neoStore.updateIdGenerators();
        }
    }
}

