/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.MultiEvaluator;
import org.neo4j.kernel.impl.traversal.TraverserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TraversalDescriptionImpl
implements TraversalDescription {
    final Expander expander;
    final UniquenessFactory uniqueness;
    final Object uniquenessParameter;
    final Evaluator evaluator;
    final BranchOrderingPolicy branchSelector;

    public TraversalDescriptionImpl() {
        this(StandardExpander.DEFAULT, Uniqueness.NODE_GLOBAL, null, Evaluators.all(), Traversal.preorderDepthFirst());
    }

    private TraversalDescriptionImpl(Expander expander, UniquenessFactory uniqueness, Object uniquenessParameter, Evaluator evaluator, BranchOrderingPolicy branchSelector) {
        this.expander = expander;
        this.uniqueness = uniqueness;
        this.uniquenessParameter = uniquenessParameter;
        this.evaluator = evaluator;
        this.branchSelector = branchSelector;
    }

    @Override
    public Traverser traverse(Node startNode) {
        return new TraverserImpl(this, startNode);
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness) {
        return new TraversalDescriptionImpl(this.expander, uniqueness, null, this.evaluator, this.branchSelector);
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness, Object parameter) {
        if (this.uniqueness == uniqueness && (this.uniquenessParameter == null ? parameter == null : this.uniquenessParameter.equals(parameter))) {
            return this;
        }
        return new TraversalDescriptionImpl(this.expander, uniqueness, parameter, this.evaluator, this.branchSelector);
    }

    @Override
    public TraversalDescription prune(PruneEvaluator pruning) {
        return this.evaluator(pruning == PruneEvaluator.NONE ? Evaluators.all() : new WrappedPruneEvaluator(pruning));
    }

    @Override
    public TraversalDescription filter(Predicate<Path> filter) {
        Evaluator evaluator = null;
        evaluator = filter == Traversal.returnAll() ? Evaluators.all() : (filter == Traversal.returnAllButStartNode() ? Evaluators.excludeStartPosition() : new WrappedFilter(filter));
        return this.evaluator(evaluator);
    }

    @Override
    public TraversalDescription evaluator(Evaluator evaluator) {
        if (this.evaluator == evaluator) {
            return this;
        }
        TraversalDescriptionImpl.nullCheck(evaluator, Evaluator.class, "RETURN_ALL");
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, this.addBlaEvaluator(evaluator), this.branchSelector);
    }

    private Evaluator addBlaEvaluator(Evaluator evaluator) {
        if (this.evaluator instanceof MultiEvaluator) {
            return ((MultiEvaluator)this.evaluator).add(evaluator);
        }
        if (this.evaluator == Evaluators.all()) {
            return evaluator;
        }
        return new MultiEvaluator(this.evaluator, evaluator);
    }

    private static <T> void nullCheck(T parameter, Class<T> parameterType, String defaultName) {
        if (parameter == null) {
            String typeName = parameterType.getSimpleName();
            throw new IllegalArgumentException(typeName + " may not be null, use " + typeName + "." + defaultName + " instead.");
        }
    }

    @Override
    public TraversalDescription order(BranchOrderingPolicy selector) {
        if (this.branchSelector == selector) {
            return this;
        }
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, this.evaluator, selector);
    }

    @Override
    public TraversalDescription depthFirst() {
        return this.order(Traversal.preorderDepthFirst());
    }

    @Override
    public TraversalDescription breadthFirst() {
        return this.order(Traversal.preorderBreadthFirst());
    }

    @Override
    public TraversalDescription relationships(RelationshipType type) {
        return this.relationships(type, Direction.BOTH);
    }

    @Override
    public TraversalDescription relationships(RelationshipType type, Direction direction) {
        return this.expand(this.expander.add(type, direction));
    }

    @Override
    public TraversalDescription expand(RelationshipExpander expander) {
        if (expander.equals(this.expander)) {
            return this;
        }
        return new TraversalDescriptionImpl(Traversal.expander(expander), this.uniqueness, this.uniquenessParameter, this.evaluator, this.branchSelector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrappedFilter
    implements Evaluator {
        private final Predicate<Path> filter;

        WrappedFilter(Predicate<Path> filter) {
            this.filter = filter;
        }

        @Override
        public Evaluation evaluate(Path path) {
            return this.filter.accept(path) ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.EXCLUDE_AND_CONTINUE;
        }
    }

    private static class WrappedPruneEvaluator
    implements Evaluator {
        private final PruneEvaluator pruning;

        WrappedPruneEvaluator(PruneEvaluator pruning) {
            this.pruning = pruning;
        }

        public Evaluation evaluate(Path path) {
            if (path.length() == 0) {
                return Evaluation.INCLUDE_AND_CONTINUE;
            }
            return this.pruning.pruneAfter(path) ? Evaluation.INCLUDE_AND_PRUNE : Evaluation.INCLUDE_AND_CONTINUE;
        }
    }
}

