/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

class DirectLogBuffer
implements LogBuffer {
    private final FileChannel fileChannel;
    private final ByteBuffer buffer;

    DirectLogBuffer(FileChannel fileChannel, ByteBuffer buffer) {
        if (fileChannel == null || buffer == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (buffer.capacity() < 8) {
            throw new IllegalArgumentException("Capacity less then 8");
        }
        this.fileChannel = fileChannel;
        this.buffer = buffer;
    }

    public LogBuffer put(byte b) throws IOException {
        this.buffer.clear();
        this.buffer.put(b);
        return this.flipAndWrite();
    }

    public LogBuffer putInt(int i) throws IOException {
        this.buffer.clear();
        this.buffer.putInt(i);
        return this.flipAndWrite();
    }

    public LogBuffer putLong(long l) throws IOException {
        this.buffer.clear();
        this.buffer.putLong(l);
        return this.flipAndWrite();
    }

    public LogBuffer putFloat(float f) throws IOException {
        this.buffer.clear();
        this.buffer.putFloat(f);
        return this.flipAndWrite();
    }

    public LogBuffer putDouble(double d) throws IOException {
        this.buffer.clear();
        this.buffer.putDouble(d);
        return this.flipAndWrite();
    }

    private LogBuffer flipAndWrite() throws IOException {
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
        return this;
    }

    public LogBuffer put(byte[] bytes) throws IOException {
        this.fileChannel.write(ByteBuffer.wrap(bytes));
        return this;
    }

    public LogBuffer put(char[] chars) throws IOException {
        int position = 0;
        do {
            this.buffer.clear();
            int leftToWrite = chars.length - position;
            if (leftToWrite * 2 < this.buffer.capacity()) {
                this.buffer.asCharBuffer().put(chars, position, leftToWrite);
                this.buffer.limit(leftToWrite * 2);
                this.fileChannel.write(this.buffer);
                position += leftToWrite;
                continue;
            }
            int length = this.buffer.capacity() / 2;
            this.buffer.asCharBuffer().put(chars, position, length);
            this.buffer.limit(length * 2);
            this.fileChannel.write(this.buffer);
            position += length;
        } while (position < chars.length);
        return this;
    }

    public void force() throws IOException {
        this.fileChannel.force(false);
    }

    public long getFileChannelPosition() throws IOException {
        return this.fileChannel.position();
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

