/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.MappedMemException;

class MappedPersistenceWindow
extends LockableWindow {
    private long position = -1L;
    private Buffer buffer = null;
    private int windowSize = -1;
    private int recordSize = -1;
    private int totalSize = -1;
    private volatile int hashCode = 0;

    MappedPersistenceWindow(long position, int recordSize, int totalSize, FileChannel channel, FileChannel.MapMode mapMode) {
        super(channel);
        assert (recordSize > 0) : "Record size[" + recordSize + "] must be greater then zero";
        assert (totalSize >= recordSize) : "Total size[" + totalSize + "] cannot be less than record size[" + recordSize + "]";
        assert (totalSize >= recordSize) : "Total size[" + totalSize + "] must mod to zero with record size[" + recordSize + "]";
        this.totalSize = totalSize;
        this.windowSize = totalSize / recordSize;
        this.recordSize = recordSize;
        this.position = position;
        try {
            this.buffer = new Buffer(this, channel.map(mapMode, position * (long)recordSize, totalSize));
        }
        catch (IOException e) {
            this.position = -1L;
            throw new MappedMemException("Unable to map pos=" + position + " recordSize=" + recordSize + " totalSize=" + totalSize, e);
        }
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public long position() {
        return this.position;
    }

    public int size() {
        return this.windowSize;
    }

    public void force() {
        ((MappedByteBuffer)this.buffer.getBuffer()).force();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MappedPersistenceWindow)) {
            return false;
        }
        return this.position() == ((MappedPersistenceWindow)o).position();
    }

    void unmap() {
        if (this.buffer != null) {
            ((MappedByteBuffer)this.buffer.getBuffer()).force();
            this.buffer.close();
            this.position = -1L;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.position();
        }
        return this.hashCode;
    }

    public String toString() {
        return "MappedPersistenceWindow[p=" + this.position + ",rs=" + this.recordSize + ",ws=" + this.windowSize + ",ts=" + this.totalSize + "]";
    }

    public void close() {
        this.buffer.close();
    }

    public Buffer getOffsettedBuffer(int id) {
        int offset = (int)(((long)id & 0xFFFFFFFFL) - this.buffer.position()) * this.recordSize;
        this.buffer.setOffset(offset);
        return this.buffer;
    }
}

