/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;

public class IndexProviderStore {
    private static final int FILE_LENGTH = 32;
    private long creationTime;
    private long randomIdentifier;
    private long version;
    private final FileChannel fileChannel;
    private final ByteBuffer buf = ByteBuffer.allocate(32);
    private long lastCommittedTx;

    public IndexProviderStore(String store) {
        if (!new File(store).exists()) {
            IndexProviderStore.create(store);
        }
        try {
            this.fileChannel = new RandomAccessFile(store, "rw").getChannel();
            int bytesRead = this.fileChannel.read(this.buf);
            if (bytesRead != 32 && bytesRead != 24) {
                throw new RuntimeException("Expected to read 32 or 24 bytes");
            }
            this.buf.flip();
            this.creationTime = this.buf.getLong();
            this.randomIdentifier = this.buf.getLong();
            this.version = this.buf.getLong();
            this.lastCommittedTx = bytesRead == 32 ? this.buf.getLong() : 1L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void create(String store) {
        if (new File(store).exists()) {
            throw new IllegalArgumentException(store + " already exist");
        }
        try {
            FileChannel fileChannel = new RandomAccessFile(store, "rw").getChannel();
            ByteBuffer buf = ByteBuffer.allocate(32);
            long time = System.currentTimeMillis();
            long identifier = new Random(time).nextLong();
            buf.putLong(time).putLong(identifier).putLong(0L).putLong(1L);
            buf.flip();
            IndexProviderStore.writeBuffer(fileChannel, buf);
            fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeBuffer(FileChannel fileChannel, ByteBuffer buf) throws IOException {
        if (fileChannel.write(buf) != 32) {
            throw new RuntimeException("Expected to write 32 bytes");
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomNumber() {
        return this.randomIdentifier;
    }

    public long getVersion() {
        return this.version;
    }

    public synchronized long incrementVersion() {
        long current = this.getVersion();
        ++this.version;
        this.writeOut();
        return current;
    }

    public synchronized void setVersion(long version) {
        this.version = version;
        this.writeOut();
    }

    public synchronized void setLastCommittedTx(long txId) {
        this.lastCommittedTx = txId;
    }

    public long getLastCommittedTx() {
        return this.lastCommittedTx;
    }

    private void writeOut() {
        this.buf.clear();
        this.buf.putLong(this.creationTime).putLong(this.randomIdentifier).putLong(this.version).putLong(this.lastCommittedTx);
        this.buf.flip();
        try {
            this.fileChannel.position(0L);
            IndexProviderStore.writeBuffer(this.fileChannel, this.buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.fileChannel.isOpen()) {
            return;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

