/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogBackedXaDataSource
extends XaDataSource {
    private XaLogicalLog logicalLog;

    public LogBackedXaDataSource(Map<?, ?> params) throws InstantiationException {
        super(params);
    }

    protected void setLogicalLogAtCreationTime(XaLogicalLog logicalLog) {
        if (this.logicalLog != null) {
            throw new RuntimeException("Logical log already set for " + this);
        }
        this.logicalLog = logicalLog;
    }

    @Override
    public void applyLog(ReadableByteChannel byteChannel) throws IOException {
        this.logicalLog.applyLog(byteChannel);
    }

    @Override
    public boolean deleteLogicalLog(long version) {
        return this.logicalLog.deleteLogicalLog(version);
    }

    @Override
    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.logicalLog.getLogicalLog(version);
    }

    @Override
    public long getLogicalLogLength(long version) {
        return this.logicalLog.getLogicalLogLength(version);
    }

    @Override
    public boolean hasLogicalLog(long version) {
        return this.logicalLog.hasLogicalLog(version);
    }

    @Override
    public boolean isLogicalLogKept() {
        return this.logicalLog.isLogsKept();
    }

    @Override
    public void keepLogicalLogs(boolean keepLogs) {
        this.logicalLog.setKeepLogs(keepLogs);
    }

    @Override
    public void rotateLogicalLog() throws IOException {
        this.logicalLog.rotate();
    }

    @Override
    public void setAutoRotate(boolean rotate) {
        this.logicalLog.setAutoRotateLogs(rotate);
    }

    @Override
    public void setLogicalLogTargetSize(long size) {
        this.logicalLog.setLogicalLogTargetSize(size);
    }

    @Override
    public void makeBackupSlave() {
        this.logicalLog.makeBackupSlave();
    }

    @Override
    public String getFileName(long version) {
        return this.logicalLog.getFileName(version);
    }

    @Override
    public ReadableByteChannel getCommittedTransaction(long txId) throws IOException {
        return this.logicalLog.getCommittedTransaction(txId);
    }

    @Override
    public ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        return this.logicalLog.getPreparedTransaction(identifier);
    }

    @Override
    public int getMasterForCommittedTx(long txId) throws IOException {
        return this.logicalLog.getMasterIdForCommittedTransaction(txId);
    }
}

