/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockException;
import org.neo4j.kernel.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RagManager {
    private final Map<Object, List<Transaction>> resourceMap = new HashMap<Object, List<Transaction>>();
    private final ArrayMap<Transaction, Object> waitingTxMap = new ArrayMap(5, false, true);
    private final TransactionManager tm;
    private final AtomicInteger deadlockCount = new AtomicInteger();

    RagManager(TransactionManager tm) {
        this.tm = tm;
    }

    long getDeadlockCount() {
        return this.deadlockCount.longValue();
    }

    synchronized void lockAcquired(Object resource, Transaction tx) {
        List<Transaction> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList != null) {
            assert (!lockingTxList.contains(tx));
            lockingTxList.add(tx);
        } else {
            lockingTxList = new LinkedList<Transaction>();
            lockingTxList.add(tx);
            this.resourceMap.put(resource, lockingTxList);
        }
    }

    synchronized void lockReleased(Object resource, Transaction tx) {
        List<Transaction> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList == null) {
            throw new LockException(resource + " not found in resource map");
        }
        if (!lockingTxList.remove(tx)) {
            throw new LockException(tx + "not found in locking tx list");
        }
        if (lockingTxList.size() == 0) {
            this.resourceMap.remove(resource);
        }
    }

    synchronized void stopWaitOn(Object resource, Transaction tx) {
        if (this.waitingTxMap.remove(tx) == null) {
            throw new LockException(tx + " not waiting on " + resource);
        }
    }

    synchronized void checkWaitOn(Object resource, Transaction tx) throws DeadlockDetectedException {
        List<Transaction> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList == null) {
            throw new LockException("Illegal resource[" + resource + "], not found in map");
        }
        if (this.waitingTxMap.get(tx) != null) {
            throw new LockException(tx + " already waiting for resource");
        }
        Iterator<Transaction> itr = lockingTxList.iterator();
        LinkedList<Transaction> checkedTransactions = new LinkedList<Transaction>();
        Stack<Object> graphStack = new Stack<Object>();
        graphStack.push(resource);
        while (itr.hasNext()) {
            Transaction lockingTx = itr.next();
            if (lockingTx.equals(tx)) continue;
            graphStack.push(tx);
            this.checkWaitOnRecursive(lockingTx, tx, checkedTransactions, graphStack);
            graphStack.pop();
        }
        this.waitingTxMap.put(tx, resource);
    }

    private synchronized void checkWaitOnRecursive(Transaction lockingTx2, Transaction waitingTx, List<Transaction> checkedTransactions, Stack<Object> graphStack) throws DeadlockDetectedException {
        if (lockingTx2.equals(waitingTx)) {
            StringBuffer circle = null;
            Object resource = null;
            do {
                lockingTx2 = (Transaction)graphStack.pop();
                resource = graphStack.pop();
                if (circle == null) {
                    circle = new StringBuffer();
                    circle.append(lockingTx2 + " <- " + resource);
                    continue;
                }
                circle.append(" <- " + lockingTx2 + " <- " + resource);
            } while (!graphStack.isEmpty());
            this.deadlockCount.incrementAndGet();
            throw new DeadlockDetectedException(waitingTx + " can't wait on resource " + resource + " since => " + circle);
        }
        checkedTransactions.add(lockingTx2);
        Object resource = this.waitingTxMap.get(lockingTx2);
        if (resource != null) {
            graphStack.push(resource);
            List<Transaction> lockingTxList = this.resourceMap.get(resource);
            if (lockingTxList != null) {
                for (Transaction lockingTx2 : lockingTxList) {
                    if (checkedTransactions.contains(lockingTx2)) continue;
                    graphStack.push(lockingTx2);
                    this.checkWaitOnRecursive(lockingTx2, waitingTx, checkedTransactions, graphStack);
                    graphStack.pop();
                }
            }
            graphStack.pop();
        }
    }

    synchronized void dumpStack() {
        System.out.print("Waiting list: ");
        Iterator<Transaction> transactions = this.waitingTxMap.keySet().iterator();
        if (!transactions.hasNext()) {
            System.out.println("No transactions waiting on resources");
        } else {
            System.out.println();
        }
        while (transactions.hasNext()) {
            Transaction tx = transactions.next();
            System.out.println("" + tx + "->" + this.waitingTxMap.get(tx));
        }
        System.out.print("Resource lock list: ");
        Iterator<Object> resources = this.resourceMap.keySet().iterator();
        if (!resources.hasNext()) {
            System.out.println("No locked resources found");
        } else {
            System.out.println();
        }
        while (resources.hasNext()) {
            Object resource = resources.next();
            System.out.print("" + resource + "->");
            Iterator<Transaction> itr = this.resourceMap.get(resource).iterator();
            if (!itr.hasNext()) {
                System.out.println(" Error empty list found");
            }
            while (itr.hasNext()) {
                System.out.print("" + itr.next());
                if (itr.hasNext()) {
                    System.out.print(",");
                    continue;
                }
                System.out.println();
            }
        }
    }

    Transaction getCurrentTransaction() {
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Could not get current transaction.", e);
        }
    }
}

