/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeStore
extends AbstractStore
implements Store {
    private static final String VERSION = "NodeStore v0.9.5";
    private static final int RECORD_SIZE = 9;

    public NodeStore(String fileName, Map<?, ?> config) {
        super(fileName, config, IdType.NODE);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public static void createStore(String fileName, Map<?, ?> config) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        NodeStore.createEmptyStore(fileName, VERSION, idGeneratorFactory);
        NodeStore store = new NodeStore(fileName, config);
        NodeRecord nodeRecord = new NodeRecord(store.nextId());
        nodeRecord.setInUse(true);
        store.updateRecord(nodeRecord);
        store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRecord getRecord(int id) {
        NodeRecord nodeRecord;
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            NodeRecord record;
            nodeRecord = record = this.getRecord(id, window, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseWindow(window);
            throw throwable;
        }
        this.releaseWindow(window);
        return nodeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(NodeRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unsetRecovered();
            throw throwable;
        }
        this.unsetRecovered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(NodeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseWindow(window);
            throw throwable;
        }
        this.releaseWindow(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLightNode(int id) {
        PersistenceWindow window;
        block5: {
            boolean bl;
            window = null;
            try {
                window = this.acquireWindow(id, OperationType.READ);
            }
            catch (InvalidRecordException e) {
                return false;
            }
            try {
                NodeRecord record = this.getRecord(id, window, true);
                if (record != null) break block5;
                bl = false;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.releaseWindow(window);
                throw throwable;
            }
            this.releaseWindow(window);
            return bl;
        }
        boolean bl = true;
        Object var6_8 = null;
        this.releaseWindow(window);
        return bl;
    }

    private NodeRecord getRecord(int id, PersistenceWindow window, boolean check) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        boolean bl = inUse = buffer.get() == Record.IN_USE.byteValue();
        if (!inUse) {
            if (check) {
                return null;
            }
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        NodeRecord nodeRecord = new NodeRecord(id);
        nodeRecord.setInUse(inUse);
        nodeRecord.setNextRel(buffer.getInt());
        nodeRecord.setNextProp(buffer.getInt());
        return nodeRecord;
    }

    private void updateRecord(NodeRecord record, PersistenceWindow window) {
        int id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            buffer.put(Record.IN_USE.byteValue()).putInt(record.getNextRel()).putInt(record.getNextProp());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    public String toString() {
        return "NodeStore";
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("NodeStore")) {
            return false;
        }
        if (version.equals("NodeStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }
}

