/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.MultiFilter;
import org.neo4j.kernel.impl.traversal.MultiPruneEvaluator;
import org.neo4j.kernel.impl.traversal.TraverserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TraversalDescriptionImpl
implements TraversalDescription {
    final Expander expander;
    final UniquenessFactory uniqueness;
    final Object uniquenessParameter;
    final PruneEvaluator pruning;
    final Predicate<Path> filter;
    final BranchOrderingPolicy branchSelector;

    public TraversalDescriptionImpl() {
        this(StandardExpander.DEFAULT, Uniqueness.NODE_GLOBAL, null, PruneEvaluator.NONE, Traversal.returnAll(), Traversal.preorderDepthFirst());
    }

    private TraversalDescriptionImpl(Expander expander, UniquenessFactory uniqueness, Object uniquenessParameter, PruneEvaluator pruning, Predicate<Path> filter, BranchOrderingPolicy branchSelector) {
        this.expander = expander;
        this.uniqueness = uniqueness;
        this.uniquenessParameter = uniquenessParameter;
        this.pruning = pruning;
        this.filter = filter;
        this.branchSelector = branchSelector;
    }

    @Override
    public Traverser traverse(Node startNode) {
        return new TraverserImpl(this, startNode);
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness) {
        return new TraversalDescriptionImpl(this.expander, uniqueness, null, this.pruning, this.filter, this.branchSelector);
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness, Object parameter) {
        if (this.uniqueness == uniqueness && (this.uniquenessParameter == null ? parameter == null : this.uniquenessParameter.equals(parameter))) {
            return this;
        }
        return new TraversalDescriptionImpl(this.expander, uniqueness, parameter, this.pruning, this.filter, this.branchSelector);
    }

    @Override
    public TraversalDescription prune(PruneEvaluator pruning) {
        if (this.pruning == pruning) {
            return this;
        }
        TraversalDescriptionImpl.nullCheck(pruning, PruneEvaluator.class, "NO_PRUNING");
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, this.addPruneEvaluator(pruning), this.filter, this.branchSelector);
    }

    private PruneEvaluator addPruneEvaluator(PruneEvaluator pruning) {
        if (this.pruning instanceof MultiPruneEvaluator) {
            return ((MultiPruneEvaluator)this.pruning).add(pruning);
        }
        if (this.pruning == PruneEvaluator.NONE) {
            return pruning;
        }
        return new MultiPruneEvaluator(this.pruning, pruning);
    }

    @Override
    public TraversalDescription filter(Predicate<Path> filter) {
        if (this.filter == filter) {
            return this;
        }
        if (filter == null) {
            throw new IllegalArgumentException("Return filter may not be null, use " + Traversal.class.getSimpleName() + ".returnAll() instead.");
        }
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, this.pruning, this.addFilter(filter), this.branchSelector);
    }

    private Predicate<Path> addFilter(Predicate<Path> filter) {
        if (this.filter instanceof MultiFilter) {
            return ((MultiFilter)((Object)this.pruning)).add(filter);
        }
        if (this.filter == Traversal.returnAll()) {
            return filter;
        }
        return new MultiFilter(this.filter, filter);
    }

    private static <T> void nullCheck(T parameter, Class<T> parameterType, String defaultName) {
        if (parameter == null) {
            String typeName = parameterType.getSimpleName();
            throw new IllegalArgumentException(typeName + " may not be null, use " + typeName + "." + defaultName + " instead.");
        }
    }

    @Override
    public TraversalDescription order(BranchOrderingPolicy selector) {
        if (this.branchSelector == selector) {
            return this;
        }
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, this.pruning, this.filter, selector);
    }

    @Override
    public TraversalDescription depthFirst() {
        return this.order(Traversal.preorderDepthFirst());
    }

    @Override
    public TraversalDescription breadthFirst() {
        return this.order(Traversal.preorderBreadthFirst());
    }

    @Override
    public TraversalDescription relationships(RelationshipType type) {
        return this.relationships(type, Direction.BOTH);
    }

    @Override
    public TraversalDescription relationships(RelationshipType type, Direction direction) {
        return this.expand(this.expander.add(type, direction));
    }

    @Override
    public TraversalDescription expand(RelationshipExpander expander) {
        if (expander.equals(this.expander)) {
            return this;
        }
        return new TraversalDescriptionImpl(Traversal.expander(expander), this.uniqueness, this.uniquenessParameter, this.pruning, this.filter, this.branchSelector);
    }
}

