/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.impl.transaction.XidImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxLog {
    private String name = null;
    private FileChannel fileChannel = null;
    private ByteBuffer buffer = null;
    private int recordCount = 0;
    public static final byte TX_START = 1;
    public static final byte BRANCH_ADD = 2;
    public static final byte MARK_COMMIT = 3;
    public static final byte TX_DONE = 4;

    public TxLog(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        this.fileChannel = new RandomAccessFile(fileName, "rw").getChannel();
        this.fileChannel.position(this.fileChannel.size());
        this.buffer = ByteBuffer.allocateDirect(131000);
        this.name = fileName;
    }

    public String getName() {
        return this.name;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }

    public void force() throws IOException {
        this.fileChannel.force(true);
    }

    public synchronized void truncate() throws IOException {
        this.fileChannel.position(0L);
        this.fileChannel.truncate(0L);
        this.recordCount = 0;
    }

    public synchronized void txStart(byte[] globalId) throws IOException {
        if (globalId == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.buffer.clear();
        this.buffer.put((byte)1).put((byte)globalId.length).put(globalId);
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
        ++this.recordCount;
    }

    public synchronized void addBranch(byte[] globalId, byte[] branchId) throws IOException {
        if (globalId == null) {
            throw new IllegalArgumentException("Null global id");
        }
        if (branchId == null) {
            throw new IllegalArgumentException("Null branch id");
        }
        this.buffer.clear();
        this.buffer.put((byte)2).put((byte)globalId.length).put((byte)branchId.length).put(globalId).put(branchId);
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
        ++this.recordCount;
    }

    public synchronized void markAsCommitting(byte[] globalId) throws IOException {
        if (globalId == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.buffer.clear();
        this.buffer.put((byte)3).put((byte)globalId.length).put(globalId);
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
        this.fileChannel.force(false);
        ++this.recordCount;
    }

    public synchronized void txDone(byte[] globalId) throws IOException {
        if (globalId == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.buffer.clear();
        this.buffer.put((byte)4).put((byte)globalId.length).put(globalId);
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
        ++this.recordCount;
    }

    void writeRecord(Record record) throws IOException {
        if (record.getType() == 1) {
            this.txStart(record.getGlobalId());
        } else if (record.getType() == 2) {
            this.addBranch(record.getGlobalId(), record.getBranchId());
        } else if (record.getType() == 3) {
            this.markAsCommitting(record.getGlobalId());
        } else {
            throw new IOException("Illegal record type[" + record.getType() + "]");
        }
    }

    public synchronized Iterator<List<Record>> getDanglingRecords() throws IOException {
        this.fileChannel.position(0L);
        this.buffer.clear();
        this.fileChannel.read(this.buffer);
        this.buffer.flip();
        long nextPosition = 0L;
        int seqNr = 0;
        HashMap recordMap = new HashMap();
        while (this.buffer.hasRemaining()) {
            List<Record> recordList;
            XidImpl xid;
            byte[] globalId;
            byte recordType = this.buffer.get();
            if (recordType == 1) {
                if (!this.buffer.hasRemaining()) break;
                globalId = new byte[this.buffer.get()];
                if (this.buffer.limit() - this.buffer.position() < globalId.length) break;
                this.buffer.get(globalId);
                xid = new XidImpl(globalId, new byte[0]);
                if (recordMap.containsKey(xid)) {
                    throw new IOException("Tx start for same xid[" + xid + "] found twice");
                }
                recordList = new LinkedList<Record>();
                recordList.add(new Record(recordType, globalId, null, seqNr++));
                recordMap.put(xid, recordList);
                nextPosition += (long)(2 + globalId.length);
            } else if (recordType == 2) {
                if (this.buffer.limit() - this.buffer.position() < 2) break;
                globalId = new byte[this.buffer.get()];
                byte[] branchId = new byte[this.buffer.get()];
                if (this.buffer.limit() - this.buffer.position() < globalId.length + branchId.length) break;
                this.buffer.get(globalId);
                this.buffer.get(branchId);
                XidImpl xid2 = new XidImpl(globalId, new byte[0]);
                if (!recordMap.containsKey(xid2)) {
                    throw new IOException("Branch[" + new String(branchId) + "] found for [" + xid2 + "] but no record list found in map");
                }
                ((List)recordMap.get(xid2)).add(new Record(recordType, globalId, branchId, seqNr++));
                nextPosition += (long)(3 + globalId.length + branchId.length);
            } else if (recordType == 3) {
                if (!this.buffer.hasRemaining()) break;
                globalId = new byte[this.buffer.get()];
                if (this.buffer.limit() - this.buffer.position() < globalId.length) break;
                this.buffer.get(globalId);
                xid = new XidImpl(globalId, new byte[0]);
                if (!recordMap.containsKey(xid)) {
                    throw new IOException("Commiting xid[" + xid + "] mark found but no record list found in map");
                }
                recordList = (List)recordMap.get(xid);
                recordList.add(new Record(recordType, globalId, null, seqNr++));
                recordMap.put(xid, recordList);
                nextPosition += (long)(2 + globalId.length);
            } else if (recordType == 4) {
                if (!this.buffer.hasRemaining()) break;
                globalId = new byte[this.buffer.get()];
                if (this.buffer.limit() - this.buffer.position() < globalId.length) break;
                this.buffer.get(globalId);
                xid = new XidImpl(globalId, new byte[0]);
                if (!recordMap.containsKey(xid)) {
                    throw new IOException("Commiting xid[" + xid + "] mark found but no record list found in map");
                }
                recordMap.remove(xid);
                nextPosition += (long)(2 + globalId.length);
            } else {
                if (recordType == 0) continue;
                throw new IOException("Unknown type: " + recordType);
            }
            if (this.buffer.limit() - this.buffer.position() >= 131) continue;
            this.buffer.clear();
            this.fileChannel.position(nextPosition);
            this.fileChannel.read(this.buffer);
            this.buffer.flip();
        }
        return recordMap.values().iterator();
    }

    public synchronized void switchToLogFile(String newFile) throws IOException {
        if (newFile == null) {
            throw new IllegalArgumentException("Null filename");
        }
        this.force();
        Iterator<List<Record>> itr = this.getDanglingRecords();
        this.close();
        ArrayList records = new ArrayList();
        while (itr.hasNext()) {
            records.addAll(itr.next());
        }
        Collections.sort(records, new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                return r1.getSequenceNumber() - r2.getSequenceNumber();
            }
        });
        Iterator recordItr = records.iterator();
        this.fileChannel = new RandomAccessFile(newFile, "rw").getChannel();
        this.fileChannel.position(this.fileChannel.size());
        this.name = newFile;
        this.truncate();
        while (recordItr.hasNext()) {
            Record record = (Record)recordItr.next();
            this.writeRecord(record);
        }
        this.force();
    }

    public static class Record {
        private byte type = 0;
        private byte[] globalId = null;
        private byte[] branchId = null;
        private int seqNr = -1;

        Record(byte type, byte[] globalId, byte[] branchId, int seqNr) {
            if (type < 1 || type > 4) {
                throw new IllegalArgumentException("Illegal type: " + type);
            }
            this.type = type;
            this.globalId = globalId;
            this.branchId = branchId;
            this.seqNr = seqNr;
        }

        public byte getType() {
            return this.type;
        }

        public byte[] getGlobalId() {
            return this.globalId;
        }

        public byte[] getBranchId() {
            return this.branchId;
        }

        public int getSequenceNumber() {
            return this.seqNr;
        }

        public String toString() {
            XidImpl xid = new XidImpl(this.globalId, this.branchId == null ? new byte[]{} : this.branchId);
            return "TxLogRecord[" + this.type + "," + xid + "," + this.seqNr + "]";
        }
    }
}

