/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.channels.FileChannel;
import java.util.LinkedList;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.transaction.LockException;

abstract class LockableWindow
implements PersistenceWindow {
    private OperationType type = null;
    private final FileChannel fileChannel;
    private Thread lockingThread = null;
    private final LinkedList<Thread> waitingThreadList = new LinkedList();
    private int lockCount = 0;
    private int marked = 0;

    public abstract Buffer getBuffer();

    public abstract long position();

    public abstract int size();

    public abstract void force();

    public abstract void close();

    LockableWindow(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    boolean encapsulates(long position) {
        return this.position() <= position && position < this.position() + (long)this.size();
    }

    FileChannel getFileChannel() {
        return this.fileChannel;
    }

    OperationType getOperationType() {
        return this.type;
    }

    void setOperationType(OperationType type) {
        this.type = type;
    }

    synchronized void mark() {
        ++this.marked;
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    synchronized void lock() {
        Thread currentThread = Thread.currentThread();
        while (this.lockCount > 0 && this.lockingThread != currentThread) {
            this.waitingThreadList.addFirst(currentThread);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        ++this.lockCount;
        this.lockingThread = currentThread;
        --this.marked;
    }

    synchronized void unLock() {
        Thread currentThread = Thread.currentThread();
        if (this.lockCount == 0) {
            throw new LockException("" + currentThread + " don't have window lock on " + this);
        }
        --this.lockCount;
        if (this.lockCount == 0) {
            this.lockingThread = null;
            if (this.waitingThreadList.size() > 0) {
                this.waitingThreadList.removeLast().interrupt();
            }
        }
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }
}

