/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.StringLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDynamicStore
extends CommonAbstractStore {
    private int blockSize;
    private static final int BLOCK_HEADER_SIZE = 13;

    protected static void createEmptyStore(String fileName, int baseBlockSize, String typeAndVersionDescriptor, IdGeneratorFactory idGeneratorFactory, IdType idType) {
        int blockSize = baseBlockSize;
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        File file = new File(fileName);
        if (file.exists()) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "]");
        }
        blockSize += 13;
        try {
            FileChannel channel = new FileOutputStream(fileName).getChannel();
            int endHeaderSize = blockSize + typeAndVersionDescriptor.getBytes().length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.putInt(blockSize);
            buffer.position(endHeaderSize - typeAndVersionDescriptor.length());
            buffer.put(typeAndVersionDescriptor.getBytes()).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        idGeneratorFactory.create(fileName + ".id");
        IdGenerator idGenerator = idGeneratorFactory.open(fileName + ".id", 1, idType, 0L);
        idGenerator.nextId();
        idGenerator.close();
    }

    public AbstractDynamicStore(String fileName, Map<?, ?> config, IdType idType) {
        super(fileName, config, idType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadStorage() {
        try {
            long fileSize = this.getFileChannel().size();
            String expectedVersion = this.getTypeAndVersionDescriptor();
            byte[] version = new byte[expectedVersion.getBytes().length];
            ByteBuffer buffer = ByteBuffer.wrap(version);
            this.getFileChannel().position(fileSize - (long)version.length);
            this.getFileChannel().read(buffer);
            buffer = ByteBuffer.allocate(4);
            this.getFileChannel().position(0L);
            this.getFileChannel().read(buffer);
            buffer.flip();
            this.blockSize = buffer.getInt();
            if (this.blockSize <= 0) {
                throw new InvalidRecordException("Illegal block size: " + this.blockSize + " in " + this.getStorageFileName());
            }
            if (!(expectedVersion.equals(new String(version)) || this.versionFound(new String(version)) || this.isReadOnly())) {
                this.setStoreNotOk();
            }
            if ((fileSize - (long)version.length) % (long)this.blockSize != 0L && !this.isReadOnly()) {
                this.setStoreNotOk();
            }
            if (this.getStoreOk() && !this.isReadOnly()) {
                this.getFileChannel().truncate(fileSize - (long)version.length);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load storage " + this.getStorageFileName(), e);
        }
        try {
            if (!this.isReadOnly() || this.isBackupSlave()) {
                this.openIdGenerator();
            } else {
                this.openReadOnlyIdGenerator(this.getBlockSize());
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk();
        }
        finally {
            if (!this.getStoreOk() && this.getConfig() != null) {
                String storeDir = (String)this.getConfig().get("store_dir");
                StringLogger msgLog = StringLogger.getLogger(storeDir + "/messages.log");
                msgLog.logMessage(this.getStorageFileName() + " non clean shutdown detected", true);
            }
        }
        this.setWindowPool(new PersistenceWindowPool(this.getStorageFileName(), this.getBlockSize(), this.getFileChannel(), this.getMappedMem(), this.getIfMemoryMapped(), this.isReadOnly() && !this.isBackupSlave()));
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int nextBlockId() {
        return this.nextId();
    }

    public void freeBlockId(int blockId) {
        this.freeId(blockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(DynamicRecord record) {
        int blockId = record.getId();
        if (this.isInRecoveryMode()) {
            this.registerIdFromUpdateRecord(blockId);
        }
        PersistenceWindow window = this.acquireWindow(blockId, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(blockId);
            if (record.inUse()) {
                assert (record.getId() != record.getPrevBlock());
                buffer.put(Record.IN_USE.byteValue()).putInt(record.getPrevBlock()).putInt(record.getLength()).putInt(record.getNextBlock());
                if (!record.isLight()) {
                    if (!record.isCharData()) {
                        buffer.put(record.getData());
                    } else {
                        buffer.put(record.getDataAsChar());
                    }
                }
            } else {
                buffer.put(Record.NOT_IN_USE.byteValue());
                if (!this.isInRecoveryMode()) {
                    this.freeBlockId(blockId);
                }
            }
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public Collection<DynamicRecord> allocateRecords(int startBlock, byte[] src) {
        assert (this.getFileChannel() != null) : "Store closed, null file channel";
        assert (src != null) : "Null src argument";
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        int nextBlock = startBlock;
        int prevBlock = Record.NO_PREV_BLOCK.intValue();
        int srcOffset = 0;
        int dataSize = this.getBlockSize() - 13;
        do {
            byte[] data;
            DynamicRecord record = new DynamicRecord(nextBlock);
            record.setCreated();
            record.setInUse(true);
            assert (prevBlock != nextBlock);
            record.setPrevBlock(prevBlock);
            if (src.length - srcOffset > dataSize) {
                data = new byte[dataSize];
                System.arraycopy(src, srcOffset, data, 0, dataSize);
                record.setData(data);
                prevBlock = nextBlock;
                nextBlock = this.nextBlockId();
                record.setNextBlock(nextBlock);
                srcOffset += dataSize;
            } else {
                data = new byte[src.length - srcOffset];
                System.arraycopy(src, srcOffset, data, 0, data.length);
                record.setData(data);
                nextBlock = Record.NO_NEXT_BLOCK.intValue();
                record.setNextBlock(nextBlock);
            }
            recordList.add(record);
        } while (nextBlock != Record.NO_NEXT_BLOCK.intValue());
        return recordList;
    }

    public Collection<DynamicRecord> allocateRecords(int startBlock, char[] src) {
        assert (this.getFileChannel() != null) : "Store closed, null file channel";
        assert (src != null) : "Null src argument";
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        int nextBlock = startBlock;
        int prevBlock = Record.NO_PREV_BLOCK.intValue();
        int srcOffset = 0;
        int dataSize = this.getBlockSize() - 13;
        do {
            CharBuffer charBuf;
            byte[] data;
            DynamicRecord record = new DynamicRecord(nextBlock);
            record.setCreated();
            record.setInUse(true);
            assert (prevBlock != nextBlock);
            record.setPrevBlock(prevBlock);
            if ((src.length - srcOffset) * 2 > dataSize) {
                data = new byte[dataSize];
                charBuf = ByteBuffer.wrap(data).asCharBuffer();
                charBuf.put(src, srcOffset, dataSize / 2);
                record.setData(data);
                prevBlock = nextBlock;
                nextBlock = this.nextBlockId();
                record.setNextBlock(nextBlock);
                srcOffset += dataSize / 2;
            } else {
                if (srcOffset == 0) {
                    record.setCharData(src);
                } else {
                    data = new byte[(src.length - srcOffset) * 2];
                    charBuf = ByteBuffer.wrap(data).asCharBuffer();
                    charBuf.put(src, srcOffset, src.length - srcOffset);
                    record.setData(data);
                }
                nextBlock = Record.NO_NEXT_BLOCK.intValue();
                record.setNextBlock(nextBlock);
            }
            recordList.add(record);
        } while (nextBlock != Record.NO_NEXT_BLOCK.intValue());
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DynamicRecord> getLightRecords(int startBlockId) {
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        int blockId = startBlockId;
        while (blockId != Record.NO_NEXT_BLOCK.intValue()) {
            PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
            try {
                DynamicRecord record = this.getLightRecord(blockId, window);
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            finally {
                this.releaseWindow(window);
            }
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeHeavy(DynamicRecord record) {
        int blockId = record.getId();
        PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
        try {
            Buffer buf = window.getBuffer();
            int offset = (int)(((long)blockId & 0xFFFFFFFFL) - buf.position()) * this.getBlockSize() + 13;
            buf.setOffset(offset);
            byte[] bytes = new byte[record.getLength()];
            buf.get(bytes);
            record.setData(bytes);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private DynamicRecord getLightRecord(int blockId, PersistenceWindow window) {
        DynamicRecord record = new DynamicRecord(blockId);
        Buffer buffer = window.getOffsettedBuffer(blockId);
        byte inUse = buffer.get();
        if (inUse != Record.IN_USE.byteValue()) {
            throw new InvalidRecordException("Block not inUse[" + inUse + "] blockId[" + blockId + "]");
        }
        record.setInUse(true);
        int prevBlock = buffer.getInt();
        record.setPrevBlock(prevBlock);
        int dataSize = this.getBlockSize() - 13;
        int nrOfBytes = buffer.getInt();
        int nextBlock = buffer.getInt();
        if (nextBlock != Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
            throw new InvalidRecordException("Next block set[" + nextBlock + "] current block illegal size[" + nrOfBytes + "/" + dataSize + "]");
        }
        record.setLength(nrOfBytes);
        record.setNextBlock(nextBlock);
        record.setIsLight(true);
        return record;
    }

    private DynamicRecord getRecord(int blockId, PersistenceWindow window) {
        DynamicRecord record = new DynamicRecord(blockId);
        Buffer buffer = window.getOffsettedBuffer(blockId);
        byte inUse = buffer.get();
        if (inUse != Record.IN_USE.byteValue()) {
            throw new InvalidRecordException("Not in use [" + inUse + "] blockId[" + blockId + "]");
        }
        record.setInUse(true);
        int prevBlock = buffer.getInt();
        record.setPrevBlock(prevBlock);
        int dataSize = this.getBlockSize() - 13;
        int nrOfBytes = buffer.getInt();
        int nextBlock = buffer.getInt();
        if (nextBlock != Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
            throw new InvalidRecordException("Next block set[" + nextBlock + "] current block illegal size[" + nrOfBytes + "/" + dataSize + "]");
        }
        record.setLength(nrOfBytes);
        record.setNextBlock(nextBlock);
        byte[] byteArrayElement = new byte[nrOfBytes];
        buffer.get(byteArrayElement);
        record.setData(byteArrayElement);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DynamicRecord> getRecords(int startBlockId) {
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        int blockId = startBlockId;
        while (blockId != Record.NO_NEXT_BLOCK.intValue()) {
            PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
            try {
                DynamicRecord record = this.getRecord(blockId, window);
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            finally {
                this.releaseWindow(window);
            }
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] get(int blockId) {
        LinkedList<byte[]> byteArrayList = new LinkedList<byte[]>();
        PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
        try {
            Buffer buffer = window.getOffsettedBuffer(blockId);
            byte inUse = buffer.get();
            if (inUse != Record.IN_USE.byteValue()) {
                throw new InvalidRecordException("Not in use [" + inUse + "] blockId[" + blockId + "]");
            }
            int prevBlock = buffer.getInt();
            if (prevBlock != Record.NO_PREV_BLOCK.intValue()) {
                throw new InvalidRecordException("Start[" + blockId + "] block has previous[" + prevBlock + "] block set");
            }
            int nextBlock = blockId;
            int dataSize = this.getBlockSize() - 13;
            do {
                int nrOfBytes = buffer.getInt();
                prevBlock = nextBlock;
                nextBlock = buffer.getInt();
                if (nextBlock != Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
                    throw new InvalidRecordException("Next block set[" + nextBlock + "] current block illegal size[" + nrOfBytes + "/" + dataSize + "]");
                }
                byte[] byteArrayElement = new byte[nrOfBytes];
                buffer.get(byteArrayElement);
                byteArrayList.add(byteArrayElement);
                if (nextBlock == Record.NO_NEXT_BLOCK.intValue()) continue;
                this.releaseWindow(window);
                window = this.acquireWindow(nextBlock, OperationType.READ);
                buffer = window.getOffsettedBuffer(nextBlock);
                inUse = buffer.get();
                if (inUse != Record.IN_USE.byteValue()) {
                    throw new InvalidRecordException("Next block[" + nextBlock + "] not in use [" + inUse + "]");
                }
                if (buffer.getInt() == prevBlock) continue;
                throw new InvalidRecordException("Previous[" + prevBlock + "] block don't match");
            } while (nextBlock != Record.NO_NEXT_BLOCK.intValue());
        }
        finally {
            this.releaseWindow(window);
        }
        int totalSize = 0;
        Iterator itr = byteArrayList.iterator();
        while (itr.hasNext()) {
            totalSize += ((byte[])itr.next()).length;
        }
        byte[] allBytes = new byte[totalSize];
        itr = byteArrayList.iterator();
        int index = 0;
        while (itr.hasNext()) {
            byte[] currentArray = (byte[])itr.next();
            System.arraycopy(currentArray, 0, allBytes, index, currentArray.length);
            index += currentArray.length;
        }
        return allBytes;
    }

    private int findHighIdBackwards() throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        int recordSize = this.getBlockSize();
        long fileSize = fileChannel.size();
        long highId = fileSize / (long)recordSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        for (long i = highId; i > 0L; --i) {
            fileChannel.position(i * (long)recordSize);
            if (fileChannel.read(byteBuffer) <= 0) continue;
            byteBuffer.flip();
            byte inUse = byteBuffer.get();
            byteBuffer.clear();
            if (inUse == 0) continue;
            return (int)i;
        }
        return 0;
    }

    @Override
    protected void rebuildIdGenerator() {
        if (this.getBlockSize() <= 0) {
            throw new InvalidRecordException("Illegal blockSize: " + this.getBlockSize());
        }
        logger.fine("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        File file = new File(this.getStorageFileName() + ".id");
        if (file.exists()) {
            boolean success = file.delete();
            assert (success);
        }
        this.createIdGenerator(this.getStorageFileName() + ".id");
        this.openIdGenerator();
        this.setHighId(1L);
        FileChannel fileChannel = this.getFileChannel();
        int highId = 0;
        long defraggedCount = 0L;
        try {
            String mode;
            long fileSize = fileChannel.size();
            boolean fullRebuild = true;
            if (this.getConfig() != null && (mode = (String)this.getConfig().get("rebuild_idgenerators_fast")) != null && mode.toLowerCase().equals("true")) {
                fullRebuild = false;
                highId = this.findHighIdBackwards();
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[1]);
            LinkedList<Integer> freeIdList = new LinkedList<Integer>();
            if (fullRebuild) {
                long i = 1L;
                while (i * (long)this.getBlockSize() < fileSize) {
                    fileChannel.position(i * (long)this.getBlockSize());
                    fileChannel.read(byteBuffer);
                    byteBuffer.flip();
                    byte inUse = byteBuffer.get();
                    byteBuffer.flip();
                    this.nextBlockId();
                    if (inUse == Record.NOT_IN_USE.byteValue()) {
                        freeIdList.add((int)i);
                    } else {
                        highId = (int)i;
                        while (!freeIdList.isEmpty()) {
                            this.freeBlockId((Integer)freeIdList.removeFirst());
                            ++defraggedCount;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId + 1);
        logger.fine("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        if (this.getConfig() != null) {
            String storeDir = (String)this.getConfig().get("store_dir");
            StringLogger msgLog = StringLogger.getLogger(storeDir + "/messages.log");
            msgLog.logMessage(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount, true);
        }
        this.closeIdGenerator();
        this.openIdGenerator();
    }

    @Override
    protected long figureOutHighestIdInUse() {
        try {
            return this.getFileChannel().size() / (long)this.getBlockSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

