/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexConnectionBroker<T extends XaConnection> {
    private final ArrayMap<Transaction, T> txConnectionMap = new ArrayMap(5, true, true);
    private final TransactionManager transactionManager;

    protected IndexConnectionBroker(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public T acquireResourceConnection() {
        XaConnection con = null;
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        con = (XaConnection)this.txConnectionMap.get(tx);
        if (con == null) {
            try {
                con = this.newConnection();
                if (!tx.enlistResource(con.getXaResource())) {
                    throw new RuntimeException("Unable to enlist '" + con.getXaResource() + "' in " + tx);
                }
                tx.registerSynchronization((Synchronization)new TxCommitHook(tx));
                this.txConnectionMap.put(tx, con);
            }
            catch (RollbackException re) {
                String msg = "The transaction is marked for rollback only.";
                throw new RuntimeException(msg, re);
            }
            catch (SystemException se) {
                String msg = "TM encountered an unexpected error condition.";
                throw new RuntimeException(msg, se);
            }
        }
        return (T)con;
    }

    protected abstract T newConnection();

    public T acquireReadOnlyResourceConnection() {
        Transaction tx = this.getCurrentTransaction();
        return (T)(tx != null ? (XaConnection)this.txConnectionMap.get(tx) : null);
    }

    void releaseResourceConnectionsForTransaction(Transaction tx) throws NotInTransactionException {
        XaConnection con = (XaConnection)this.txConnectionMap.remove(tx);
        if (con != null) {
            con.destroy();
        }
    }

    void delistResourcesForTransaction() throws NotInTransactionException {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        XaConnection con = (XaConnection)this.txConnectionMap.get(tx);
        if (con != null) {
            try {
                tx.delistResource(con.getXaResource(), 0x4000000);
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Unable to delist lucene resource from tx", e);
            }
            catch (SystemException e) {
                throw new RuntimeException("Unable to delist lucene resource from tx", e);
            }
        }
    }

    private Transaction getCurrentTransaction() throws NotInTransactionException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException se) {
            throw new NotInTransactionException("Error fetching transaction for current thread", se);
        }
    }

    private class TxCommitHook
    implements Synchronization {
        private final Transaction tx;

        TxCommitHook(Transaction tx) {
            this.tx = tx;
        }

        public void afterCompletion(int param) {
            IndexConnectionBroker.this.releaseResourceConnectionsForTransaction(this.tx);
        }

        public void beforeCompletion() {
            IndexConnectionBroker.this.delistResourcesForTransaction();
        }
    }
}

