/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class StringLogger {
    private final PrintWriter out;
    private static final Map<String, StringLogger> loggers = new HashMap<String, StringLogger>();

    private StringLogger(String filename) {
        try {
            File file = new File(filename);
            file.getParentFile().mkdirs();
            this.out = new PrintWriter(new FileWriter(file, true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private StringLogger(PrintWriter writer) {
        this.out = writer;
    }

    public static StringLogger getLogger(String filename) {
        StringLogger logger = loggers.get(filename);
        if (logger == null) {
            logger = filename == null || filename.startsWith("null") ? new StringLogger(new PrintWriter(System.out)) : new StringLogger(filename);
            loggers.put(filename, logger);
        }
        return logger;
    }

    public synchronized void logMessage(String msg) {
        this.out.println(new Date() + ": " + msg);
        this.out.flush();
    }

    public synchronized void logMessage(String msg, Throwable cause) {
        this.out.println(new Date() + ": " + msg + " " + cause.getMessage());
        cause.printStackTrace(this.out);
        this.out.flush();
    }

    public static synchronized void close(String filename) {
        StringLogger logger = loggers.remove(filename);
        if (logger != null) {
            logger.out.close();
        }
    }
}

