/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.transaction.TransactionImpl;
import org.neo4j.kernel.impl.transaction.TxFinishHook;
import org.neo4j.kernel.impl.transaction.TxLog;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResource;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxManager
implements TransactionManager {
    private static Logger log = Logger.getLogger(TxManager.class.getName());
    private ArrayMap<Thread, TransactionImpl> txThreadMap;
    private final String txLogDir;
    private String separator = "/";
    private String logSwitcherFileName = "active_tx_log";
    private String txLog1FileName = "tm_tx_log.1";
    private String txLog2FileName = "tm_tx_log.2";
    private int maxTxLogRecordCount = 1000;
    private int eventIdentifierCounter = 0;
    private TxLog txLog = null;
    private XaDataSourceManager xaDsManager = null;
    private boolean tmOk = false;
    private final KernelPanicEventGenerator kpe;
    private final AtomicInteger startedTxCount = new AtomicInteger(0);
    private final AtomicInteger comittedTxCount = new AtomicInteger(0);
    private final AtomicInteger rolledBackTxCount = new AtomicInteger(0);
    private int peakConcurrentTransactions = 0;
    private final StringLogger msgLog;
    final TxFinishHook finishHook;

    TxManager(String txLogDir, KernelPanicEventGenerator kpe, TxFinishHook finishHook) {
        this.txLogDir = txLogDir;
        this.msgLog = StringLogger.getLogger(txLogDir + "/messages.log");
        this.kpe = kpe;
        this.finishHook = finishHook;
    }

    synchronized int getNextEventIdentifier() {
        return this.eventIdentifierCounter++;
    }

    void stop() {
        if (this.txLog != null) {
            try {
                this.txLog.close();
            }
            catch (IOException e) {
                log.warning("Unable to close tx log[" + this.txLog.getName() + "]" + ", " + e);
            }
        }
        this.msgLog.logMessage("TM shutting down");
        StringLogger.close(this.txLogDir + "/messages.log");
    }

    void init(XaDataSourceManager xaDsManagerToUse) {
        this.xaDsManager = xaDsManagerToUse;
        this.txThreadMap = new ArrayMap(5, true, true);
        this.separator = System.getProperty("file.separator");
        this.logSwitcherFileName = this.txLogDir + this.separator + "active_tx_log";
        this.txLog1FileName = "tm_tx_log.1";
        this.txLog2FileName = "tm_tx_log.2";
        try {
            if (new File(this.logSwitcherFileName).exists()) {
                FileChannel fc = new RandomAccessFile(this.logSwitcherFileName, "rw").getChannel();
                byte[] fileName = new byte[256];
                ByteBuffer buf = ByteBuffer.wrap(fileName);
                fc.read(buf);
                fc.close();
                String currentTxLog = this.txLogDir + this.separator + new String(fileName).trim();
                if (!new File(currentTxLog).exists()) {
                    throw new TransactionFailureException("Unable to start TM, active tx log file[" + currentTxLog + "] not found.");
                }
                this.txLog = new TxLog(currentTxLog);
                this.msgLog.logMessage("TM opening log: " + currentTxLog);
            } else {
                if (new File(this.txLogDir + this.separator + this.txLog1FileName).exists() || new File(this.txLogDir + this.separator + this.txLog2FileName).exists()) {
                    throw new TransactionFailureException("Unable to start TM, no active tx log file found but found either " + this.txLog1FileName + " or " + this.txLog2FileName + " file, please set one of them as active or " + "remove them.");
                }
                ByteBuffer buf = ByteBuffer.wrap(this.txLog1FileName.getBytes("UTF-8"));
                FileChannel fc = new RandomAccessFile(this.logSwitcherFileName, "rw").getChannel();
                fc.write(buf);
                this.txLog = new TxLog(this.txLogDir + this.separator + this.txLog1FileName);
                this.msgLog.logMessage("TM new log: " + this.txLog1FileName);
                fc.force(true);
                fc.close();
            }
            Iterator<List<TxLog.Record>> danglingRecordList = this.txLog.getDanglingRecords();
            if (danglingRecordList.hasNext()) {
                log.info("Unresolved transactions found, recovery started ...");
                this.recover(danglingRecordList);
                log.info("Recovery completed, all transactions have been resolved to a consistent state.");
            }
            this.getTxLog().truncate();
            this.tmOk = true;
        }
        catch (IOException e) {
            log.severe("Unable to start TM");
            throw new TransactionFailureException("Unable to start TM", e);
        }
    }

    synchronized TxLog getTxLog() throws IOException {
        if (this.txLog.getRecordCount() > this.maxTxLogRecordCount) {
            if (this.txLog.getName().endsWith(this.txLog1FileName)) {
                this.txLog.switchToLogFile(this.txLogDir + this.separator + this.txLog2FileName);
                this.changeActiveLog(this.txLog2FileName);
            } else if (this.txLog.getName().endsWith(this.txLog2FileName)) {
                this.txLog.switchToLogFile(this.txLogDir + this.separator + this.txLog1FileName);
                this.changeActiveLog(this.txLog1FileName);
            } else {
                this.setTmNotOk();
                log.severe("Unknown active tx log file[" + this.txLog.getName() + "], unable to switch.");
                throw new IOException("Unknown txLogFile[" + this.txLog.getName() + "] not equals to either [" + this.txLog1FileName + "] or [" + this.txLog2FileName + "]");
            }
        }
        return this.txLog;
    }

    private void changeActiveLog(String newFileName) throws IOException {
        FileChannel fc = new RandomAccessFile(this.logSwitcherFileName, "rw").getChannel();
        ByteBuffer buf = ByteBuffer.wrap(newFileName.getBytes());
        fc.truncate(0L);
        fc.write(buf);
        fc.force(true);
        fc.close();
    }

    void setTmNotOk() {
        this.tmOk = false;
        this.kpe.generateEvent(null);
    }

    private void recover(Iterator<List<TxLog.Record>> danglingRecordList) {
        this.msgLog.logMessage("TM non resolved transactions found in " + this.txLog.getName());
        try {
            ArrayList<NonCompletedTransaction> commitList = new ArrayList<NonCompletedTransaction>();
            LinkedList<Xid> rollbackList = new LinkedList<Xid>();
            HashMap<Resource, XAResource> resourceMap = new HashMap<Resource, XAResource>();
            this.buildRecoveryInfo(commitList, rollbackList, resourceMap, danglingRecordList);
            Iterator resourceItr = resourceMap.keySet().iterator();
            LinkedList<Xid> recoveredXidsList = new LinkedList<Xid>();
            while (resourceItr.hasNext()) {
                XAResource xaRes = (XAResource)resourceMap.get(resourceItr.next());
                Xid[] xids = xaRes.recover(0);
                for (int i = 0; i < xids.length; ++i) {
                    if (XidImpl.isThisTm(xids[i].getGlobalTransactionId())) {
                        if (rollbackList.contains(xids[i])) {
                            log.fine("Found pre commit " + xids[i] + " rolling back ... ");
                            this.msgLog.logMessage("TM: Found pre commit " + xids[i] + " rolling back ... ");
                            rollbackList.remove(xids[i]);
                            xaRes.rollback(xids[i]);
                            continue;
                        }
                        recoveredXidsList.add(xids[i]);
                        continue;
                    }
                    log.warning("Unknown xid: " + xids[i]);
                }
            }
            Collections.sort(commitList, new Comparator<NonCompletedTransaction>(){

                @Override
                public int compare(NonCompletedTransaction r1, NonCompletedTransaction r2) {
                    return r1.getSequenceNumber() - r2.getSequenceNumber();
                }
            });
            for (NonCompletedTransaction nct : commitList) {
                int seq = nct.getSequenceNumber();
                Xid[] xids = nct.getXids();
                log.fine("Marked as commit tx-seq[" + seq + "] branch length: " + xids.length);
                for (int i = 0; i < xids.length; ++i) {
                    if (!recoveredXidsList.contains(xids[i])) {
                        log.fine("Tx-seq[" + seq + "][" + xids[i] + "] not found in recovered xid list, " + "assuming already committed");
                        continue;
                    }
                    recoveredXidsList.remove(xids[i]);
                    Resource resource = new Resource(xids[i].getBranchQualifier());
                    if (!resourceMap.containsKey(resource)) {
                        throw new TransactionFailureException("Couldn't find XAResource for " + xids[i]);
                    }
                    log.fine("Commiting tx seq[" + seq + "][" + xids[i] + "] ... ");
                    this.msgLog.logMessage("TM: Committing tx " + xids[i]);
                    ((XAResource)resourceMap.get(resource)).commit(xids[i], false);
                }
            }
            for (Xid xid : recoveredXidsList) {
                Resource resource = new Resource(xid.getBranchQualifier());
                if (!resourceMap.containsKey(resource)) {
                    throw new TransactionFailureException("Couldn't find XAResource for " + xid);
                }
                log.fine("Rollback " + xid + " ... ");
                this.msgLog.logMessage("TM: no match found for " + xid + " removing");
                ((XAResource)resourceMap.get(resource)).rollback(xid);
            }
            if (rollbackList.size() > 0) {
                log.fine("TxLog contained unresolved xids that needed rollback. They couldn't be matched to any of the XAResources recover list. Assuming " + rollbackList.size() + " transactions already rolled back.");
                this.msgLog.logMessage("TM: no match found for in total " + rollbackList.size() + " transaction that should have been rolled back");
            }
        }
        catch (XAException e) {
            throw new TransactionFailureException("Recovery failed." + e);
        }
    }

    private void buildRecoveryInfo(List<NonCompletedTransaction> commitList, List<Xid> rollbackList, Map<Resource, XAResource> resourceMap, Iterator<List<TxLog.Record>> danglingRecordList) {
        while (danglingRecordList.hasNext()) {
            Iterator<TxLog.Record> dListItr = danglingRecordList.next().iterator();
            TxLog.Record startRecord = dListItr.next();
            if (startRecord.getType() != 1) {
                throw new TransactionFailureException("First record not a start record, type=" + startRecord.getType());
            }
            HashSet<Resource> branchSet = new HashSet<Resource>();
            int markedCommit = -1;
            while (dListItr.hasNext()) {
                TxLog.Record record = dListItr.next();
                if (record.getType() == 2) {
                    if (markedCommit != -1) {
                        throw new TransactionFailureException("Already marked commit " + startRecord);
                    }
                    branchSet.add(new Resource(record.getBranchId()));
                    continue;
                }
                if (record.getType() == 3) {
                    if (markedCommit != -1) {
                        throw new TransactionFailureException("Already marked commit " + startRecord);
                    }
                    markedCommit = record.getSequenceNumber();
                    continue;
                }
                throw new TransactionFailureException("Illegal record type[" + record.getType() + "]");
            }
            Iterator resourceItr = branchSet.iterator();
            LinkedList<Xid> xids = new LinkedList<Xid>();
            while (resourceItr.hasNext()) {
                Resource resource = (Resource)resourceItr.next();
                if (!resourceMap.containsKey(resource)) {
                    resourceMap.put(resource, this.getXaResource(resource.getResourceId()));
                }
                xids.add(new XidImpl(startRecord.getGlobalId(), resource.getResourceId()));
            }
            if (markedCommit != -1) {
                commitList.add(new NonCompletedTransaction(markedCommit, xids));
                continue;
            }
            rollbackList.addAll(xids);
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            throw new NotSupportedException("Nested transactions not supported");
        }
        tx = new TransactionImpl(this);
        this.txThreadMap.put(thread, tx);
        int concurrentTxCount = this.txThreadMap.size();
        if (concurrentTxCount > this.peakConcurrentTransactions) {
            this.peakConcurrentTransactions = concurrentTxCount;
        }
        this.startedTxCount.incrementAndGet();
    }

    void writeStartRecord(byte[] globalId) throws SystemException {
        try {
            this.getTxLog().txStart(globalId);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.severe("Error writing transaction log");
            this.setTmNotOk();
            throw new SystemException("TM encountered a problem,  error writing transaction log," + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        boolean hasAnyLocks = false;
        try {
            hasAnyLocks = this.finishHook.hasAnyLocks(tx);
            if (tx.getStatus() != 0 && tx.getStatus() != 1) {
                throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
            }
            tx.doBeforeCompletion();
            if (tx.getStatus() == 0) {
                this.comittedTxCount.incrementAndGet();
                this.commit(thread, tx);
            } else if (tx.getStatus() == 1) {
                this.rolledBackTxCount.incrementAndGet();
                this.rollbackCommit(thread, tx);
            } else {
                throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
            }
            Object var5_4 = null;
            if (hasAnyLocks) {
                this.finishHook.finishTransaction(tx.getEventIdentifier());
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (hasAnyLocks) {
                this.finishHook.finishTransaction(tx.getEventIdentifier());
            }
            throw throwable;
        }
    }

    private void commit(Thread thread, TransactionImpl tx) throws SystemException, HeuristicMixedException, HeuristicRollbackException {
        Throwable commitFailureCause = null;
        int xaErrorCode = -1;
        if (tx.getResourceCount() == 0) {
            tx.setStatus(3);
        } else {
            try {
                tx.doCommit();
            }
            catch (XAException e) {
                xaErrorCode = e.errorCode;
                e.printStackTrace();
                log.severe("Commit failed, status=" + this.getTxStatusAsString(tx.getStatus()) + ", errorCode=" + xaErrorCode);
                if (tx.getStatus() == 3) {
                    this.setTmNotOk();
                    throw new TransactionFailureException("commit threw exception but status is committed?", e);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                commitFailureCause = t;
            }
        }
        if (tx.getStatus() != 3) {
            try {
                tx.doRollback();
            }
            catch (XAException e) {
                e.printStackTrace();
                log.severe("Unable to rollback transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->");
                this.setTmNotOk();
                if (commitFailureCause != null) {
                    commitFailureCause.printStackTrace();
                }
                throw new HeuristicMixedException("Unable to rollback ---> error code in commit: " + xaErrorCode + " ---> error code for rollback: " + e.errorCode);
            }
            tx.doAfterCompletion();
            this.txThreadMap.remove(thread);
            try {
                if (tx.isGlobalStartRecordWritten()) {
                    this.getTxLog().txDone(tx.getGlobalId());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.severe("Error writing transaction log");
                this.setTmNotOk();
                throw new SystemException("TM encountered a problem,  error writing transaction log," + e);
            }
            tx.setStatus(6);
            if (commitFailureCause == null) {
                throw new HeuristicRollbackException("Failed to commit, transaction rolledback ---> error code was: " + xaErrorCode);
            }
            throw new HeuristicRollbackException("Failed to commit, transaction rolledback ---> " + commitFailureCause);
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        try {
            if (tx.isGlobalStartRecordWritten()) {
                this.getTxLog().txDone(tx.getGlobalId());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.severe("Error writing transaction log");
            this.setTmNotOk();
            throw new SystemException("TM encountered a problem,  error writing transaction log," + e);
        }
        tx.setStatus(6);
    }

    private void rollbackCommit(Thread thread, TransactionImpl tx) throws HeuristicMixedException, RollbackException, SystemException {
        try {
            tx.doRollback();
        }
        catch (XAException e) {
            e.printStackTrace();
            log.severe("Unable to rollback marked transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->");
            this.setTmNotOk();
            throw new HeuristicMixedException("Unable to rollback  ---> error code for rollback: " + e.errorCode);
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        try {
            if (tx.isGlobalStartRecordWritten()) {
                this.getTxLog().txDone(tx.getGlobalId());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.severe("Error writing transaction log");
            this.setTmNotOk();
            throw new SystemException("TM encountered a problem,  error writing transaction log," + e);
        }
        tx.setStatus(6);
        throw new RollbackException("Failed to commit, transaction rolledback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws IllegalStateException, SystemException {
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        boolean hasAnyLocks = false;
        try {
            hasAnyLocks = this.finishHook.hasAnyLocks(tx);
            if (tx.getStatus() != 0 && tx.getStatus() != 1) {
                if (tx.getStatus() != 7) throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
            }
            tx.setStatus(1);
            tx.doBeforeCompletion();
            try {
                this.rolledBackTxCount.incrementAndGet();
                tx.doRollback();
            }
            catch (XAException e) {
                e.printStackTrace();
                log.severe("Unable to rollback marked or active transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->");
                this.setTmNotOk();
                throw new SystemException("Unable to rollback  ---> error code for rollback: " + e.errorCode);
            }
            tx.doAfterCompletion();
            this.txThreadMap.remove(thread);
            try {
                if (tx.isGlobalStartRecordWritten()) {
                    this.getTxLog().txDone(tx.getGlobalId());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.severe("Error writing transaction log");
                this.setTmNotOk();
                throw new SystemException("TM encountered a problem,  error writing transaction log," + e);
            }
            tx.setStatus(6);
            Object var6_6 = null;
            if (!hasAnyLocks) return;
            this.finishHook.finishTransaction(tx.getEventIdentifier());
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!hasAnyLocks) throw throwable;
            this.finishHook.finishTransaction(tx.getEventIdentifier());
            throw throwable;
        }
    }

    public int getStatus() {
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.txThreadMap.get(Thread.currentThread());
    }

    public void resume(Transaction tx) throws IllegalStateException, SystemException {
        TransactionImpl txImpl;
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
        Thread thread = Thread.currentThread();
        if (this.txThreadMap.get(thread) != null) {
            throw new IllegalStateException("Transaction already associated");
        }
        if (tx != null && (txImpl = (TransactionImpl)tx).getStatus() != 6) {
            txImpl.markAsActive();
            this.txThreadMap.put(thread, txImpl);
        }
    }

    public Transaction suspend() throws SystemException {
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
        TransactionImpl tx = this.txThreadMap.remove(Thread.currentThread());
        if (tx != null) {
            tx.markAsSuspended();
        }
        return tx;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
    }

    byte[] getBranchId(XAResource xaRes) {
        byte[] branchId;
        if (xaRes instanceof XaResource && (branchId = ((XaResource)xaRes).getBranchId()) != null) {
            return branchId;
        }
        return this.xaDsManager.getBranchId(xaRes);
    }

    XAResource getXaResource(byte[] branchId) {
        return this.xaDsManager.getXaResource(branchId);
    }

    String getTxStatusAsString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    public synchronized void dumpTransactions() {
        Iterator<TransactionImpl> itr = this.txThreadMap.values().iterator();
        if (!itr.hasNext()) {
            System.out.println("No uncompleted transactions");
            return;
        }
        System.out.println("Uncompleted transactions found: ");
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public int getEventIdentifier() {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        if (tx != null) {
            return tx.getEventIdentifier();
        }
        return -1;
    }

    public int getStartedTxCount() {
        return this.startedTxCount.get();
    }

    public int getCommittedTxCount() {
        return this.comittedTxCount.get();
    }

    public int getRolledbackTxCount() {
        return this.rolledBackTxCount.get();
    }

    public int getActiveTxCount() {
        return this.txThreadMap.size();
    }

    public int getPeakConcurrentTxCount() {
        return this.peakConcurrentTransactions;
    }

    private static class Resource {
        private byte[] resourceId = null;
        private volatile int hashCode = 0;

        Resource(byte[] resourceId) {
            if (resourceId == null || resourceId.length == 0) {
                throw new IllegalArgumentException("Illegal resourceId");
            }
            this.resourceId = resourceId;
        }

        byte[] getResourceId() {
            return this.resourceId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Resource)) {
                return false;
            }
            byte[] otherResourceId = ((Resource)o).getResourceId();
            if (this.resourceId.length != otherResourceId.length) {
                return false;
            }
            for (int i = 0; i < this.resourceId.length; ++i) {
                if (this.resourceId[i] == otherResourceId[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int calcHash = 0;
                for (int i = 0; i < this.resourceId.length; ++i) {
                    calcHash += this.resourceId[i] << i * 8;
                }
                this.hashCode = 3217 * calcHash;
            }
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonCompletedTransaction {
        private int seqNr = -1;
        private List<Xid> xidList = null;

        NonCompletedTransaction(int seqNr, List<Xid> xidList) {
            this.seqNr = seqNr;
            this.xidList = xidList;
        }

        int getSequenceNumber() {
            return this.seqNr;
        }

        Xid[] getXids() {
            return this.xidList.toArray(new XidImpl[this.xidList.size()]);
        }
    }
}

