/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.osgi;

import java.util.Vector;
import org.neo4j.helpers.ExtensionLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiExtensionLoader
implements ExtensionLoader {
    private BundleContext bc;

    public OSGiExtensionLoader(BundleContext bc) {
        this.bc = bc;
    }

    @Override
    public <T> Iterable<T> loadExtensionsOfType(Class<T> type) {
        try {
            System.out.println("Kernel: attempting to load extensions of type " + type.getName());
            ServiceReference[] services = this.bc.getServiceReferences(type.getName(), null);
            if (services != null) {
                Vector<Object> serviceCollection = new Vector<Object>();
                for (ServiceReference sr : services) {
                    serviceCollection.add(this.bc.getService(sr));
                }
                return serviceCollection;
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            System.out.println("Failed to load extensions of type: " + type);
            e.printStackTrace();
            return null;
        }
    }
}

