/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTypeStore
extends AbstractStore
implements Store {
    private static final String VERSION = "RelationshipTypeStore v0.9.5";
    private static final int RECORD_SIZE = 5;
    private static final int TYPE_STORE_BLOCK_SIZE = 30;
    private DynamicStringStore typeNameStore;

    public RelationshipTypeStore(String fileName, Map<?, ?> config, IdType idType) {
        super(fileName, config, idType);
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
        this.typeNameStore.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        super.unsetRecovered();
        this.typeNameStore.unsetRecovered();
    }

    @Override
    protected void initStorage() {
        this.typeNameStore = new DynamicStringStore(this.getStorageFileName() + ".names", this.getConfig(), IdType.RELATIONSHIP_TYPE_BLOCK);
    }

    @Override
    protected void closeStorage() {
        this.typeNameStore.close();
        this.typeNameStore = null;
    }

    @Override
    public void flushAll() {
        this.typeNameStore.flushAll();
        super.flushAll();
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    public static void createStore(String fileName, Map<?, ?> config) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        RelationshipTypeStore.createEmptyStore(fileName, VERSION, idGeneratorFactory);
        DynamicStringStore.createStore(fileName + ".names", 30, idGeneratorFactory, IdType.RELATIONSHIP_TYPE_BLOCK);
        RelationshipTypeStore store = new RelationshipTypeStore(fileName, config, IdType.RELATIONSHIP_TYPE);
        store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsReserved(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.WRITE);
        try {
            this.markAsReserved(id, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public Collection<DynamicRecord> allocateTypeNameRecords(int startBlock, char[] src) {
        return this.typeNameStore.allocateRecords(startBlock, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipTypeRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipTypeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
        for (DynamicRecord typeRecord : record.getTypeRecords()) {
            this.typeNameStore.updateRecord(typeRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipTypeRecord getRecord(int id) {
        RelationshipTypeRecord record;
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            record = this.getRecord(id, window);
        }
        finally {
            this.releaseWindow(window);
        }
        if (record != null) {
            Collection<DynamicRecord> nameRecords = this.typeNameStore.getRecords(record.getTypeBlock());
            for (DynamicRecord nameRecord : nameRecords) {
                record.addTypeRecord(nameRecord);
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipTypeData getRelationshipType(int id, boolean recovered) {
        assert (recovered);
        try {
            this.setRecovered();
            RelationshipTypeRecord record = this.getRecord(id);
            String name = this.getStringFor(record);
            RelationshipTypeData relationshipTypeData = new RelationshipTypeData(id, name);
            return relationshipTypeData;
        }
        finally {
            this.unsetRecovered();
        }
    }

    public RelationshipTypeData getRelationshipType(int id) {
        RelationshipTypeRecord record = this.getRecord(id);
        String name = this.getStringFor(record);
        return new RelationshipTypeData(id, name);
    }

    public RelationshipTypeData[] getRelationshipTypes() {
        LinkedList<RelationshipTypeData> typeDataList = new LinkedList<RelationshipTypeData>();
        int i = 0;
        while (true) {
            RelationshipTypeRecord record;
            try {
                record = this.getRecord(i);
            }
            catch (InvalidRecordException e) {
                break;
            }
            if (record != null && record.getTypeBlock() != Record.RESERVED.intValue()) {
                String name = this.getStringFor(record);
                typeDataList.add(new RelationshipTypeData(i, name));
            }
            ++i;
        }
        return typeDataList.toArray(new RelationshipTypeData[typeDataList.size()]);
    }

    public int nextBlockId() {
        return this.typeNameStore.nextBlockId();
    }

    public void freeBlockId(int id) {
        this.typeNameStore.freeBlockId(id);
    }

    private void markAsReserved(int id, PersistenceWindow window) {
        Buffer buffer = window.getOffsettedBuffer(id);
        buffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
    }

    private RelationshipTypeRecord getRecord(int id, PersistenceWindow window) {
        Buffer buffer = window.getOffsettedBuffer(id);
        byte inUse = buffer.get();
        if (inUse == Record.NOT_IN_USE.byteValue()) {
            return null;
        }
        if (inUse != Record.IN_USE.byteValue()) {
            throw new InvalidRecordException("Record[" + id + "] unknown in use flag[" + inUse + "]");
        }
        RelationshipTypeRecord record = new RelationshipTypeRecord(id);
        record.setInUse(true);
        record.setTypeBlock(buffer.getInt());
        return record;
    }

    private void updateRecord(RelationshipTypeRecord record, PersistenceWindow window) {
        int id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            buffer.put(Record.IN_USE.byteValue()).putInt(record.getTypeBlock());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue()).putInt(0);
        }
    }

    @Override
    protected void rebuildIdGenerator() {
        logger.fine("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        File file = new File(this.getStorageFileName() + ".id");
        if (file.exists()) {
            boolean success = file.delete();
            assert (success);
        }
        this.createIdGenerator(this.getStorageFileName() + ".id");
        this.openIdGenerator();
        FileChannel fileChannel = this.getFileChannel();
        long highId = -1L;
        int recordSize = this.getRecordSize();
        try {
            long fileSize = fileChannel.size();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[recordSize]);
            int i = 0;
            while ((long)(i * recordSize) < fileSize) {
                fileChannel.read(byteBuffer, i * recordSize);
                byteBuffer.flip();
                byte inUse = byteBuffer.get();
                byteBuffer.flip();
                if (inUse != Record.IN_USE.byteValue()) {
                    byteBuffer.clear();
                    byteBuffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
                    byteBuffer.flip();
                    fileChannel.write(byteBuffer, i * recordSize);
                    byteBuffer.clear();
                } else {
                    highId = i;
                }
                ++i;
            }
            fileChannel.truncate(++highId * (long)recordSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId);
        logger.fine("[" + this.getStorageFileName() + "] high id=" + this.getHighId());
        this.closeIdGenerator();
        this.openIdGenerator();
    }

    public String getStringFor(RelationshipTypeRecord relTypeRecord) {
        int recordToFind = relTypeRecord.getTypeBlock();
        Iterator<DynamicRecord> records = relTypeRecord.getTypeRecords().iterator();
        LinkedList<char[]> charList = new LinkedList<char[]>();
        int totalSize = 0;
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (!record.inUse() || record.getId() != recordToFind) continue;
            if (record.isLight()) {
                this.typeNameStore.makeHeavy(record);
            }
            if (!record.isCharData()) {
                ByteBuffer buf = ByteBuffer.wrap(record.getData());
                char[] chars = new char[record.getData().length / 2];
                totalSize += chars.length;
                buf.asCharBuffer().get(chars);
                charList.add(chars);
            } else {
                charList.add(record.getDataAsChar());
            }
            recordToFind = record.getNextBlock();
            records = relTypeRecord.getTypeRecords().iterator();
        }
        StringBuffer buf = new StringBuffer();
        for (char[] str : charList) {
            buf.append(str);
        }
        return buf.toString();
    }

    @Override
    public void makeStoreOk() {
        this.typeNameStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.typeNameStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.typeNameStore.updateHighId();
        this.updateHighId();
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("RelationshipTypeStore")) {
            return false;
        }
        if (version.equals("RelationshipTypeStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.typeNameStore.getWindowPoolStats());
        list.add(this.getWindowPoolStats());
        return list;
    }
}

