/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.management;

import java.io.File;
import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.impl.management.Description;
import org.neo4j.kernel.impl.management.Neo4jMBean;
import org.neo4j.kernel.management.StoreFile;

@Description(value="Information about the sizes of the different parts of the Neo4j graph store")
class StoreFileBean
extends Neo4jMBean
implements StoreFile {
    private static final String NODE_STORE = "neostore.nodestore.db";
    private static final String RELATIONSHIP_STORE = "neostore.relationshipstore.db";
    private static final String PROPERTY_STORE = "neostore.propertystore.db";
    private static final String ARRAY_STORE = "neostore.propertystore.db.arrays";
    private static final String STRING_STORE = "neostore.propertystore.db.strings";
    private static final String LOGICAL_LOG1 = "nioneo_logical.log.1";
    private static final String LOGICAL_LOG2 = "nioneo_logical.log.2";
    private final File storePath;

    StoreFileBean(String instanceId, File storePath) throws NotCompliantMBeanException {
        super(instanceId, StoreFile.class);
        this.storePath = storePath;
    }

    @Description(value="The total disk space used by this Neo4j instance")
    public long getTotalStoreSize() {
        return StoreFileBean.sizeOf(this.storePath);
    }

    @Description(value="The amount of disk space used by the current Neo4j logical log")
    public long getLogicalLogSize() {
        File logicalLog = new File(this.storePath, LOGICAL_LOG1);
        if (!logicalLog.isFile()) {
            logicalLog = new File(this.storePath, LOGICAL_LOG2);
        }
        return StoreFileBean.sizeOf(logicalLog);
    }

    private static long sizeOf(File file) {
        if (file.isFile()) {
            return file.length();
        }
        if (file.isDirectory()) {
            long size = 0L;
            for (File child : file.listFiles()) {
                size += StoreFileBean.sizeOf(child);
            }
            return size;
        }
        return 0L;
    }

    private long sizeOf(String name) {
        return StoreFileBean.sizeOf(new File(this.storePath, name));
    }

    @Description(value="The amount of disk space used to store array properties")
    public long getArrayStoreSize() {
        return this.sizeOf(ARRAY_STORE);
    }

    @Description(value="The amount of disk space used to store nodes")
    public long getNodeStoreSize() {
        return this.sizeOf(NODE_STORE);
    }

    @Description(value="The amount of disk space used to store properties (excluding string values and array values)")
    public long getPropertyStoreSize() {
        return this.sizeOf(PROPERTY_STORE);
    }

    @Description(value="The amount of disk space used to store relationships")
    public long getRelationshipStoreSize() {
        return this.sizeOf(RELATIONSHIP_STORE);
    }

    @Description(value="The amount of disk space used to store string properties")
    public long getStringStoreSize() {
        return this.sizeOf(STRING_STORE);
    }
}

