/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.management;

import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.management.Neo4jMBean;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmxExtension
extends KernelExtension {
    public JmxExtension() {
        super("kernel jmx");
    }

    @Override
    protected void load(final KernelExtension.KernelData kernel) {
        final NodeManager nodeManager = kernel.getConfig().getGraphDbModule().getNodeManager();
        kernel.setState(this, Neo4jMBean.initMBeans(new Neo4jMBean.Creator(kernel.instanceId(), kernel.version(), (NeoStoreXaDataSource)kernel.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb")){

            protected void create(Neo4jMBean.Factory jmx) {
                jmx.createDynamicConfigurationMBean(kernel.getConfigParams());
                jmx.createPrimitiveMBean(nodeManager);
                jmx.createStoreFileMBean();
                jmx.createCacheMBean(nodeManager);
                jmx.createLockManagerMBean(kernel.getConfig().getLockManager());
                jmx.createTransactionManagerMBean(kernel.getConfig().getTxModule());
                jmx.createMemoryMappingMBean(kernel.getConfig().getTxModule().getXaDataSourceManager());
                jmx.createXaManagerMBean(kernel.getConfig().getTxModule().getXaDataSourceManager());
            }
        }));
    }

    @Override
    protected void unload(KernelExtension.KernelData kernel) {
        ((Runnable)kernel.getState(this)).run();
    }

    public <T> T getBean(KernelExtension.KernelData kernel, Class<T> beanClass) {
        if (!this.isLoaded(kernel)) {
            throw new IllegalStateException("Not Loaded!");
        }
        return Neo4jMBean.getBean(kernel.instanceId(), beanClass);
    }
}

