/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.management;

import java.security.AccessControlException;
import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.management.Description;
import org.neo4j.kernel.impl.management.Neo4jMBean;
import org.neo4j.kernel.management.Cache;

@Description(value="Information about the caching in Neo4j")
class CacheBean
extends Neo4jMBean
implements Cache {
    private final NodeManager nodeManager;

    CacheBean(String instanceId, NodeManager nodeManager) throws NotCompliantMBeanException {
        super(instanceId, Cache.class);
        this.nodeManager = nodeManager;
    }

    @Description(value="The type of cache used by Neo4j")
    public String getCacheType() {
        return this.nodeManager.getCacheType().getDescription();
    }

    @Description(value="The number of Nodes currently in cache")
    public int getNodeCacheSize() {
        return this.nodeManager.getNodeCacheSize();
    }

    @Description(value="The number of Relationships currently in cache")
    public int getRelationshipCacheSize() {
        return this.nodeManager.getRelationshipCacheSize();
    }

    @Description(value="Clears the Neo4j caches", impact=1)
    public void clear() {
        throw new AccessControlException("Clearing cache through JMX not permitted.");
    }
}

