/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexStore {
    private static final byte[] MAGICK = new byte[]{110, 101, 111, 52, 106, 45, 105, 110, 100, 101, 120};
    private static final int VERSION = 1;
    private final File file;
    private final File oldFile;
    private final Map<String, Map<String, String>> nodeConfig = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> relConfig = new HashMap<String, Map<String, String>>();
    private ByteBuffer dontUseBuffer = ByteBuffer.allocate(100);

    public IndexStore(String graphDbStoreDir) {
        this.file = new File(new File(graphDbStoreDir), "index.db");
        this.oldFile = new File(this.file.getParentFile(), this.file.getName() + ".old");
        this.read();
    }

    private ByteBuffer buffer(int size) {
        if (this.dontUseBuffer.capacity() < size) {
            this.dontUseBuffer = ByteBuffer.allocate(size * 2);
        }
        return this.dontUseBuffer;
    }

    private void read() {
        File fileToReadFrom;
        File file = fileToReadFrom = this.file.exists() ? this.file : this.oldFile;
        if (!fileToReadFrom.exists()) {
            return;
        }
        FileChannel channel = null;
        try {
            block7: {
                try {
                    channel = new RandomAccessFile(fileToReadFrom, "r").getChannel();
                    Integer version = this.tryToReadVersion(channel);
                    if (version == null) {
                        this.close(channel);
                        channel = new RandomAccessFile(fileToReadFrom, "r").getChannel();
                        this.readMap(channel, this.nodeConfig, version);
                        this.relConfig.putAll(this.nodeConfig);
                        break block7;
                    }
                    if (version < 1) {
                        throw new UnsupportedOperationException("" + version);
                    }
                    this.readMap(channel, this.nodeConfig, this.readNextInt(channel));
                    this.readMap(channel, this.relConfig, this.readNextInt(channel));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Object var5_5 = null;
            this.close(channel);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.close(channel);
            throw throwable;
        }
    }

    private Map<String, Map<String, String>> readMap(FileChannel channel, Map<String, Map<String, String>> map, Integer sizeOrTillEof) throws IOException {
        Integer propertyCount;
        String indexName;
        for (int i = 0; (sizeOrTillEof == null || i < sizeOrTillEof) && (indexName = this.readNextString(channel)) != null && (propertyCount = this.readNextInt(channel)) != null; ++i) {
            String value;
            String key;
            HashMap<String, String> properties = new HashMap<String, String>();
            for (int p = 0; p < propertyCount && (key = this.readNextString(channel)) != null && (value = this.readNextString(channel)) != null; ++p) {
                properties.put(key, value);
            }
            map.put(indexName, properties);
        }
        return map;
    }

    private Integer tryToReadVersion(ReadableByteChannel channel) throws IOException {
        byte[] array = IoPrimitiveUtils.readBytes(channel, new byte[MAGICK.length]);
        return array != null ? this.readNextInt(channel) : null;
    }

    private void close(FileChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Integer readNextInt(ReadableByteChannel channel) throws IOException {
        return IoPrimitiveUtils.readInt(channel, this.buffer(4));
    }

    private String readNextString(ReadableByteChannel channel) throws IOException {
        return IoPrimitiveUtils.readLengthAndString(channel, this.buffer(100));
    }

    public synchronized Map<String, String> get(Class<? extends PropertyContainer> cls, String indexName) {
        return this.map(cls).get(indexName);
    }

    private Map<String, Map<String, String>> map(Class<? extends PropertyContainer> cls) {
        if (cls.equals(Node.class)) {
            return this.nodeConfig;
        }
        if (cls.equals(Relationship.class)) {
            return this.relConfig;
        }
        throw new IllegalArgumentException(cls.toString());
    }

    public Map<String, Map<String, String>> asMap(Class<? extends PropertyContainer> cls) {
        return new HashMap<String, Map<String, String>>(this.map(cls));
    }

    public synchronized void remove(Class<? extends PropertyContainer> cls, String indexName) {
        if (this.map(cls).remove(indexName) == null) {
            throw new RuntimeException("Index config for '" + indexName + "' not found");
        }
        this.write();
    }

    public synchronized boolean setIfNecessary(Class<? extends PropertyContainer> cls, String name, Map<String, String> config) {
        Map<String, Map<String, String>> map = this.map(cls);
        if (map.containsKey(name)) {
            return false;
        }
        map.put(name, config);
        this.write();
        return true;
    }

    private void write() {
        File tmpFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
        this.write(tmpFile);
        this.oldFile.delete();
        if (this.file.exists() && !this.file.renameTo(this.oldFile)) {
            throw new RuntimeException("Couldn't rename " + this.file + " -> " + this.oldFile);
        }
        if (!tmpFile.renameTo(this.file)) {
            throw new RuntimeException("Couldn't rename " + tmpFile + " -> " + this.file);
        }
        this.oldFile.delete();
    }

    private void write(File file) {
        FileChannel channel = null;
        try {
            try {
                channel = new RandomAccessFile(file, "rw").getChannel();
                channel.write(ByteBuffer.wrap(MAGICK));
                IoPrimitiveUtils.writeInt(channel, this.buffer(4), 1);
                this.writeMap(channel, this.nodeConfig);
                this.writeMap(channel, this.relConfig);
                channel.force(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Object var5_3 = null;
            this.close(channel);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.close(channel);
            throw throwable;
        }
    }

    private void writeMap(FileChannel channel, Map<String, Map<String, String>> map) throws IOException {
        IoPrimitiveUtils.writeInt(channel, this.buffer(4), map.size());
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            this.writeString(channel, entry.getKey());
            this.writeInt(channel, entry.getValue().size());
            for (Map.Entry<String, String> propertyEntry : entry.getValue().entrySet()) {
                this.writeString(channel, propertyEntry.getKey());
                this.writeString(channel, propertyEntry.getValue());
            }
        }
    }

    private void writeInt(FileChannel channel, int value) throws IOException {
        IoPrimitiveUtils.writeInt(channel, this.buffer(4), value);
    }

    private void writeString(FileChannel channel, String value) throws IOException {
        IoPrimitiveUtils.writeLengthAndString(channel, this.buffer(200), value);
    }
}

