/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelExtensionLoader;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphDbInstance {
    private boolean started = false;
    private boolean create;
    private String storeDir;
    private final Config config;
    private NioNeoDbPersistenceSource persistenceSource = null;

    GraphDbInstance(String storeDir, boolean create, Config config) {
        this.storeDir = storeDir;
        this.create = create;
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public synchronized Map<Object, Object> start(GraphDatabaseService graphDb, KernelExtensionLoader kernelExtensionLoader) {
        if (this.started) {
            throw new IllegalStateException("Neo4j instance already started");
        }
        Map<Object, Object> params = this.config.getParams();
        boolean useMemoryMapped = Boolean.parseBoolean((String)this.config.getInputParams().get("use_memory_mapped_buffers"));
        boolean dumpToConsole = Boolean.parseBoolean((String)this.config.getInputParams().get("dump_configuration"));
        this.storeDir = FileUtils.fixSeparatorsInPath(this.storeDir);
        StringLogger logger = StringLogger.getLogger(this.storeDir + "/messages.log");
        AutoConfigurator autoConfigurator = new AutoConfigurator(this.storeDir, useMemoryMapped, dumpToConsole);
        autoConfigurator.configure(GraphDbInstance.subset(this.config.getInputParams(), "use_memory_mapped_buffers"));
        params.putAll(this.config.getInputParams());
        String separator = System.getProperty("file.separator");
        String store = this.storeDir + separator + "neostore";
        params.put("store_dir", this.storeDir);
        params.put("neo_store", store);
        params.put("create", String.valueOf(this.create));
        String logicalLog = this.storeDir + separator + "nioneo_logical.log";
        params.put("logical_log", logicalLog);
        byte[] resourceId = "414141".getBytes();
        params.put(LockManager.class, this.config.getLockManager());
        params.put(LockReleaser.class, this.config.getLockReleaser());
        this.config.getTxModule().registerDataSource("nioneodb", "org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource", resourceId, params);
        if (!this.config.isReadOnly() || this.config.isBackupSlave()) {
            byte[] luceneId;
            Class<?> clazz;
            try {
                clazz = Class.forName("org.neo4j.index.lucene.LuceneDataSource");
                this.cleanWriteLocksInLuceneDirectory(this.storeDir + "/lucene");
                luceneId = "162373".getBytes();
                this.registerLuceneDataSource("lucene", clazz.getName(), this.config.getTxModule(), this.storeDir + "/lucene", this.config.getLockManager(), luceneId, params);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError err) {
                // empty catch block
            }
            try {
                clazz = Class.forName("org.neo4j.index.lucene.LuceneFulltextDataSource");
                this.cleanWriteLocksInLuceneDirectory(this.storeDir + "/lucene-fulltext");
                luceneId = "262374".getBytes();
                this.registerLuceneDataSource("lucene-fulltext", clazz.getName(), this.config.getTxModule(), this.storeDir + "/lucene-fulltext", this.config.getLockManager(), luceneId, params);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError err) {
                // empty catch block
            }
        }
        this.persistenceSource = new NioNeoDbPersistenceSource();
        this.config.setPersistenceSource("nioneodb", this.create);
        this.config.getIdGeneratorModule().setPersistenceSourceInstance(this.persistenceSource);
        this.config.getTxModule().init();
        this.config.getPersistenceModule().init();
        this.persistenceSource.init();
        this.config.getIdGeneratorModule().init();
        this.config.getGraphDbModule().init();
        kernelExtensionLoader.load(params);
        this.config.getTxModule().start();
        this.config.getPersistenceModule().start(this.config.getTxModule().getTxManager(), this.persistenceSource, this.config.getSyncHookFactory());
        this.persistenceSource.start(this.config.getTxModule().getXaDataSourceManager());
        this.config.getIdGeneratorModule().start();
        this.config.getGraphDbModule().start(this.config.getLockReleaser(), this.config.getPersistenceModule().getPersistenceManager(), this.config.getRelationshipTypeCreator(), params);
        logger.logMessage("--- CONFIGURATION START ---");
        logger.logMessage(autoConfigurator.getNiceMemoryInformation());
        logger.logMessage("Kernel version: " + Version.get());
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        logger.logMessage("Operating System: " + os.getName() + "; version: " + os.getVersion() + "; arch: " + os.getArch());
        logger.logMessage("VM Name: " + runtime.getVmName());
        logger.logMessage("VM Vendor: " + runtime.getVmVendor());
        logger.logMessage("VM Version: " + runtime.getVmVersion());
        if (runtime.isBootClassPathSupported()) {
            logger.logMessage("Boot Class Path: " + runtime.getBootClassPath());
        }
        logger.logMessage("Class Path: " + runtime.getClassPath());
        logger.logMessage("Library Path: " + runtime.getLibraryPath());
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            logger.logMessage("Garbage Collector: " + gcBean.getName() + ": " + Arrays.toString(gcBean.getMemoryPoolNames()));
        }
        logger.logMessage("VM Arguments: " + runtime.getInputArguments());
        logger.logMessage("");
        this.logConfiguration(params, logger, dumpToConsole);
        logger.logMessage("--- CONFIGURATION END ---");
        this.started = true;
        return Collections.unmodifiableMap(params);
    }

    private static Map<Object, Object> subset(Map<Object, Object> source, String ... keys) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (String key : keys) {
            if (!source.containsKey(key)) continue;
            result.put(key, source.get(key));
        }
        return result;
    }

    private void logConfiguration(Map<Object, Object> params, StringLogger logger, boolean dumpToConsole) {
        TreeSet<String> stringKeys = new TreeSet<String>();
        for (Object object : params.keySet()) {
            if (!(object instanceof String)) continue;
            stringKeys.add((String)object);
        }
        for (String string : stringKeys) {
            Object value = params.get(string);
            String mess = string + "=" + value;
            if (dumpToConsole) {
                System.out.println(mess);
            }
            logger.logMessage(mess);
        }
    }

    private void cleanWriteLocksInLuceneDirectory(String luceneDir) {
        File dir = new File(luceneDir);
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.cleanWriteLocksInLuceneDirectory(file.getAbsolutePath());
                continue;
            }
            if (!file.getName().equals("write.lock")) continue;
            boolean success = file.delete();
            assert (success);
        }
    }

    private XaDataSource registerLuceneDataSource(String name, String className, TxModule txModule, String luceneDirectory, LockManager lockManager, byte[] resourceId, Map<Object, Object> params) {
        params.put("dir", luceneDirectory);
        params.put(LockManager.class, lockManager);
        return txModule.registerDataSource(name, className, resourceId, params, true);
    }

    public boolean started() {
        return this.started;
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.config.getGraphDbModule().stop();
            this.config.getIdGeneratorModule().stop();
            this.persistenceSource.stop();
            this.config.getPersistenceModule().stop();
            this.config.getTxModule().stop();
            this.config.getGraphDbModule().destroy();
            this.config.getIdGeneratorModule().destroy();
            this.persistenceSource.destroy();
            this.config.getPersistenceModule().destroy();
            this.config.getTxModule().destroy();
        }
        this.started = false;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.config.getGraphDbModule().getRelationshipTypes();
    }

    public boolean transactionRunning() {
        try {
            return this.config.getTxModule().getTxManager().getTransaction() != null;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.config.getTxModule().getTxManager();
    }
}

