/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.neo4j.helpers.collection.CachingIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingIterator<T>
extends CachingIterator<T> {
    private final int pageSize;

    public PagingIterator(Iterator<T> source, int pageSize) {
        super(source);
        this.pageSize = pageSize;
    }

    public int page() {
        return this.position() / this.pageSize;
    }

    public int page(int newPage) {
        int previousPage = this.page();
        this.position(newPage * this.pageSize);
        return previousPage;
    }

    public Iterator<T> nextPage() {
        this.page(this.page());
        return new PrefetchingIterator<T>(){
            private final int end;
            {
                this.end = PagingIterator.this.position() + PagingIterator.this.pageSize;
            }

            @Override
            protected T fetchNextOrNull() {
                if (PagingIterator.this.position() >= this.end) {
                    return null;
                }
                return PagingIterator.this.hasNext() ? (Object)PagingIterator.this.next() : null;
            }
        };
    }
}

