/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingIterator<T>
implements ListIterator<T> {
    private final Iterator<T> source;
    private final List<T> visited = new ArrayList<T>();
    private int position;
    private T current;

    public CachingIterator(Iterator<T> source) {
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        return this.visited.size() > this.position ? true : this.source.hasNext();
    }

    @Override
    public T next() {
        if (this.visited.size() > this.position) {
            this.current = this.visited.get(this.position);
        } else {
            if (!this.source.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.source.next();
            this.visited.add(this.current);
        }
        ++this.position;
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public int position(int newPosition) {
        if (newPosition < 0) {
            throw new IllegalArgumentException("Position must be non-negative, was " + newPosition);
        }
        int previousPosition = this.position;
        boolean overTheEdge = false;
        while (this.visited.size() < newPosition) {
            Object next;
            Object e = next = this.source.hasNext() ? (Object)this.source.next() : null;
            if (next != null) {
                this.visited.add(next);
                continue;
            }
            if (!overTheEdge) {
                overTheEdge = true;
                continue;
            }
            throw new NoSuchElementException("Requested position " + newPosition + ", but didn't get further than to " + this.visited.size());
        }
        this.current = null;
        this.position = newPosition;
        return previousPosition;
    }

    @Override
    public boolean hasPrevious() {
        return this.position > 0;
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Position is " + this.position);
        }
        this.current = this.visited.get(--this.position);
        return this.current;
    }

    public T current() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    @Override
    public int nextIndex() {
        return this.position;
    }

    @Override
    public int previousIndex() {
        return this.position - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T e) {
        throw new UnsupportedOperationException();
    }
}

