/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.helpers.ExtensionLoader;
import org.neo4j.helpers.collection.FilteringIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.NestingIterable;
import org.neo4j.helpers.collection.PrefetchingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Service {
    public static ExtensionLoader osgiExtensionLoader;
    final Set<String> keys;

    public static <T> Iterable<T> load(Class<T> type) {
        Iterable<T> loader = Service.osgiLoader(type);
        if (null != loader) {
            return loader;
        }
        loader = Service.java6Loader(type);
        if (null != loader) {
            return loader;
        }
        loader = Service.sunJava5Loader(type);
        if (null != loader) {
            return loader;
        }
        loader = Service.ourOwnLoader(type);
        if (null != loader) {
            return loader;
        }
        return Collections.emptyList();
    }

    public static <T extends Service> T load(Class<T> type, String key) {
        for (Service impl : Service.load(type)) {
            if (!impl.matches(key)) continue;
            return (T)impl;
        }
        throw new NoSuchElementException(String.format("Could not find any implementation of %s with a key=\"%s\"", type.getName(), key));
    }

    protected Service(String key, String ... altKeys) {
        if (altKeys == null || altKeys.length == 0) {
            this.keys = Collections.singleton(key);
        } else {
            this.keys = new HashSet<String>(Arrays.asList(altKeys));
            this.keys.add(key);
        }
    }

    public String toString() {
        return this.getClass().getSuperclass().getName() + "" + this.keys;
    }

    boolean matches(String key) {
        return this.keys.contains(key);
    }

    private static <T> Iterable<T> filterExceptions(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new PrefetchingIterator<T>(){
                    final Iterator<T> iterator;
                    {
                        this.iterator = iterable.iterator();
                    }

                    @Override
                    protected T fetchNextOrNull() {
                        while (this.iterator.hasNext()) {
                            try {
                                return this.iterator.next();
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        return null;
                    }
                };
            }
        };
    }

    private static <T> Iterable<T> osgiLoader(Class<T> type) {
        if (osgiExtensionLoader != null) {
            return osgiExtensionLoader.loadExtensionsOfType(type);
        }
        return null;
    }

    private static <T> Iterable<T> java6Loader(Class<T> type) {
        try {
            Iterable result = (Iterable)Class.forName("java.util.ServiceLoader").getMethod("load", Class.class).invoke(null, type);
            return Service.filterExceptions(result);
        }
        catch (Exception e) {
            return null;
        }
        catch (LinkageError e) {
            return null;
        }
    }

    private static <T> Iterable<T> sunJava5Loader(final Class<T> type) {
        Method providers;
        try {
            providers = Class.forName("sun.misc.Service").getMethod("providers", Class.class);
        }
        catch (Exception e) {
            return null;
        }
        catch (LinkageError e) {
            return null;
        }
        return Service.filterExceptions(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                try {
                    Iterator result = (Iterator)providers.invoke(null, type);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke sun.misc.Service.providers(forClass)", e);
                }
            }
        });
    }

    private static <T> Iterable<T> ourOwnLoader(final Class<T> type) {
        LinkedList<URL> urls = new LinkedList<URL>();
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + type.getName());
            while (resources.hasMoreElements()) {
                urls.add(resources.nextElement());
            }
        }
        catch (IOException e) {
            return null;
        }
        return new NestingIterable<T, BufferedReader>(FilteringIterable.notNull(new IterableWrapper<BufferedReader, URL>(urls){

            @Override
            protected BufferedReader underlyingObjectToObject(URL url) {
                try {
                    return new BufferedReader(new InputStreamReader(url.openStream()));
                }
                catch (IOException e) {
                    return null;
                }
            }
        })){

            @Override
            protected Iterator<T> createNestedIterator(final BufferedReader input) {
                return new PrefetchingIterator<T>(){

                    @Override
                    protected T fetchNextOrNull() {
                        try {
                            String line;
                            while (null != (line = input.readLine())) {
                                try {
                                    return type.cast(Class.forName(line).newInstance());
                                }
                                catch (Exception e) {
                                }
                                catch (LinkageError linkageError) {
                                }
                            }
                            return null;
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                };
            }
        };
    }

    public static abstract class CaseInsensitiveService
    extends Service {
        protected CaseInsensitiveService(String key, String ... altKeys) {
            super(key, altKeys);
        }

        final boolean matches(String key) {
            for (String id : this.keys) {
                if (!id.equalsIgnoreCase(key)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Implementation {
        public Class<?>[] value();
    }
}

