/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import javax.transaction.xa.XAException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

public abstract class XaTransaction {
    private final int identifier;
    private final XaLogicalLog log;
    private boolean isRecovered = false;
    private boolean committed = false;
    private boolean rolledback = false;
    private boolean prepared = false;

    public abstract boolean isReadOnly();

    protected abstract void doAddCommand(XaCommand var1);

    protected abstract void doRollback() throws XAException;

    protected abstract void doPrepare() throws XAException;

    protected abstract void doCommit() throws XAException;

    public XaTransaction(int identifier, XaLogicalLog log) {
        if (log == null) {
            throw new IllegalArgumentException("LogicalLog is null");
        }
        this.identifier = identifier;
        this.log = log;
    }

    protected void setRecovered() {
        this.isRecovered = true;
    }

    public boolean isRecovered() {
        return this.isRecovered;
    }

    public final int getIdentifier() {
        return this.identifier;
    }

    public final void addCommand(XaCommand command) {
        if (this.committed) {
            throw new TransactionFailureException("Cannot add command to committed transaction");
        }
        if (this.rolledback) {
            throw new TransactionFailureException("Cannot add command to rolled back transaction");
        }
        this.doAddCommand(command);
        try {
            this.log.writeCommand(command, this.identifier);
        }
        catch (IOException e) {
            throw new TransactionFailureException("Unable to write command to logical log.", e);
        }
    }

    protected void injectCommand(XaCommand command) {
        this.doAddCommand(command);
    }

    public final void rollback() throws XAException {
        if (this.committed) {
            throw new XAException("Cannot rollback partialy commited transaction. Recover and commit");
        }
        this.rolledback = true;
        this.doRollback();
    }

    public final void prepare() throws XAException {
        if (this.committed) {
            throw new XAException("Cannot prepare comitted transaction");
        }
        if (this.rolledback) {
            throw new XAException("Cannot prepare rolled back transaction");
        }
        this.prepared = true;
        this.doPrepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws XAException {
        if (!this.prepared && !this.isRecovered()) {
            throw new XAException("Cannot commit unprepared transaction");
        }
        this.log.registerTxIdentifier(this.getIdentifier());
        try {
            this.committed = true;
            this.doCommit();
        }
        finally {
            this.log.unregisterTxIdentifier();
        }
    }
}

