/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.transaction.LockException;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipImpl
extends Primitive {
    private final int startNodeId;
    private final int endNodeId;
    private final RelationshipType type;

    RelationshipImpl(int id, int startNodeId, int endNodeId, RelationshipType type, boolean newRel) {
        super(id, newRel);
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (startNodeId == endNodeId) {
            throw new IllegalArgumentException("Start node equals end node");
        }
        this.startNodeId = startNodeId;
        this.endNodeId = endNodeId;
        this.type = type;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelationshipImpl && ((RelationshipImpl)obj).id == this.id;
    }

    @Override
    protected void changeProperty(NodeManager nodeManager, int propertyId, Object value) {
        nodeManager.relChangeProperty(this, propertyId, value);
    }

    @Override
    protected int addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
        return nodeManager.relAddProperty(this, index, value);
    }

    @Override
    protected void removeProperty(NodeManager nodeManager, int propertyId) {
        nodeManager.relRemoveProperty(this, propertyId);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
        return nodeManager.loadProperties(this, light);
    }

    public Node[] getNodes(NodeManager nodeManager) {
        return new Node[]{new NodeProxy(this.startNodeId, nodeManager), new NodeProxy(this.endNodeId, nodeManager)};
    }

    public Node getOtherNode(NodeManager nodeManager, Node node) {
        if (this.startNodeId == (int)node.getId()) {
            return new NodeProxy(this.endNodeId, nodeManager);
        }
        if (this.endNodeId == (int)node.getId()) {
            return new NodeProxy(this.startNodeId, nodeManager);
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    public Node getStartNode(NodeManager nodeManager) {
        return new NodeProxy(this.startNodeId, nodeManager);
    }

    int getStartNodeId() {
        return this.startNodeId;
    }

    public Node getEndNode(NodeManager nodeManager) {
        return new NodeProxy(this.endNodeId, nodeManager);
    }

    int getEndNodeId() {
        return this.endNodeId;
    }

    public RelationshipType getType() {
        return this.type;
    }

    public boolean isType(RelationshipType otherType) {
        return otherType != null && otherType.name().equals(this.getType().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NodeManager nodeManager) {
        boolean releaseFailed2;
        NodeImpl startNode = null;
        NodeImpl endNode = null;
        boolean startNodeLocked = false;
        boolean endNodeLocked = false;
        nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            startNode = nodeManager.getLightNode(this.startNodeId);
            if (startNode != null) {
                nodeManager.acquireLock(startNode, LockType.WRITE);
                startNodeLocked = true;
            }
            if ((endNode = nodeManager.getLightNode(this.endNodeId)) != null) {
                nodeManager.acquireLock(endNode, LockType.WRITE);
                endNodeLocked = true;
            }
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this, true);
            ArrayMap<Integer, PropertyData> removedProps = nodeManager.deleteRelationship(this);
            if (removedProps.size() > 0) {
                for (int index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
            if (startNode != null) {
                startNode.removeRelationship(nodeManager, this.type, this.id);
            }
            if (endNode != null) {
                endNode.removeRelationship(nodeManager, this.type, this.id);
            }
            success = true;
            Object var12_11 = null;
            releaseFailed2 = false;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            boolean releaseFailed2 = false;
            try {
                if (startNodeLocked) {
                    nodeManager.releaseLock(startNode, LockType.WRITE);
                }
            }
            catch (Exception e) {
                releaseFailed2 = true;
                e.printStackTrace();
            }
            try {
                if (endNodeLocked) {
                    nodeManager.releaseLock(endNode, LockType.WRITE);
                }
            }
            catch (Exception e) {
                releaseFailed2 = true;
                e.printStackTrace();
            }
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
            if (releaseFailed2) {
                throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship delete->" + this);
            }
            throw throwable;
        }
        try {
            if (startNodeLocked) {
                nodeManager.releaseLock(startNode, LockType.WRITE);
            }
        }
        catch (Exception e) {
            releaseFailed2 = true;
            e.printStackTrace();
        }
        try {
            if (endNodeLocked) {
                nodeManager.releaseLock(endNode, LockType.WRITE);
            }
        }
        catch (Exception e) {
            releaseFailed2 = true;
            e.printStackTrace();
        }
        nodeManager.releaseLock(this, LockType.WRITE);
        if (!success) {
            nodeManager.setRollbackOnly();
        }
        if (releaseFailed2) {
            throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship delete->" + this);
        }
    }

    public String toString() {
        return "RelationshipImpl #" + this.getId() + " of type " + this.type + " between Node[" + this.startNodeId + "] and Node[" + this.endNodeId + "]";
    }
}

