/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.ReferenceCache;
import org.neo4j.kernel.impl.cache.SoftLruCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveCacheManager {
    private static final Logger log = Logger.getLogger(AdaptiveCacheManager.class.getName());
    private float decreaseRatio = 1.15f;
    private float increaseRatio = 1.1f;
    private final List<AdaptiveCacheElement> caches = new LinkedList<AdaptiveCacheElement>();
    private final List<ReferenceCache<?, ?>> referenceCaches = new ArrayList();
    private AdaptiveCacheWorker workerThread;

    public synchronized void registerCache(Cache<?, ?> cache, float ratio, int minSize) {
        if (cache == null || ratio >= 1.0f || ratio <= 0.0f || minSize < 0) {
            throw new IllegalArgumentException(" cache=" + cache + " ratio =" + ratio + " minSize=" + minSize);
        }
        if (cache instanceof ReferenceCache) {
            this.referenceCaches.add((ReferenceCache)cache);
            return;
        }
        for (AdaptiveCacheElement element : this.caches) {
            if (element.getCache() != cache) continue;
            log.fine("Cache[" + cache.getName() + "] already registered.");
            return;
        }
        AdaptiveCacheElement element = new AdaptiveCacheElement(cache, ratio, minSize);
        this.caches.add(element);
        cache.setAdaptiveStatus(true);
        log.fine("Cache[" + cache.getName() + "] threshold=" + ratio + "minSize=" + minSize + " registered.");
    }

    public synchronized void unregisterCache(Cache<?, ?> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Null cache");
        }
        if (cache instanceof SoftLruCache) {
            this.referenceCaches.remove(cache);
            return;
        }
        Iterator<AdaptiveCacheElement> itr = this.caches.iterator();
        while (itr.hasNext()) {
            AdaptiveCacheElement element = itr.next();
            if (element.getCache() != cache) continue;
            itr.remove();
            break;
        }
        log.fine("Cache[" + cache.getName() + "] removed.");
    }

    synchronized AdaptiveCacheElement getAdaptiveCacheElementIndex(Cache<?, ?> cache) {
        for (AdaptiveCacheElement element : this.caches) {
            if (element.getCache() != cache) continue;
            return element;
        }
        return null;
    }

    private void parseParams(Map<Object, Object> params) {
        Object value;
        if (params == null) {
            return;
        }
        if (params.containsKey("adaptive_cache_worker_sleep_time")) {
            value = params.get("adaptive_cache_worker_sleep_time");
            int sleepTime = 3000;
            try {
                sleepTime = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse apdaptive_cache_worker_sleep_time " + value);
            }
            this.workerThread.setSleepTime(sleepTime);
        }
        if (params.containsKey("adaptive_cache_manager_decrease_ratio")) {
            value = params.get("adaptive_cache_manager_decrease_ratio");
            try {
                this.decreaseRatio = Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse adaptive_cache_manager_decrease_ratio " + value);
            }
            if (this.decreaseRatio < 1.0f) {
                this.decreaseRatio = 1.0f;
            }
        }
        if (params.containsKey("adaptive_cache_manager_increase_ratio")) {
            value = params.get("adaptive_cache_manager_increase_ratio");
            try {
                this.increaseRatio = Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse adaptive_cache_manager_increase_ratio " + value);
            }
            if (this.increaseRatio < 1.0f) {
                this.increaseRatio = 1.0f;
            }
        }
    }

    public void start(Map<Object, Object> params) {
        this.workerThread = new AdaptiveCacheWorker();
        this.parseParams(params);
        this.workerThread.start();
    }

    public void stop() {
        this.workerThread.markDone();
        this.workerThread = null;
    }

    Collection<AdaptiveCacheElement> getCaches() {
        return this.caches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaptCaches() {
        LinkedList<AdaptiveCacheElement> copy = new LinkedList<AdaptiveCacheElement>();
        AdaptiveCacheManager adaptiveCacheManager = this;
        synchronized (adaptiveCacheManager) {
            copy.addAll(this.caches);
        }
        for (AdaptiveCacheElement element : copy) {
            this.adaptCache(element);
        }
    }

    public synchronized void adaptReferenceCaches() {
        for (ReferenceCache<?, ?> cache : this.referenceCaches) {
            cache.pollClearedValues();
        }
    }

    public void adaptCache(Cache<?, ?> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Null cache");
        }
        AdaptiveCacheElement element = this.getAdaptiveCacheElementIndex(cache);
        if (element != null) {
            this.adaptCache(element);
        }
    }

    private void adaptCache(AdaptiveCacheElement element) {
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        float ratio = (float)(max - free) / (float)max;
        float allocationRatio = (float)total / (float)max;
        if (allocationRatio < element.getRatio()) {
            ratio = 0.0f;
        }
        if (ratio > element.getRatio()) {
            int minSize;
            Cache<?, ?> cache = element.getCache();
            int newCacheSize = (int)((float)cache.maxSize() / this.decreaseRatio / (1.0f + (ratio - element.getRatio())));
            if (newCacheSize < (minSize = element.minSize())) {
                log.fine("Cache[" + cache.getName() + "] cannot decrease under " + minSize + " (allocation ratio=" + allocationRatio + " threshold status=" + ratio + ")");
                cache.resize(minSize);
                cache.resize(minSize + 1000);
                return;
            }
            if (newCacheSize + 1200 > cache.size()) {
                newCacheSize = cache.size() - 1200 >= minSize ? cache.size() - 1200 : minSize;
            }
            log.fine("Cache[" + cache.getName() + "] decreasing from " + cache.size() + " to " + newCacheSize + " (allocation ratio=" + allocationRatio + " threshold status=" + ratio + ")");
            if (newCacheSize <= 1000) {
                cache.clear();
            } else {
                cache.resize(newCacheSize);
            }
            cache.resize(newCacheSize + 1000);
        } else {
            Cache<?, ?> cache = element.getCache();
            if ((float)cache.size() / (float)cache.maxSize() < 0.9f) {
                return;
            }
            int newCacheSize = (int)((float)cache.maxSize() * this.increaseRatio);
            log.fine("Cache[" + cache.getName() + "] increasing from " + cache.size() + " to " + newCacheSize + " (allocation ratio=" + allocationRatio + " threshold status=" + ratio + ")");
            cache.resize(newCacheSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdaptiveCacheElement {
        private final Cache<?, ?> cache;
        private final float ratio;
        private final int minSize;

        AdaptiveCacheElement(Cache<?, ?> cache, float ratio, int minSize) {
            this.cache = cache;
            this.ratio = ratio;
            this.minSize = minSize;
        }

        String getName() {
            return this.cache.getName();
        }

        Cache<?, ?> getCache() {
            return this.cache;
        }

        float getRatio() {
            return this.ratio;
        }

        int minSize() {
            return this.minSize;
        }
    }

    private class AdaptiveCacheWorker
    extends Thread {
        private boolean done;
        private int sleepTime;

        AdaptiveCacheWorker() {
            super("AdaptiveCacheWorker");
            this.done = false;
            this.sleepTime = 3000;
        }

        void setSleepTime(int sleepTime) {
            this.sleepTime = sleepTime;
        }

        public synchronized void run() {
            while (!this.done) {
                try {
                    AdaptiveCacheManager.this.adaptReferenceCaches();
                    AdaptiveCacheManager.this.adaptCaches();
                    this.wait(this.sleepTime);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }

        void markDone() {
            this.done = true;
        }
    }
}

