/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphDbInstance {
    private boolean started = false;
    private boolean create;
    private String storeDir;
    private Config config = null;
    private NioNeoDbPersistenceSource persistenceSource = null;

    GraphDbInstance(String storeDir, boolean create) {
        this.storeDir = storeDir;
        this.create = create;
    }

    public Config getConfig() {
        return this.config;
    }

    private Map<Object, Object> getDefaultParams() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("neostore.nodestore.db.mapped_memory", "20M");
        params.put("neostore.propertystore.db.mapped_memory", "90M");
        params.put("neostore.propertystore.db.index.mapped_memory", "1M");
        params.put("neostore.propertystore.db.index.keys.mapped_memory", "1M");
        params.put("neostore.propertystore.db.strings.mapped_memory", "130M");
        params.put("neostore.propertystore.db.arrays.mapped_memory", "130M");
        params.put("neostore.relationshipstore.db.mapped_memory", "100M");
        String nameOs = System.getProperty("os.name");
        if (nameOs.startsWith("Windows")) {
            params.put("use_memory_mapped_buffers", "false");
        }
        return params;
    }

    public synchronized Map<Object, Object> start(GraphDatabaseService graphDb, Map<String, String> stringParams, KernelPanicEventGenerator kpe, TxEventSyncHookFactory syncHookFactory) {
        if (this.started) {
            throw new IllegalStateException("Neo4j instance already started");
        }
        Map<Object, Object> params = this.getDefaultParams();
        boolean useMemoryMapped = true;
        if (stringParams.containsKey("use_memory_mapped_buffers")) {
            params.put("use_memory_mapped_buffers", stringParams.get("use_memory_mapped_buffers"));
        }
        if ("false".equals(params.get("use_memory_mapped_buffers"))) {
            useMemoryMapped = false;
        }
        boolean dump = false;
        if ("true".equals(stringParams.get("dump_configuration"))) {
            dump = true;
        }
        this.storeDir = FileUtils.fixSeparatorsInPath(this.storeDir);
        new AutoConfigurator(this.storeDir, useMemoryMapped, dump).configure(params);
        for (Map.Entry<String, String> entry : stringParams.entrySet()) {
            params.put(entry.getKey(), entry.getValue());
        }
        this.config = new Config(graphDb, this.storeDir, params, kpe);
        String separator = System.getProperty("file.separator");
        String store = this.storeDir + separator + "neostore";
        params.put("store_dir", this.storeDir);
        params.put("neo_store", store);
        params.put("create", String.valueOf(this.create));
        String logicalLog = this.storeDir + separator + "nioneo_logical.log";
        params.put("logical_log", logicalLog);
        byte[] resourceId = "414141".getBytes();
        params.put(LockManager.class, this.config.getLockManager());
        params.put(LockReleaser.class, this.config.getLockReleaser());
        this.config.getTxModule().registerDataSource("nioneodb", "org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource", resourceId, params);
        if (!this.config.isReadOnly() || this.config.isBackupSlave()) {
            byte[] luceneId;
            Class<?> clazz;
            try {
                clazz = Class.forName("org.neo4j.index.lucene.LuceneDataSource");
                this.cleanWriteLocksInLuceneDirectory(this.storeDir + "/lucene");
                luceneId = "162373".getBytes();
                this.registerLuceneDataSource("lucene", clazz.getName(), this.config.getTxModule(), this.storeDir + "/lucene", this.config.getLockManager(), luceneId, params);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError err) {
                // empty catch block
            }
            try {
                clazz = Class.forName("org.neo4j.index.lucene.LuceneFulltextDataSource");
                this.cleanWriteLocksInLuceneDirectory(this.storeDir + "/lucene-fulltext");
                luceneId = "262374".getBytes();
                this.registerLuceneDataSource("lucene-fulltext", clazz.getName(), this.config.getTxModule(), this.storeDir + "/lucene-fulltext", this.config.getLockManager(), luceneId, params);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError err) {
                // empty catch block
            }
            try {
                Class<?> cls = Class.forName("org.neo4j.index.impl.lucene.LuceneDataSource");
                this.config.getTxModule().registerDataSource("lucene-index", cls.getName(), "162374".getBytes(), this.config.getParams());
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError err) {
                // empty catch block
            }
        }
        this.persistenceSource = new NioNeoDbPersistenceSource();
        this.config.setPersistenceSource("nioneodb", this.create);
        this.config.getIdGeneratorModule().setPersistenceSourceInstance(this.persistenceSource);
        this.config.getTxModule().init();
        this.config.getPersistenceModule().init();
        this.persistenceSource.init();
        this.config.getIdGeneratorModule().init();
        this.config.getGraphDbModule().init();
        this.config.getTxModule().start();
        this.config.getPersistenceModule().start(this.config.getTxModule().getTxManager(), this.persistenceSource, syncHookFactory);
        this.persistenceSource.start(this.config.getTxModule().getXaDataSourceManager());
        this.config.getIdGeneratorModule().start();
        this.config.getGraphDbModule().start(this.config.getLockReleaser(), this.config.getPersistenceModule().getPersistenceManager(), params);
        if ("true".equals(params.get("dump_configuration"))) {
            for (Object key : params.keySet()) {
                Object value;
                if (!(key instanceof String) || !((value = params.get(key)) instanceof String)) continue;
                System.out.println(key + "=" + value);
            }
        }
        if (this.config.getTxModule().getXaDataSourceManager().hasDataSource("lucene-index")) {
            this.config.getTxModule().getXaDataSourceManager().unregisterDataSource("lucene-index");
        }
        this.started = true;
        return Collections.unmodifiableMap(params);
    }

    private void cleanWriteLocksInLuceneDirectory(String luceneDir) {
        File dir = new File(luceneDir);
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.cleanWriteLocksInLuceneDirectory(file.getAbsolutePath());
                continue;
            }
            if (!file.getName().equals("write.lock")) continue;
            boolean success = file.delete();
            assert (success);
        }
    }

    private XaDataSource registerLuceneDataSource(String name, String className, TxModule txModule, String luceneDirectory, LockManager lockManager, byte[] resourceId, Map<Object, Object> params) {
        params.put("dir", luceneDirectory);
        params.put(LockManager.class, lockManager);
        return txModule.registerDataSource(name, className, resourceId, params, true);
    }

    public boolean started() {
        return this.started;
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.config.getGraphDbModule().stop();
            this.config.getIdGeneratorModule().stop();
            this.persistenceSource.stop();
            this.config.getPersistenceModule().stop();
            this.config.getTxModule().stop();
            this.config.getGraphDbModule().destroy();
            this.config.getIdGeneratorModule().destroy();
            this.persistenceSource.destroy();
            this.config.getPersistenceModule().destroy();
            this.config.getTxModule().destroy();
        }
        this.started = false;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.config.getGraphDbModule().getRelationshipTypes();
    }

    public boolean transactionRunning() {
        try {
            return this.config.getTxModule().getTxManager().getTransaction() != null;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.config.getTxModule().getTxManager();
    }
}

